from parallels.core.utils.message_utils import single_line_message, multi_line_message

LOG_EXCEPTION = single_line_message("""
	Exception:
""")
EXCEPTION_PARALLEL_EXECUTION = single_line_message("""
	Unable to execute command in parallel in scope of the same session
""")
ACTION_GET_PROGRESS = single_line_message("""
	Get operation progress in current session
""")
ACTION_GET_PROGRESS_FAILED = single_line_message("""
	Unable to retrive operation progress in current session
""")
ACTION_GET_PROGRESS_DATA = single_line_message("""
	Last executed command is {command}, it has status {status}
""")
ACTION_GET_PROGRESS_NONE = single_line_message("""
	No one command was executed
""")
ACTION_READ_IP_MAPPING = single_line_message("""
	Read IP mapping file
""")
ACTION_READ_IP_MAPPING_FAILED = single_line_message("""
	Failed to read IP mapping file
""")
ACTION_READ_IP_MAPPING_READ_IP_MAPPING_FILE = single_line_message("""
	Read IP-mapping file {ip_mapping_file}
""")
ACTION_READ_IP_MAPPING_IP_MAPPING_FILE_NOT_EXIST = single_line_message("""
	IP-mapping file {ip_mapping_file} does not exist. Please specify correct location of IP mapping file via
	--ip-mapping-file option
""")
ACTION_STOP_TRANSFER_AGENTS = single_line_message("""
	Stop remote Windows agents
""")
ACTION_STOP_TRANSFER_AGENTS_FAILED = single_line_message("""
	Failed to stop remote Windows agents
""")
ACTION_START_TRANSFER_AGENTS = single_line_message("""
	Start remote Windows agents
""")
ACTION_START_TRANSFER_AGENTS_FAILED = single_line_message("""
	Failed to start remote Windows agents
""")
ACTION_CALLBACK = single_line_message("""
	Initiate callback from source server
""")
ACTION_CALLBACK_FAILED = single_line_message("""
	Failed to initiate callback from source server
""")
COMMAND_GET_PROGRESS = single_line_message("""
	Get progress of previously executed command in current session
""")
COMMAND_START_TRANSFER_AGENT = single_line_message("""
	Deploy and start transfer agents on all Windows servers
""")
COMMAND_ANALYSE_HOSTING = single_line_message("""
	Analyse source and destination nodes for using effective migration strategy
""")
COMMAND_CALLBACK = single_line_message("""
	Initiate callback of given command from first source server via transfer agent
""")
DOWNLOAD_DUMP_AGENT = single_line_message("""
	Download dump agent installer from {url}
""")
UPLOAD_DUMP_AGENT = single_line_message("""
	Upload dump agent installer to {path} at {server}
""")
INSTALL_DUMP_AGENT = single_line_message("""
	Install dump agent at {server}
""")
DOWNLOAD_RSYNC = single_line_message("""
	Download rsync installer from {url}
""")
UPLOAD_RSYNC = single_line_message("""
	Upload rsync installer to {path} at {server}
""")
INSTALL_RSYNC = single_line_message("""
	Install rsync at {server}
""")
DOWNLOAD_PSAMAIL = single_line_message("""
	Download {name} package from {url}
""")
DOWNLOAD_PYTHON = single_line_message("""
	Download python package from {url}
""")
DOWNLOAD_7ZIP = single_line_message("""
	Download 7zip package from {url}
""")
DOWNLOAD_TRANSFER_AGENT = single_line_message("""
	Download transfer agent package from {url}
""")
DOWNLOAD_PAEXEC = single_line_message("""
	Download paexec from {url}
""")
MIGRATION_TOOLS_TRIED_PERFORM_OPERATION_IN = single_line_message("""
	Migration tools tried to perform operation in %s attempts.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER_2 = single_line_message("""
	Failed to migrate service plan that the reseller of this plan is assigned to.
""")
FAILED_MIGRATE_RESELLER_THAT_OWNS_CLIENT_1 = single_line_message("""
	Failed to migrate reseller that owns client of this subscription.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER_1 = single_line_message("""
	Failed to migrate service plan that the reseller that owns client of this subscription is assigned to.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER = single_line_message("""
	Failed to migrate service plan that the reseller that owns this client is assigned to.
""")
FAILED_MIGRATE_RESELLER_PLAN = single_line_message("""
	Failed to migrate reseller of this plan.
""")
FAILED_PERFORM_AN_ACTION_AUXILIARY_USER = single_line_message("""
	Failed to perform an action on auxiliary user '%s' of client '%s'
""")
FAILED_MIGRATE_SERVICE_PLAN_RESELLER_IS = single_line_message("""
	Failed to migrate service plan this reseller is assigned to.
""")
FAILED_MIGRATE_CLIENT_SUBSCRIPTION = single_line_message("""
	Failed to migrate client of this subscription.
""")
FAILED_MIGRATE_RESELLER_THAT_OWNS_CLIENT = single_line_message("""
	Failed to migrate reseller that owns this client.
""")
FAILED_MIGRATE_SERVICE_PLAN_SUBSCRIPTION = single_line_message("""
	Failed to migrate service plan of this subscription.
""")
FAILED_TO_CREATE_RESELLER_ON_TARGET = single_line_message("""
	Failed to create reseller in %s.
""")
AUTO_GENERATED_CUSTOMER_COMMENT = single_line_message("""
	automatically generated special account which will receive %s's subscriptions
""")
ALREADY_EXISTS_IN_TARGET_PANEL = single_line_message("""
	already exists in the target panel
""")
LINE_S_SUBSCRIPTION_S_IS_NOT_1 = single_line_message("""
	Line %s: subscription '%s' is not assigned to a plan. Custom subscriptions are not supported
""")
EXISTING_HOSTING_PLANS_NOT_USED_BY = single_line_message("""
	Existing hosting plans not used by any customer
""")
FILE_SPECIFIES_LIST_DOMAINS_AND_CLIENTS = multi_line_message("""
	# This file specifies a list of domains and clients to be migrated.
	# For each domain, you should specify a service plan, that is to be
	# used when creating subscription for this domain. You should also
	# specify a client, that owns the domain. Domains that are not assigned
	# to a customer, will be automatically assigned to a reseller or admin
	# account, depending on what you've specified earlier in this file.
	#
	# For each client, you should specify a reseller, that will be a vendor
	# of the corresponding customer. If you do not specify a reseller,
	# corresponding customer will be created under admin. For the examples
	# of how to specify that, consult migrator documentation.
""")
LINE_S_S_IS_NOT_VALID = single_line_message("""
	Line %s: '%s' is not a valid value for IPv4 mapping. Please specify valid IPv4 address or select one of: %s
""")
ADMIN_SUBSCRIPTIONS_AND_CUSTOMERS = single_line_message("""
	# Admin subscriptions and customers
""")
CUSTOM_SUBSCRIPTIONS_MUST_ASSOCIATED_SERVICE_TEMPLATE = single_line_message("""
	# Custom subscriptions, must be associated with a service template to be transferred
""")
LINE_S_SUBSCRIPTION_S_IS_NOT = single_line_message("""
	Line %s: subscription '%s' is not presented on source Plesks
""")
LINE_S_S_IS_NOT_VALID_1 = single_line_message("""
	Line %s: '%s' is not a valid value for IPv6 mapping. Please specify valid IPv6 address or select one of: %s
""")
DOS_CHARSET_CP_UNAVAILABLE_USING_ASCII = multi_line_message("""
	dos charset 'CP850' unavailable - using ASCII
	
""")
COMMAND_S_FAILED_EXECUTE_S_ERROR_1 = single_line_message("""
	Command '%s' failed to execute with '%s' error. Please check that connection settings for server '%s' are correct in
	config.ini
""")
COMMAND_S_FAILED_EXECUTE_S_ERROR_2 = single_line_message("""
	Command '%s' failed to execute with '%s' error
""")
COMMAND_COMMANDWHERE_RETURNED_NONZERO_EXIT_CODE = multi_line_message("""
	The command "{command}"{where} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	
	1. If this happened because of a network issue, re-run the migration tool.
	2. Ensure that the host is up and there are no firewall rules that may block SSH connection to the host.
	3. To investigate the issue, login to the host by SSH, run the command and look at the result.
	
""")
UNABLE_DOWNLOAD_FILE_CONTENTS_S_DIRECTORY = single_line_message("""
	Unable to download file contents to %s: directory for temporary files was not specified to WinexeRunner
""")
FAILED_CONNECT_SAMBA_SHARE_C_SERVER = multi_line_message("""
	Failed to connect to samba share C$ on server '%s': %s. 
					Check that:
					1) Correct Windows login and password are specified in config.ini.
					2) Samba service is working on the Windows server.
					
""")
EXECUTE_COMMAND_REMOTE_SERVER_PAEXEC = single_line_message("""
	Execute command on remote server with paexec
""")
FAILED_EXECUTE_REMOTE_COMMAND_RETRY_IN = single_line_message("""
	Failed to execute a remote command, retry in %d seconds
""")
FAILED_CONNECT_SERVER_S_PAEXEC_UTILITY = multi_line_message("""
	Failed to connect to server %s with paexec utility
	Check that:
	1) Correct Windows login and password are specified in config.ini.
	2) Samba service is working on the Windows server.
""")
FAILED_TO_CONNECT_TO_SERVER_WITH_TRANSFER_AGENT = single_line_message("""
	Failed to connect to server {server} with panel transfer agent
""")
RUNNER_DOES_NOT_SUPPORT_STDIN_CONTENT_4 = single_line_message("""
	This runner does not support stdin_content parameter
""")
RUNNER_DOES_NOT_SUPPORT_STDIN_CONTENT_3 = single_line_message("""
	This runner does not support stdin_content parameter
""")
RUNNER_DOES_NOT_SUPPORT_STDIN_CONTENT_2 = single_line_message("""
	This runner does not support stdin_content parameter
""")
COMMAND_COMMAND_STRWHERE_RETURNED_NONZERO_EXIT = multi_line_message("""
	The command "{command_str}"{where} returned a non-zero exit code.
	============================================================================
	Stderr:
	{stderr}
	============================================================================
	Stdout:
	{stdout}
	============================================================================
	1. If this happened because of a network issue, re-run the migration tool.
	2. Ensure that the host is up and there are no firewall rules that may block winexe connection to the host.
	3. To investigate the issue:
	- login to the host and run the command:
	{command_str}
	- try to run the command with winexe from the current host:
	{full_command_str}
""")
UNABLE_UPLOAD_FILE_CONTENTS_S_DIRECTORY = single_line_message("""
	Unable to upload file contents to %s: directory for temporary files was not specified to WinexeRunner
""")
TRY_CONNECT_SAMBA_SHARE_C_S = single_line_message("""
	Try to connect to samba share C$ on %s.
""")
COMMAND_S_FAILED_EXECUTE_S_ERROR = single_line_message("""
	Command '%s' failed to execute with '%s' error. Please check that credentials for server '%s' are correct in
	config.ini
""")
LINE_S_INVALID_SOURCE_IP_ADDRESS = single_line_message("""
	Line #%s: invalid source IP address '%s'. Specify valid IPv4 or IPv6 address.
""")
LINE_S_TARGET_IP_ADDRESS_S = single_line_message("""
	Line #%s: target IP address '%s' does not exist on target server.
""")
LINE_S_SOURCE_IP_ADDRESS_S = single_line_message("""
	Line #%s: source IP address '%s' was already specified before.
""")
LINE_S_IP_ADDRESSES_DIFFERENT_TYPES = single_line_message("""
	Line #%s: IP addresses of different types can not be mapped. Specify either both IPv4 addresses, or both IPv6
	addresses.
""")
LINE_S_INVALID_TARGET_IP_ADDRESS = single_line_message("""
	Line #%s: invalid target IP address '%s'. Specify valid IPv4 or IPv6 address.
""")
SKIP_CHECKING_LOG_PRIORITY_OPTION = single_line_message("""
	Skip checking log priority option.
""")
MIGRATION_TOOLS_WERE_UPDATED_LATEST_VERSION = single_line_message("""
	The migration tools were updated to the latest version, please re-run it with the last command and arguments
""")
CHECK_DISK_SPACE_REQUIREMENTS_FOR_S = single_line_message("""
	Check disk space requirements for %s
""")
FAILED_SET_SECURITY_POLICY_SOME_TARGET = multi_line_message("""
	Failed to set security policy on some of target nodes: %s
	Restoration of customers/users/resellers with weak passwords might be failed by Windows security policy.
	Set 'PasswordComplexity' value to '0' with help of 'secedit' utility and re-run migration tool.
	Restore required security policy after migration.
""")
FAILED_DETECT_DATABASES_SUBSCRIPTION = single_line_message("""
	Failed to detect databases of subscription.
""")
FAILED_MIGRATE_SOME_OBJECTS_SEE_LOG = single_line_message("""
	Failed to migrate some objects. See log above for details
""")
FAILED_CHECK_CONNECTIONS_BETWEEN_SOURCE_AND_1 = single_line_message("""
	Failed to check connections between source and the destination mail server nodes
""")
NO_RESELLER_WITH_SUCH_LOGIN_ON_TARGET = single_line_message("""
	There is no reseller named %s on target panel, skipped retrieving its plans
""")
CHECK_MYSQL_MAX_ALLOWED_PACKET = single_line_message("""
	Check MySQL max allowed packet
""")
DETAILED_RESELLER_MIGRATION_STATUS = single_line_message("""
	Detailed Reseller Migration Status
""")
BILLING_DATA_MIGRATION_IS_AVAILABLE_ONLY_1 = single_line_message("""
	Billing data migration is available only when migrating from Parallels H-Sphere
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME_1 = single_line_message("""
	Failed to find subscription by name
""")
CHECK_MYSQL_MAX_ALLOWED_PACKET_1 = single_line_message("""
	Check MySQL max allowed packet
""")
GET_TARGET_PANELS_RESELLERS_FOR_CONFLICT = single_line_message("""
	Get target panel's resellers for conflict resolution
""")
FAILED_COPY_CONTENT_DATABASE_S_MIGRATION = single_line_message("""
	Failed to copy content of database '%s': migration of databases from Windows to Unix is not allowed
""")
UNABLE_RETRIVE_ROW_BACKUP_S = single_line_message("""
	Unable to retrive raw backup "%s"
""")
FAILED_COPY_CONTENT_DATABASE_S_1 = single_line_message("""
	Failed to copy content of database '%s'
""")
MIGRATION_TOOL_NOT_ENOUGH_INFORMATION_TRANSFER = single_line_message("""
	Migration tool has not enough information to transfer the subscriptions correctly. Please supply a transfer list.
""")
UNABLE_RETRIVE_SOURCE_NODE_ID_S = single_line_message("""
	Unable to retrive source node with id "%s"
""")
SUMMARY_1 = single_line_message("""
	******************** Summary ********************
""")
GET_TARGET_PANELS_SUBSCRIPTIONS_SITES_AND = single_line_message("""
	Get target panel's subscriptions, sites and site aliases for conflict resolution
""")
S_DATABASE_S_DOES_NOT_EXIST = single_line_message("""
	%s database '%s' does not exist on target. Its content will not be copied.
""")
UNABLE_RETRIVE_ROW_BACKUP_S_1 = single_line_message("""
	Unable to retrive raw backup "%s"
""")
PLEASE_REVIEW_PREMIGRATION_TREE_ABOVE_AND_1 = single_line_message("""
	Please review pre-migration tree above and fix the errors. You can also use --ignore-pre-migration-errors command-
	line option if you're sure what you are doing.
""")
FAILED_REFRESH_COMPONENTS_LIST_FOR_WINDOWS = single_line_message("""
	Failed to refresh components list for Windows service nodes: %s. See debug.log for more details.
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME = single_line_message("""
	Failed to find subscription by name
""")
TRANSFERRED_DOMAINS_DNS_ISSUES = single_line_message("""
	Transferred Domains DNS Issues
""")
SKIP_COPY_DATABASE_DUE_TO_CONFLICT = single_line_message("""
	Skip copy database '{db_name}' from {db_type} server as there is some conflict (run 'panel-migrator check' command
	to see conflict details)
""")
TRANSFERRED_DOMAINS_FUNCTIONAL_ISSUES = single_line_message("""
	Transferred Domains' Functional Issues
""")
SKIP_CHECKING_PANEL_MIGRATOR_UPDATES = single_line_message("""
	Skip checking panel migrator updates
""")
SAVED_TARGET_MODEL_TO_FILE = single_line_message("""
	Saved panel objects to file '{filename}':
""")
UNABLE_CONTINUE_MIGRATION_UNTIL_THERE_ARE = single_line_message("""
	Unable to continue migration until there are no issues at 'error' level in pre-migration checks.
""")
TRANSFERRED_DOMAINS_DATABASE_ISSUES = single_line_message("""
	Transferred Domains Database Issues
""")
THERE_ARE_NONUTF_CHARACTERS_IN_MIGRATION = single_line_message("""
	There are non-UTF-8 characters in the migration list. Convert the migration list file to UTF-8 encoding.
""")
UNABLE_RETRIVE_CONVERTED_BACKUP_S_1 = single_line_message("""
	Unable to retrive converted backup "%s"
""")
OPERATION_FINISHED_SUCCESSFULLY_FOR_S_OUT_1 = multi_line_message("""
	Operation finished successfully for %s out of %s subscriptions
	To verify that the transfer completed correctly, run 'panel-migrator test-all config.ini'.
	This command will check the operation of web, mail, DNS, database, FTP/SSH/RDP services for each transferred domain.
""")
TARGET_MODEL_FILE_NOT_FOUND = single_line_message("""
	Target model file not found, did you call 'convert' command?
""")
UNABLE_COPY_CONTENT_DATABASE_S_SUBSCRIPTION = single_line_message("""
	Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
REPORT_WAS_SAVED_INTO_FILE_S = single_line_message("""
	The report was saved into the file %s
""")
FAILED_FIND_DOMAIN_S_IN_CONVERTED = single_line_message("""
	Failed to find domain '%s' in converted backup
""")
FAILED_REFRESH_COMPONENTS_LIST_FOR_S = single_line_message("""
	Failed to refresh components list for %s: %s. See debug.log for more details.
""")
THERE_ARE_INFRASTRUCTURE_ISSUES_THAT_SHOULD = single_line_message("""
	There are infrastructure issues that should be fixed prior to the next migration steps. Migration is stopped, please
	check and fix the issues listed above and then run transfer-accounts command again.
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_DATABASE = single_line_message("""
	Connections between source and the destination database server nodes
""")
CHECK_CONNECTIONS_TARGET_NODES = single_line_message("""
	Check connections to target nodes
""")
FAILED_CHECK_CONNECTIONS_DATABASE_SERVERS = single_line_message("""
	Failed to check connections to database servers.
""")
S_INSUFFICIENT_FREE_DISK_SPACE_FOR = single_line_message("""
	%s has insufficient free disk space for migration. Migration is stopped. Free some disk space, then run 'transfer-
	accounts' command again.
""")
CHECK_CONNECTIONS_TARGET_NODES_1 = single_line_message("""
	Check connections on target nodes
""")
OPERATION_FINISHED_SUCCESSFULLY_FOR_S_OUT = single_line_message("""
	Operation finished successfully for %s out of %s resellers
""")
RESTART_IIS_FOR_IDN_DOMAINS_S = single_line_message("""
	Restart IIS for IDN domains on %s.
""")
DNS_FORWARDING_WAS_SUCCESSFULLY_SET_UP = single_line_message("""
	DNS forwarding was successfully set up
""")
DNS_FORWARDING_WAS_SUCCESSFULLY_UNDONE = single_line_message("""
	DNS forwarding was successfully undone
""")
GET_TARGET_PANELS_CUSTOMERS_FOR_CONFLICT = single_line_message("""
	Get target panel's customers for conflict resolution
""")
INTERNAL_ERROR_S_MIGRATION_TOOL_SKIP = multi_line_message("""
	Internal error: %s.
	Migration tool will skip corresponding infrastructure checks and proceed to the next migration steps.
""")
FAILED_COPY_CONTENT_DATABASE_S_MIGRATION_1 = single_line_message("""
	Failed to copy content of database '%s': migration of databases from Unix to Windows is not allowed
""")
BILLING_DATA_MIGRATION_IS_AVAILABLE_ONLY = single_line_message("""
	Billing data migration is available only when migrating from Parallels H-Sphere
""")
TRANSFERRED_DOMAINS_MAIL_ISSUES = single_line_message("""
	Transferred Domains Mail Issues
""")
GET_TARGET_PANELS_AUXILIARY_USERS_AND = single_line_message("""
	Get target panel's auxiliary users and roles for conflict resolution
""")
CHECK_LOG_PRIORITY_TARGET_PLESK_NODE = single_line_message("""
	Check log priority on target Plesk node
""")
FAILED_CHECK_SERVICES_S_CHECK_DEBUGLOG = single_line_message("""
	Failed to check services: %s. Check debug.log for more details. Still migration will proceed to the next steps.
""")
UNABLE_READ_MIGRATION_LIST_FILE = single_line_message("""
	Unable to read migration list file.
""")
THERE_WERE_SOME_ERRORS_WHILE_READING = multi_line_message("""
	There were some error(s) while reading migration list file. Please review and fix them: 
""")
ALL_SUBSCRIPTIONS_ARE_FAILED_MIGRATE_STOPPING = single_line_message("""
	All subscriptions are failed to migrate, stopping.
""")
RESOLVE_ISSUE_DATABASE_CREATION_CREATE_DATABASE = single_line_message("""
	Resolve the issue with database creation or create database on target panel, then run copy-db-content command for
	that subscription to copy database contents.
""")
ESTIMATED_PAYMENTS_COMPARISON_IS_AVAILABLE_ONLY = single_line_message("""
	Estimated payments comparison is available only when migrating from Parallels H-Sphere
""")
FAILED_SYNCHRONIZE_SUBSCRIPTIONS_PLANS = single_line_message("""
	Failed to synchronize subscriptions with plans
""")
RESOURCE_LIMITS_TRANSFER_IS_AVAILABLE_ONLY = single_line_message("""
	Resource limits transfer is available only when migrating from Parallels H-Sphere
""")
DISK_SPACE_REQUIREMENTS_FOR_S_ARE = single_line_message("""
	Disk space requirements for %s are met
""")
AT_LEAST_ONE_DNS_SERVER_SHOULD = single_line_message("""
	At least one DNS server should exist for domain '%s'
""")
FAILED_CHECK_CONNECTIONS_BETWEEN_SOURCE_AND = single_line_message("""
	Failed to check connections between source and the destination web server nodes
""")
FAILED_CHECK_CONNECTIONS_BETWEEN_SOURCE_AND_2 = single_line_message("""
	Failed to check connections between source and the destination database server nodes
""")
ERROR_WHILE_CHECKING_TARGET_PANEL_CONFIGURATION = single_line_message("""
	Error while checking target panel configuration and connections: '%s'
""")
IF_YOU_WANT_SKIP_INFRASTRUCTURE_CHECKS = single_line_message("""
	If you want to skip infrastructure checks pass --skip-infrastructure-checks command line option
""")
GET_TARGET_PANELS_SERVICE_TEMPLATES_FOR = single_line_message("""
	Get target panel's service templates for conflict resolution
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_WEB = single_line_message("""
	Connections between source and the destination web server nodes
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_MAIL = single_line_message("""
	Connections between source and the destination mail server nodes
""")
FAILED_SYNCRONIZE_SUBSCRIPTION_PLAN = single_line_message("""
	Failed to synchronize subscription with plan
""")
FAILED_SUSPEND_SUBSCRIPTION = single_line_message("""
	Failed to suspend subscription.
""")
NEW_VERSION_MIGRATION_TOOLS_ALREADY_EXISTS = single_line_message("""
	A new version of migration tools already exists: %s is installed, %s is available. Updating to the new version...
""")
FIX_SERVICE_TEMPLATE_SUBSCRIPTION_IS_ASSIGNED_1 = single_line_message("""
	Fix service template subscription is assigned to, so databases are provisioned to Unix servers
""")
CHECK_PLESK_VERSION_MAIN_TARGET_NODE = single_line_message("""
	Check Plesk version of the main target node
""")
FAILED_PERFORM_INFRASTRUCTURE_CHECKS_S_CHECK = single_line_message("""
	Failed to perform infrastructure checks: %s. Check debug.log for more details. Still migration will proceed to the
	next steps.
""")
UNABLE_RETRIVE_CONVERTED_BACKUP_S = single_line_message("""
	Unable to retrive converted backup "%s"
""")
UNABLE_CAT_S_FILE_MOST_PROBABLY = single_line_message("""
	Unable to cat %s file. Most probably this file is absent.
""")
PLEASE_REVIEW_PREMIGRATION_TREE_ABOVE_AND = single_line_message("""
	Please review pre-migration tree above and fix the errors. You can also use --ignore-pre-migration-errors command-
	line option if you're sure what you are doing.
""")
FIX_SERVICE_TEMPLATE_SUBSCRIPTION_IS_ASSIGNED = single_line_message("""
	Fix service template subscription is assigned to, so databases are provisioned to Windows servers
""")
GET_TARGET_PANELS_SUBSCRIPTIONS_AND_WEBSPACES = single_line_message("""
	Get target panel's subscriptions and webspaces for conflict resolution
""")
CHECK_SERVICES_TARGET_SERVERS = single_line_message("""
	check services on target servers
""")
SUMMARY = single_line_message("""
	******************** Summary ********************
""")
FAILED_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
	Failed to check disk space requirements.
""")
FAILED_COPY_CONTENT_DATABASE_S = single_line_message("""
	Failed to copy content of database '%s'
""")
UNABLE_COPY_CONTENT_DATABASE_S_SUBSCRIPTION_1 = single_line_message("""
	Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
UNABLE_CONTINUE_MIGRATION_UNTIL_THERE_ARE_1 = single_line_message("""
	Unable to continue migration until there are no issues at 'error' level in pre-migration checks.
""")
FAILED_CHECK_DISK_SPACE_REQUIREMENTS_FOR = single_line_message("""
	Failed to check disk space requirements for %s: %s. Check debug.log for more details. Still migration will proceed
	to the next steps.
""")
FAILED_CHECK_MYSQL_REQUIREMENTS = single_line_message("""
	Failed to check MySQL requirements.
""")
FAILED_MIGRATE_SOME_RESELLERS_SEE_LOG = single_line_message("""
	Failed to migrate some resellers. See log above for details
""")
FAILED_FIND_CLIENT_THAT_OWNS_SUBSCRIPTION = single_line_message("""
	Failed to find client that owns subscription '%s'
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME_2 = single_line_message("""
	Failed to find subscription by name
""")
STOP_RSYNC_IF_IT_IS_RUNNING = single_line_message("""
	Stop rsync if it is running, then start
""")
RSYNC_IS_ALREADY_INSTALLED_SERVER_SKIP = single_line_message("""
	Rsync is already installed on server, skip installation.If you want to reinstall it, stop it with stop.bat script,
	remove '%s' directory and then restart migration
""")
CONFIGURE_RSYNC_SERVER_RSYNCDCONF_AND_RSYNCDSECRETS = single_line_message("""
	Configure rsync server (rsyncd.conf and rsyncd.secrets)
""")
UNABLE_SET_VHOSTS_DIR_RSYNC_SERVER = single_line_message("""
	Unable to set vhosts_dir: rsync server at %s is not configured yet
""")
TRY_RESTART_SERVER_AND_RETRY = single_line_message("""
	, try to restart server and retry
""")
TOOL_IMAPSYNC_WAS_INSTALLED_SUCCESSFULLY = single_line_message("""
	Tool 'imapsync' was installed successfully
""")
MAIL_CONTENT_NOT_COPIED_IMAPSYNC_TOOL = single_line_message("""
	Mail content will not be copied: 'imapsync' tool required to copy mail content can not be automatically installed on
	your OS. Please install it manually and then restart copy mail content by 'panel-migrator copy-mail-content' command
""")
INSTALL_IMAPSYNC_TOOL_COPY_MAIL_CONTENT = single_line_message("""
	Install 'imapsync' tool to copy mail content
""")
MAIL_CONTENT_NOT_COPIED_FAILED_INSTALL = multi_line_message("""
	Mail content will not be copied: failed to install 'imapsync' tool required to copy mail content.
	Reason: %s
	Please install 'imapsync' tool manually and then restart copy mail content
	by 'panel-migrator copy-mail-content' command
""")
SSHKEY_FILE_SPECIFIED_IN_SECTION_S = single_line_message("""
	ssh-key file specified in section '%s' of configuration file does not exist
""")
IF_NOT_SPECIFIED_NONE_IS_SPECIFIED = single_line_message("""
	If not specified, or 'none' is specified, local execution is considered.
""")
WINDOWS_PASSWORD_IS_NOT_SPECIFIED_FOR = multi_line_message("""
				Windows password is not specified for server '%s'. Please
				specify it with 'windows-password' option of corresponding section
				'[%s]' in config.ini
""")
UNABLE_RETRIEVE_SOURCE_INFO_S = single_line_message("""
	Unable to retrieve source info "%s"
""")
MAKE_SURE_THAT_WEB_HOSTING_IS = single_line_message("""
	Make sure that web hosting is configured for this webspace in the target panel.
""")
TARGET_PANEL_WEBSPACE_S_IS_NOT = single_line_message("""
	The target panel webspace %s is not associated with a web IP address. Unable to check the site %s in the target
	panel.
""")
EXTERNALDNSSERV_OPTION_IN_GLOBAL_SECTION_CONFIG = single_line_message("""
	'external-dns-servers' option in [GLOBAL] section of config file of migration tool contains invalid value: '%s'.
	Valid IPv4 address should be specified in order for all DNS checks to be performed.
""")
ALL_TRANSFERRED_DOMAINS_ARE_WORKING_CORRECTLY = single_line_message("""
	All transferred domains are working correctly.
""")
REPORT_WAS_SAVED_INTO_FILE_S_1 = single_line_message("""
	The report was saved into the file %s
""")
SUMMARY_2 = single_line_message("""
	******************** Summary ********************
""")
ALL_SERVICES_ARE_WORKING_CORRECTLY = single_line_message("""
	All services are working correctly.
""")
SKIPPED_CHECKING_MAILBOXES_SUBSCRIPTION_S_BECAUSE_1 = single_line_message("""
	Skipped checking mailboxes of the subscription %s because it has no mail service
""")
SKIPPED_CHECKING_MAILBOXES_SUBSCRIPTION_S_BECAUSE = single_line_message("""
	Skipped checking mailboxes of the subscription %s because it is suspended
""")
SKIPPED_CHECKING_MAIL_SERVICE_DOMAIN_S = single_line_message("""
	Skipped checking mail service of the domain %s because it is suspended
""")
SUBSCRIPTION_S_IS_NOT_PRESENTED_MAIL = single_line_message("""
	Subscription '%s' is not presented on mail server, do not check mail for it
""")
SKIPPED_CHECKING_SITE_S_SUBSCRIPTION_S = single_line_message("""
	Skipped checking site %s of subscription %s because this site is disabled
""")
SKIPPED_CHECKING_SITES_SUBSCRIPTION_S_BECAUSE = single_line_message("""
	Skipped checking the sites of the subscription %s because this subscription is disabled
""")
RESOLVE_INCONSISTENCY_SOURCE_SERVER = single_line_message("""
	Resolve the inconsistency on the source server.
""")
SKIPPED_CHECKING_SITE_S_SUBSCRIPTION_S_1 = single_line_message("""
	Skipped checking site %s of subscription %s because this site is in maintenance
""")
SKIPPED_CHECKING_SITES_DOMAIN_S_BECAUSE = single_line_message("""
	Skipped checking the sites of the domain %s because it has no web hosting
""")
SETTINGS_DOMAIN_S_SOURCE_SERVER_ARE = single_line_message("""
	The settings of the domain %s on the source server are inconsistent: web hosting is configured for this domain, but
	the domain is not associated with an IP address.
""")
SKIP_CHECKING_DOMAIN_S_BECAUSE_IT = single_line_message("""
	Skip checking of domain '%s' because it is in slave mode
""")
SKIP_CHECKING_DOMAIN_S_BECAUSE_IT_1 = single_line_message("""
	Skip checking of domain '%s' because it has no DNS zone or DNS zone is disabled
""")
CAN_NOT_EXECUTE_COMMANDS_CONNECTION_THAT = single_line_message("""
	Can not execute commands on connection that is not open
""")
CAN_NOT_UPLOAD_FILES_COMMANDS_CONNECTION = single_line_message("""
	Can not upload files commands on connection that is not open
""")
CAN_NOT_OPEN_CONNECTION_WHICH_IS = single_line_message("""
	Can not open connection which is already open
""")
CAN_NOT_EXECUTE_COMMANDS_CONNECTION_THAT_1 = single_line_message("""
	Can not execute commands on connection that is not open
""")
CAN_NOT_CLOSE_CONNECTION_THAT_IS = single_line_message("""
	Can not close connection that is not open
""")
CHECKING_WHETHER_SERVICE_OPERATE_PROPERLY = single_line_message("""
	Checking whether service operate properly
""")
CHECK_WHETHER_IMAP_SMTP_AND_POP = single_line_message("""
	Check whether IMAP, SMTP and POP3 authentication work for mailboxes of the transferred domains
""")
CHECK_LICENSES_TARGET_SERVERS = single_line_message("""
	Check licenses on target servers
""")
CHECK_INFRASTRUCTURE_CONNECTIONS_AND_DISK_SPACE = single_line_message("""
	Check infrastructure (connections and disk space)
""")
CHECK_DISK_SPACE_REQUIREMENTS_FOR_MAIN = single_line_message("""
	Check disk space requirements for main target server
""")
FETCH_INFORMATION_FROM_SOURCE_PANEL = single_line_message("""
	Fetch information from source panel
""")
CONVERT_HOSTING_SETTINGS_TARGET_PANEL_FORMAT = single_line_message("""
	Convert hosting settings to target panel format
""")
COPY_WEB_FILES_AND_SYNC_WEB = single_line_message("""
	Copy web files and sync web assets
""")
CHECK_THAT_SERVICES_AND_TRANSFERRED_DOMAINS = single_line_message("""
	Check that the services and transferred domains are working correctly
""")
RESTORE_SECURITY_POLICY_WINDOWS_NODES = single_line_message("""
	Restore security policy on Windows nodes
""")
CHECK_LICENSES_TARGET_SERVERS_1 = single_line_message("""
	Check licenses on target servers
""")
CHECKING_WHETHER_TRANSFERRED_WEBSITES_OPERATE_PROPERLY = single_line_message("""
	Checking whether the transferred websites operate properly
""")
CHECK_THAT_DNS_QUERIES_FOR_TRANSFERRED = single_line_message("""
	Check that the DNS queries for transferred domains' records are ok
""")
SET_SECURITY_POLICY_WINDOWS_NODES = single_line_message("""
	Set security policy on Windows nodes
""")
FETCH_INFORMATION_FROM_TARGET_SERVERS = single_line_message("""
	Fetch information from target servers
""")
RESTORE_LOGINS_SYSTEM_USERS = single_line_message("""
	Restore logins of system users
""")
CHECK_CONFLICTS_FOR_CLIENTS_SUBSCRIPTIONS_RESELLER = single_line_message("""
	Check conflicts for clients, subscriptions, reseller, plans
""")
SYNCHRONIZE_SUBSCRIPTIONS_PLANS = single_line_message("""
	Synchronize subscriptions with plans
""")
CONVERT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
	Convert clients and subscriptions
""")
REFRESH_COMPONENTS_LIST_TARGET_WINDOWS_SERVERS = single_line_message("""
	Refresh components list on target Windows servers
""")
CHECK_WHETHER_DATABASES_WERE_COPIED_CORRECTLY = single_line_message("""
	Check whether the databases were copied correctly
""")
CONVERT_CLIENTS_AND_SUBSCRIPTIONS_1 = single_line_message("""
	Convert clients and subscriptions
""")
COPY_WEB_DATABASE_AND_MAIL_CONTENT = single_line_message("""
	Copy web, database and mail content
""")
COUNT_MIGRATION_STATISTICS_PRINT_REPORT = single_line_message("""
	Count migration statistics, print report
""")
RESTORE_STATUS_SUSPENDED_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
	Restore status of suspended clients and subscriptions
""")
CAN_NOT_REPLACE_SHARED_ACTION_SHARED = single_line_message("""
	Can not replace shared action: shared action with ID '%s' not found in workflow
""")
MIGRATOR_INTERNAL_ERROR_ENTRY_POINT_ID = single_line_message("""
	Migrator internal error. Entry point with ID '%s' does not exist. Check entry point ID spelling, or add entry point
	with such ID to workflow.
""")
MIGRATOR_INTERNAL_ERROR_SHARED_ACTION_ID = single_line_message("""
	Migrator internal error. Shared action with ID '%s' does not exist. Check action ID spelling, or add shared action
	with such ID to workflow.
""")
CAN_NOT_REPLACE_ENTRY_POINT_S = single_line_message("""
	Can not replace entry point '%s' which does not exist
""")
ENTRY_POINT_S_ALREADY_EXISTS = single_line_message("""
	Entry point '%s' already exists
""")
EXCEPTION_IN_SUBSCRIPTION_THREAD = single_line_message("""
	Exception in subscription thread:
""")
NO_NEED_EXECUTE_ACTION_CONTINUE_NEXT = single_line_message("""
	No need to execute action, continue to the next one
""")
CHECKING_WHETHER_IT_IS_REQUIRED_EXECUTE = single_line_message("""
	Checking whether it is required to execute action
""")
EXIT_SUBSCRIPTION_ACTION_BLOCK = single_line_message("""
	Exit subscription action block
""")
ENTER_SUBSCRIPTION_ACTION_BLOCK = single_line_message("""
	Enter subscription action block
""")
INTERNAL_ERROR_IN_SUBSCRIPTION_THREAD_S = single_line_message("""
	Internal error in subscription thread: %s. Subscription '%s' migration stopped.
""")
S_TRY_REPEAT_OPERATION_ONCE_MORE = single_line_message("""
	%s. Try to repeat operation once more.
""")
USER_INTERRUPT_REQUESTED_FORCING_STOP_MIGRATION = single_line_message("""
	User interrupt requested, forcing stop migration
""")
S_CAUSE_S_THAT_IS_CRITICAL = multi_line_message("""
	%s
	Cause: %s
	That is a critical error, migration was stopped.
""")
MIGRATION_FOR_THAT_SUBSCRIPTION_IS_CONSIDERED = multi_line_message("""
	Migration for that subscription is considered completely failed. No further actions are performed for it.
""")
USER_INTERRUPT_REQUESTED_TRYING_STOP_MIGRATION = multi_line_message("""
	User interrupt requested, trying to stop migration gracefully:
	finish all running operations for each of migrated subscription
	To force interrupt, press Ctrl+C again, but it may lead to unpredictable results
""")
RUN_GROUP_ACTIONS_S_WORKERS = single_line_message("""
	Run group of actions with %s workers
""")
END_PROCESSING_SUBSCRIPTION_S = single_line_message("""
	END Processing subscription '%s'
""")
CAN_NOT_RUN_COMMON_ACTION_IN = single_line_message("""
	Can not run common action in subscription's actions queue
""")
S_TRY_REPEAT_OPERATION_ONCE_MORE_1 = single_line_message("""
	%s. Try to repeat operation once more.
""")
INVALID_ACTION_S_S_IS_NOT = single_line_message("""
	Invalid action '%s': %s is not a subclass of CompoundAction, SubscriptionAction or BaseAction
""")
FINISH_PROCESSING_SUBSCRIPTION_S = single_line_message("""
	Finish processing subscription '%s'
""")
RUN_SUBSCRIPTION_ACTION_CLASS_S = single_line_message("""
	Run subscription action class %s
""")
START_PROCESSING_SUBSCRIPTION_S = single_line_message("""
	Start processing subscription '%s'
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN = single_line_message("""
	Skip copying mail content for the domain %s which has no mail hosting
""")
SOURCE_MAIL_SERVER_IS_NOT_DEFINED = single_line_message("""
	Source mail server is not defined for subscription '%s', do not copy mail content
""")
RSYNC_FAILED_COPY_MAIL_CONTENT_FROM_1 = multi_line_message("""
	Rsync failed to copy mail content from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
	Retry copying the mail content with the help of the "copy-mail-content" command.
	2. Check whether rsync is installed and configured on the source server.
""")
FAILED_RECALCULATE_MAIL_DIRECTORY_SIZE_MAIL = single_line_message("""
	Failed to recalculate mail directory size. Mail usage may become incorrect after migration
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN_1 = single_line_message("""
	Skip copying mail content for the domain %s which has no mail hosting
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN_2 = single_line_message("""
	Skip copying mail content for the domain %s which has no mailboxes
""")
RSYNC_FAILED_COPY_MAIL_CONTENT_FROM = multi_line_message("""
	Rsync failed to copy mail content from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
	Retry copying the mail content with the help of the "copy-mail-content" command.
	2. Check whether rsync is installed and configured on the source server.
""")
SUBSCRIPTION_S_IS_NOT_PRESENTED_MAIL_1 = single_line_message("""
	Subscription '%s' is not presented on mail server, do not copy mail content
""")
UNABLE_COPY_MAIL_CONTENT_S_DOMAIN = single_line_message("""
	Unable to copy mail content on '%s' domain: mail service is disabled due to domain is disabled.
""")
MIGRATE_MAIL_CONTENT_MAILBOXS_ACTIVATE_DOMAIN = multi_line_message("""
	To migrate mail content of the mailboxs:
	1) Activate domain on both source panel and target panel.
	2) Run 'copy-mail-content' migration tool's command for the subscription.
	3) Suspend domain on both source panel and target panel if necessary.
	
""")
MAILBOX_EMPTY_PASSWORD_EMAIL_S_SKIPPING = single_line_message("""
	Mailbox has empty password on E-mail %s, skipping it
""")
FAILED_CHECK_WHETHER_SUBSCRIPTION_S_IS = single_line_message("""
	Failed to check whether the subscription %s is suspended: %s. The migration tool will proceed with copying mail
	content even if the subscription is suspended.
""")
CHANGE_MAILBOX_PASSWORD_AND_RUN_TOOL = single_line_message("""
	Change the mailbox password and run the tool with the copy-mail-content command.
""")
MAIL_SERVICE_SUBSCRIPTION_IS_DISABLED_MIGRATION = single_line_message("""
	Mail service on subscription is disabled. The migration tool is not able to migrate mail content of subscriptions as
	POP3/IMAP services are disabled for such subscriptions.
""")
ENABLE_MAIL_SERVICE_SOURCE_PANEL_FOR = single_line_message("""
	Enable mail service on source panel for subscription to migrate mail content and run 'copy-mail-content' migration
	tool's command for the subscription.
""")
UNABLE_COPY_MAIL_CONTENT_MAILBOX_PASSWORD = single_line_message("""
	Unable to copy mail content: The mailbox password can't be retrieved from Plesk.
""")
MIGRATE_MAIL_CONTENT_SUBSCRIPTION_ACTIVATE_IT = multi_line_message("""
	To migrate mail content of the subscription:
	1) Activate it on both source panel and target panel.
	2) Run 'copy-mail-content' migration tool's command for the subscription.
	3) Suspend it on both source panel and target panel if necessary.
	
""")
MAILBOX_IS_DISABLED_EMAIL_S_SKIPPING = single_line_message("""
	Mailbox is disabled on E-mail %s, skipping it
""")
SUBSCRIPTION_NO_MAILBOXES_SO_THERE_IS = single_line_message("""
	Subscription has no mailboxes, so there is nothing to copy with imapsync
""")
RESOLVE_ERRORS_AND_RUN_TOOL_COPYMAILCONTENT = single_line_message("""
	Resolve the errors and run the tool with the copy-mail-content command. For detailed log see {mailsync_log}.
""")
SUBSCRIPTION_IS_SUSPENDED_S_MIGRATION_TOOL = single_line_message("""
	The subscription is suspended on %s. The migration tool is not able to migrate mail content of suspended
	subscriptions as POP3/IMAP services are disabled for such subscriptions.
""")
SUBSCRIPTION_S_IS_NOT_PRESENTED_MAIL_2 = single_line_message("""
	Subscription '%s' is not presented on mail server, do not copy mail content
""")
COPY_CONTENT_MAILBOX_EMAIL_S_FOR = single_line_message("""
	Copy content of mailbox on E-mail '%s'. For details see %s in migration session directory
""")
BOTH_SOURCE_PANEL_AND_TARGET_PANEL = single_line_message("""
	both source panel and target panel
""")
SUBSCRIPTION_S_NO_IP_ADDRESSES_TARGET = single_line_message("""
	Subscription '%s' has no IP addresses on target system. DNS records won't be changed
""")
CLIENT_LOGIN_IS_PRESENTED_IN_MIGRATION = single_line_message("""
	Client '{login}' is presented in migration list, but is presented neither on source Plesk(s) nor on target panel.
""")
CREATE_RESELLER_IN_DESTINATION_PANEL_MAP = single_line_message("""
	Create this reseller in destination panel, or map client to some existing reseller or administrator
""")
CLIENT_IS_MAPPED_AN_UNEXISTING_RESELLER = single_line_message("""
	Client is mapped to an unexisting reseller '%s'
""")
CONVERT_CLIENTS_FROM_TARGET_PANEL = single_line_message("""
	Convert clients from target panel
""")
EITHER_REMOVE_DIFFERENCE_IF_BOTH_ACCOUNTS = single_line_message("""
	Either remove the difference (if both accounts belong to the same client) or change the client's username (if these
	are the different clients).
""")
CONVERT_CLIENTS_FROM_SOURCE_PANEL = single_line_message("""
	Convert clients from source panel
""")
CONVERT_RESELLERS_FROM_SOURCE_PANEL = single_line_message("""
	Convert resellers from source panel
""")
RESELLER_LOGIN_IS_PRESENTED_IN_MIGRATION = single_line_message("""
	Reseller '{login}' is presented in migration list, but is presented neither on the source panel, nor in the target
	panel.
""")
EITHER_REMOVE_DIFFERENCE_IF_BOTH_ACCOUNTS_1 = single_line_message("""
	Either remove the difference (if both accounts belong to the same reseller) or change the reseller's username (if
	these are the different resellers).
""")
NEW_PASSWORD_GENERATED_FOR_RESELLER_S = single_line_message("""
	A new password has been generated for the reseller '%s': '%s'. You can change the password after data transfer is
	finished.
""")
ALL_RESELLER_DATA_CHECKED_RESELLER_INCLUDING = single_line_message("""
	All reseller data of the checked reseller (including clients and their subscriptions) will be transferred to the
	target panel under a single reseller. In this case, ensure that combined resources of all accounts do not exceed the
	limits. If you want migrator to create separate accounts, change the reseller's username.
""")
UNABLE_RETRIEVE_RESELLERS_PASSWORD_AS_IT = single_line_message("""
	Unable to retrieve the reseller's password as it is stored in the encrypted form
""")
CONVERT_RESELLERS_FROM_TARGET_PANEL = single_line_message("""
	Convert resellers from target panel
""")
PLAN_S_EXISTS_MULTIPLE_PANELS_PLAN = single_line_message("""
	Plan '%s' exists on multiple panels. Plan from '%s' will be used
""")
PLAN_S_SPECIFIED_IN_MIGRATION_LIST = single_line_message("""
	The reseller {reseller_name} at the destination server does not have the plan {plan_name}. The reseller
	{reseller_name} does not have this plan at the source servers as well. Unable to create the plan {plan_name}. Please
	create its manually.
""")
ADMIN_PLAN_S_SPECIFIED_IN_MIGRATION_LIST = single_line_message("""
	The admin at the destination server does not have the plan {plan_name}. The admin does not have this plan at the
	source servers as well. Unable to create the plan {plan_name}. Please create its manually.
""")
ADDON_PLAN_S_EXISTS_MULTIPLE_PANELS = single_line_message("""
	Addon plan '%s' exists on multiple panels. Plan from '%s' will be used
""")
ADDON_PLAN_S_SPECIFIED_IN_MIGRATION = single_line_message("""
	The reseller {reseller_name} at the destination server does not have the addon plan {plan_name}. The reseller
	{reseller_name} does not have this addon plan at the source servers as well. Unable to create the addon plan
	{plan_name}. Please create its manually.
""")
ADMIN_ADDON_PLAN_S_SPECIFIED_IN_MIGRATION = single_line_message("""
	The admin at the destination server does not have the addon plan {plan_name}. The admin does not have this addon
	plan at the source servers as well. Unable to create the addon plan {plan_name}. Please create its manually.
""")
EITHER_CHANGE_CONFLICTING_NAMES_EXCLUDE_SUBSCRIPTION = single_line_message("""
	Either change the conflicting names, or exclude this subscription from transfer using the migration list file.
""")
ALL_SUBSCRIPTIONS_CUSTOMER_TRANSFERRED_EXISTING_CUSTOMERS = single_line_message("""
	All subscriptions of this customer will be transferred to existing customer's account. If you want to transfer the
	subscriptions to a new customer account, change the client's username.
""")
WEBSPACE_S_ALREADY_EXISTS = single_line_message("""
	The webspace '%s' already exists
""")
REMOVE_ACCOUNTS_DIFFERENCE = single_line_message("""
	Either remove the difference (if both accounts belong to the same customer) or change the customer's username (if
	these are the different customers).
""")
EITHER_RENAME_ONE_SUBSCRIPTIONS_IF_YOU = single_line_message("""
	Either rename one of the subscriptions (if you want to transfer both of them) or exclude one of the subscriptions
	from the migration list file.
""")
CUSTOMER_SAME_USERNAME_BUT_DIFFERENT_CONTACT_1 = multi_line_message("""
	A customer with the same username but different contact data already exists in the destination panel.
	The list of differences:
	%s
""")
CUSTOMER_SAME_USERNAME_BUT_DIFFERENT_CONTACT = multi_line_message("""
	A customer with the same username but different contact data already exists on another server.
	The list of differences:
	%s
""")
NEW_PASSWORD_GENERATED_FOR_CUSTOMER_S = single_line_message("""
	A new password has been generated for the customer '%s': '%s'. You can change the password after data transfer is
	finished.
""")
CONTACT_NAME_FIRST_NAME_LAST_NAME = single_line_message("""
	the Contact Name (First Name + Last Name) parameter of a customer in the destination panel: '%s', the contact name
	of the verified customer: '%s'
""")
UNABLE_RETRIEVE_CUSTOMERS_PASSWORD_AS_IT = single_line_message("""
	Unable to retrieve the customer's password as it is stored in the encrypted form
""")
CUSTOMER_SAME_USER_NAME_ALREADY_EXISTS = single_line_message("""
	A customer with the same user name already exists in destination panel
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_3 = single_line_message("""
	The name of %s '%s' in this subscription conflicts with the name of %s '%s' which exists in subscription '%s' on the
	other server
""")
ALL_SUBSCRIPTIONS_BOTH_CUSTOMERS_TRANSFERRED_SAME = single_line_message("""
	All subscriptions of both customers will be transferred to the same account. If you want to transfer the
	subscriptions under separate customer accounts, change the username of one of the customers.
""")
SUBSCRIPTION_S_ALREADY_EXISTS_OTHER_SERVER = single_line_message("""
	A subscription '%s' already exists on the other server '%s'
""")
EITHER_RENAME_SUBSCRIPTION_S_S_EXCLUDE_1 = single_line_message("""
	Either rename this subscription or the %s '%s' or exclude this subscription from transfer using the migration list
	file.
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS = single_line_message("""
	The name of the %s '%s' in this subscription conflicts with the name of destination panel webspace '%s'
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_2 = single_line_message("""
	The name of %s '%s' in this subscription conflicts with the name of %s '%s' which already exists in a subscription
	'%s'
""")
CUSTOMER_SAME_USERNAME_ALREADY_EXISTS_ANOTHER = single_line_message("""
	A customer with the same username already exists on another server
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_1 = single_line_message("""
	The name of the %s '%s' in this subscription conflicts with the name of subscription '%s' which exists on the other
	server '%s'
""")
EXISTING_WEBSPACE_OVERWRITTEN_INCLUDING_HOSTING_SETTINGS = multi_line_message("""
	The existing webspace will be overwritten (including hosting settings, site content, databases, and so on).
	If you want to transfer the subscription into a separate webspace, rename this subscription or the existing webspace.
""")
SITE_NAME_ALREADY_EXIST_ON_TARGET = single_line_message("""
	A %s '%s' already exists on target within the '%s' subscription
""")
EITHER_RENAME_SUBSCRIPTION_S_S_EXCLUDE = single_line_message("""
	Either rename this subscription or the %s '%s' or exclude this subscription from transfer using the migration list
	file.
""")
S_S_ALREADY_EXISTS_OTHER_SERVER = single_line_message("""
	A %s '%s' already exists on the other server within the '%s' subscription
""")
CONTACT_NAME_CUSTOMER_ANOTHER_SERVER_S = single_line_message("""
	the contact name of a customer on another server: '%s', the contact name of the checked customer: '%s'
""")
RSYNC_FAILED_COPY_DATABASE_DUMP_FROM_1 = multi_line_message("""
	Rsync failed to copy a database dump from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
	Retry copying the database content with the help of the copy-db-content command.
	2. Check whether rsync is installed on the source server.
""")
RSYNC_FAILED_COPY_DATABASE_DUMP_FROM = multi_line_message("""
	Rsync failed to copy a database dump from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
	Retry copying the database content with the help of the copy-db-content command.
	2. Check whether rsync is installed on the source server.
""")
RESTORE_DATABASE_DUMP_TARGET_SERVER = single_line_message("""
	Restore database dump on target server
""")
SERVER_IS_NOT_PROPERLY_CONFIGURED_TARGET = multi_line_message("""
	{server} is not properly configured on target server: credentials (login or password)are not set.
	Please configure the server, then proceed with migration.
""")
COPY_DATABASE_DUMP_FROM_SOURCE_TARGET = single_line_message("""
	Copy database dump from source to target server with rsync
""")
MYSQL_CLIENT_BINARY_WAS_NOT_FOUND = multi_line_message("""
	mysql client binary was not found on %s, database '%s' of subscription will not be copied.Make sure that: 
	1) MySQL is installed on service node.
	2) MySQL 'bin' directory is added to PATH environment variable,
	so MySQL client can be simplystarted with 'mysql' command.
	3) If (1) and (2) are ok, restart 'pem' service with 'net stop pem'and then 'net start pem' commands.
	Please check migration tool documentation for more details
""")
DATABASE_UNSUPPORTED_TYPE_AND_HENCE_NOT = single_line_message("""
	Database has unsupported type and hence will not be copied
""")
PG_DUMP_UTILITY_IS_NOT_INSTALLED = multi_line_message("""
	'pg_dump' utility is not installed on '%s' server.
	Make sure that:
	1) All external PostgreSQL servers (other than Plesk servers) are specified in
	config.ini in 'external-postgresql-servers' option, and 'pg_dump' utility is
	installed on them.
	OR
	2) 'pg_dump' is installed on all servers that have domains with
	PostgreSQL databases. Once the problem is fixed, run 'copy-db-content'
	migration tool command to transfer only the databases.
""")
CANNOT_TRANSFER_DATABASE_OF_UNSUPPORTED_TYPE = single_line_message("""
	Cannot transfer a database with unsupported type '%s'
""")
FAILED_GET_LIST_DATABASES_MSSQL_DATABASE = single_line_message("""
	Failed to get list of databases on MSSQL database server %s:%s
""")
PERSUBSCRIPTION_MIGRATION_WAS_NOT_STARTED_YET = single_line_message("""
	Per-subscription migration was not started yet, common actions are executing
""")
SUBSCRIPTION_MIGRATION_STATUS = multi_line_message("""
	Subscription migration status:
	
""")
FAILED_REMOVE_BACKUP_FILE_FROM_TARGET = single_line_message("""
	Failed to remove backup file from target Plesk, exception:
""")
RESTORATION_SUBSCRIPTION_FAILED_RESTORATION_TASK_STOPPED = single_line_message("""
	Restoration of subscription failed: restoration task stopped. Check debug.log and PMM restoration logs for more
	details
""")
RESTORATION_SUBSCRIPTION_FAILED_TIMED_OUT_WAITING = single_line_message("""
	Restoration of subscription failed: timed out waiting for the restore task. Check debug.log and PMM restoration logs
	for more details
""")
RETRIEVING_RESTORATION_LOG_S = single_line_message("""
	Retrieving the restoration log "%s"
""")
RESTORATION_SUBSCRIPTION_FAILED_NO_TASK_ID = multi_line_message("""
	Restoration of subscription failed: no task ID was returned by pmmcli.
	Check debug.log and PMM restoration logs for more details. Output of pmmcli utility:
	%s
""")
EXCEPTION_WHILE_PARSING_XML_MOST_PROBABLY = single_line_message("""
	Exception while parsing XML (most probably could be ignored):
""")
POLL_PLESK_FOR_RESTORATION_TASK_STATUS = single_line_message("""
	Poll Plesk for restoration task status, attempt #%s
""")
FAILED_IMPORT_BACKUP_XML_CAN_NOT = multi_line_message("""
	Failed to import backup XML: can not find backup id. Output of pmmcli utility:
	%s
""")
INITIALLY_WAIT_FOR_PMM_DEPLOYER_START = single_line_message("""
	Initially wait for PMM deployer to start
""")
WAITING_FOR_RESTORE_TASK_FINISH_CHECK = single_line_message("""
	Waiting for restore task to finish, check interval: %s seconds, maximum check attempts %s
""")
RESTORATION_SUBSCRIPTION_FAILED_NO_RESTORATION_STATUS = single_line_message("""
	Restoration of subscription failed: no restoration status log is available. Check debug.log and PMM restoration logs
	for moredetails
""")
WAITING_FOR_PLESK_RESTORE_TASK_FINISH = single_line_message("""
	Waiting for Plesk restore task to finish
""")
FAILED_S_IIS_DEDICATED_APPLICATION_POOL = single_line_message("""
	Failed to %s IIS dedicated application pool, see debug log for more details
""")
PROVIDED_CLIGATE_AUTH_IS_NOT_SUPPORTED = single_line_message("""
	Provided CLIGate auth is not supported
""")
UNABLE_GET_RSYNC_SOURCE_SERVER_OBJECT = single_line_message("""
	Unable to get rsync: source server object or source server ip should be specified
""")
ALLOW_PLESK_API_SHOW_PLAIN_PASSWORDS = single_line_message("""
	allow Plesk API showing plain passwords
""")
ERROR_WHILE_COPYING_VIRTUAL_HOSTS_CONTENT = single_line_message("""
	Error while copying virtual host's content: virtual host's directory '%s' does not exist on source server '%s'
""")
CHANGE_FILE_PERMISSIONS_ACCORDING_USER_MAP = single_line_message("""
	Change file permissions according to user map
""")
DISABLE_PLESK_API_SHOWING_PLAIN_PASSWORDS = single_line_message("""
	disable Plesk API showing plain passwords
""")
ERROR_WHILE_COPYING_CONTENT_DIRECTORY_S = single_line_message("""
	Error while copying content: directory '%s' does not exist on source server '%s'
""")
CHANGE_FILE_PERMISSIONS_ACCORDING_GROUP_MAP = single_line_message("""
	Change file permissions according to group map
""")
UNABLE_OPEN_CHANNEL_SSH_CONNECTION_S = single_line_message("""
	Unable to open channel on SSH connection to '%s'
""")
SUCCESSFULLY_CONNECTED_S_BY_SSH = single_line_message("""
	Successfully connected to '%s' by SSH
""")
SSH_CONNECTION_S_WAS_UNEXPECTEDLY_CLOSED = single_line_message("""
	The SSH connection to %s was unexpectedly closed, reconnecting
""")
UNABLE_CONNECT_HOST_BY_SSH_EXCEPTION = multi_line_message("""
	Unable to connect to '{host}' by SSH: {exception}.
	Ensure that the server is up and there are no firewall rules that may block SSH connections to the server,
	then re-run migration tool.
""")
SSH_CONNECTION_S_WAS_UNEXPECTEDLY_CLOSED_1 = single_line_message("""
	The SSH connection to %s was unexpectedly closed, reconnecting
""")
SHUTDOWN_WINDOWS_AGENT_AT_S = single_line_message("""
	Shutdown Windows agent at '%s'
""")
IS_FILE_INDICATING_THAT_SSL_CERTIFICATES = single_line_message("""
	This is a file indicating that SSL certificates and keys used by migration tools were generated successfully. Remove
	that file if you want to regenerate them.
""")
FAILED_DETECT_PLESK_DATA_DIRECTORY = single_line_message("""
	Failed to detect Plesk data directory
""")
PLESK_FOR_UNIX_CONFIGURATION_VARIABLE_S = single_line_message("""
	Plesk for Unix configuration variable '%s' has value '%s'
""")
FAILED_DETECT_PLESK_VIRTUAL_HOSTS_DIRECTORY = single_line_message("""
	Failed to detect Plesk virtual hosts directory
""")
UNABLE_RETRIVE_CREDENTIALS_FOR_S_DATABASE = single_line_message("""
	Unable to retrive credentials for %s database server with host %s via %s
""")
INCONSISTENCY_DATABASE_MULTIPLE_OWNERS = single_line_message("""
	Panel server '{server}' has inconsistency in its database. Customer's database '{db_name}' of type '{db_type}' on
	host '{db_host}' is owned by more than 1 webspace: {webspaces}
""")
INCONSISTENCY_DB_USER_MULTIPLE_OWNERS = single_line_message("""
	Panel server '{server}' has inconsistency in its database. Database user {db_user} of type '{db_type}' on host
	'{db_host}' is owned by more than 1 webspace: {webspaces}
""")
PLESK_VIRTUAL_HOSTS_DIRECTORY_IS_S = single_line_message("""
	Plesk virtual hosts directory is "%s"
""")
FAILED_DETECT_PLESK_BASE_DIRECTORY = single_line_message("""
	Failed to detect Plesk base directory
""")
INTERNAL_ERROR_TRYING_EXECUTE_COMMAND_THAT = single_line_message("""
	Internal error: trying to execute command that contains national symbols on Windows server. Command's Python repr
	is: %r.
""")
SSH_KEY_POOL_IS_READ_ONLY = single_line_message("""
	SSH key pool is read only as it was cleaned up
""")
INTERNAL_ERROR_FAILED_FIND_IMPORTED_BACKUP = single_line_message("""
	Internal error: failed to find imported backup for specified backup object. Probable reason is that backup was never
	imported to target panel's PMM repository
""")
FAILED_FIND_IMPORTED_BACKUP_XML_FILE = single_line_message("""
	Failed to find imported backup XML file for subscription
""")
CHANGE_PERMISSIONS_ACCORDING_FOLLOWING_RULES_S = single_line_message("""
	Change permissions according to the following rules: %s
""")
PROFILING_RESULTS = multi_line_message("""
	***************** Profiling results *****************
	
""")
TOTAL_TIME_OUTSIDE_MIGRATOR_API_CALLS = multi_line_message("""
	Total time outside migrator (API calls, external command executions, waitings, ...): %s
	
""")
FAILED_DETECT_OS_INVALID_OUTPUT_S_1 = single_line_message("""
	Failed to detect OS: invalid output '%s'
""")
FAILED_DETECT_OS_INVALID_OUTPUT_S_2 = single_line_message("""
	Failed to detect OS: invalid output '%s'
""")
FAILED_DETECT_OS_INVALID_OUTPUT_S = single_line_message("""
	Failed to detect OS: invalid output '%s'
""")
EXCEPTION_WHEN_CLOSING_SOCKET = single_line_message("""
	Exception when closing socket:
""")
EXCEPTION_WHEN_TRYING_DEPLOY_AND_START_1 = single_line_message("""
	Exception when trying to deploy and start panel migrator transfer agent, most likely agent failed to deploy, print
	manual deploy instructions. Exception:
""")
DEPLOY_PANEL_MIGRATOR_TRANSFER_AGENT_AT = single_line_message("""
	Deploy panel migrator transfer agent at '%s'
""")
TRY_START_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
	Try to start panel migrator transfer agent. If it was not deployed, this will fail
""")
TRY_STOP_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
	Try to stop panel migrator transfer agent if it is already running, but is broken for some reason, or has different
	SSL keys
""")
SSL_IS_DISABLED_FOR_AGENT_AT = single_line_message("""
	SSL is disabled for agent at '%s'
""")
EXCEPTION_WHEN_TRYING_STOP_PANEL_MIGRATOR = single_line_message("""
	Exception when trying to stop panel migrator transfer agent, most likely it could be ignored:
""")
SSL_IS_ENABLED_FOR_AGENT_AT = single_line_message("""
	SSL is enabled for agent at '%s'
""")
TRY_CONNECT_AGENT_AT_S = single_line_message("""
	Try to connect to agent at '%s'
""")
EXCEPTION_WHEN_TRYING_START_PANEL_MIGRATOR = single_line_message("""
	Exception when trying to start panel migrator transfer agent, most likely agent was not deployed, and the exception
	could be ignored:
""")
START_PANEL_MIGRATOR_TRANSFER_AGENT_AT = single_line_message("""
	Start panel migrator transfer agent at '%s'
""")
CONNECTION_FAILED_MOST_LIKELY_THAT_PANEL = single_line_message("""
	Connection failed, most likely that panel migrator transfer agent is not installed or running.
""")
EXCEPTION_WHEN_TRYING_DEPLOY_AND_START = single_line_message("""
	Exception when trying to deploy and start panel migrator transfer agent, most likely agent failed to deploy, print
	manual deploy instructions. Exception:
""")
PACK_AGENT_INTO_SELFEXTRACTABLE_ARCHIVE = single_line_message("""
	Pack agent into self-extractable archive
""")
DEPLOY_AND_START_PANEL_MIGRATOR_TRANSFER = single_line_message("""
	Deploy and start panel migrator transfer agent at '%s'
""")
UNIQUE_NAME_SUFFIX_IS_TOO_LONG = single_line_message("""
	Unique name suffix is too long
""")
UNABLE_GET_THIRDPARTIES_DIR_IT_IS = single_line_message("""
	Unable to get thirdparties dir: it is available on Windows only
""")
UNABLE_GET_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
	Unable to get panel migrator transfer agent directory: it is available on Windows only
""")
MODULE_DEFINES_PATH_MIGRATORS_THIRDPARY_UTILS = single_line_message("""
	This module defines path to migrator's thirdpary utils for Windows
""")
PACK_DUMP_XML_INTO_DUMP_ARCHIVE = single_line_message("""
	Pack dump XML into dump archive
""")
RUN_PMM_AGENT_CREATE_DUMP_XML = single_line_message("""
	Run PMM agent to create dump XML
""")
RUN_PMM_AGENT_CREATE_SHALLOW_DUMP = single_line_message("""
	Run PMM agent to create shallow dump XML
""")
RUN_PMM_AGENT_CREATE_CAPABILITY_DUMP = single_line_message("""
	Run PMM agent to create capability dump XML
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_MIGRATION_DUMP = single_line_message("""
	Creating migration dump '{dump_path}'
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_CAPABILITY_DUMP = single_line_message("""
	Creating capability dump '{dump_path}'
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_SHALLOW_DUMP = single_line_message("""
	Creating shallow migration dump '{dump_path}'
""")
DOWNLOADING_MIGRATION_DUMP_S = single_line_message("""
	Downloading migration dump '%s'
""")
UNABLE_USE_PANEL_MIGRATOR_AGENT_SERVER = multi_line_message("""
	Unable to use Panel Migrator Agent: {server} does not meet requrements.
	Please unsure that:
	1) Microsoft .NET Framework version 4 is installed
	
	
""")
CONVERT_PLESK_DUMP_PLESK_FORMAT = single_line_message("""
	Convert Plesk 8 dump to Plesk 9 format.
""")
ERROR_WHILE_PARSING_PLESK_RESTORE_XML = single_line_message("""
	Error while parsing Plesk restore XML
""")
REMOVE_BACKUP_FILE_S_FROM_TARGET_1 = single_line_message("""
	Remove backup file %s from target Plesk
""")
REMOVE_BACKUP_FILE_S_FROM_TARGET = single_line_message("""
	Remove backup file %s from target Plesk
""")
IMPORT_BACKUP_TARGET_PANEL_PMM_REPOSITORY = single_line_message("""
	Import backup to target panel PMM repository.
""")
SOME_FIELDS_ARE_EMPTY_CONTAIN_AN = single_line_message("""
	Some fields are empty or contain an improper value
""")
CHECK_THAT_COMMAND_LINE_OPTIONS_ARE = single_line_message("""
	Check that command line options are correct
""")
FAILED_CHECK_THAT_COMMAND_LINE_OPTIONS = single_line_message("""
	Failed to check that command line options are correct
""")
MIGRATION_LIST_FILE_S_SPECIFIED_MIGRATIONLISTFI = single_line_message("""
	Migration list file '%s' specified with --migration-list-file option does not exist. Check that correct path to
	migration list is specified.
""")
IP_MAPPING_FILE_S_SPECIFIED_IPMAPPINGFILE = single_line_message("""
	IP mapping file '%s' specified with --ip-mapping-file option does not exist. Check that correct path to IP mapping
	file is specified.
""")
FAILED_SHUTDOWN_WINDOWS_RSYNC_SERVERS = single_line_message("""
	Failed to shutdown Windows rsync servers
""")
SHUTDOWN_WINDOWS_RSYNC_SERVERS = single_line_message("""
	Shutdown Windows rsync servers
""")
SERVICE_PLANS_SERVICE_TEMPLATES_IMPORT_IS = single_line_message("""
	Service plans (service templates) import is not supported for current target panel. Create plans (templates)
	manually before starting subscription transfer.
""")
FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS = single_line_message("""
	Failed to check if target panel supports plans import
""")
CHECK_IF_TARGET_PANEL_SUPPORTS_PLANS = single_line_message("""
	Check if target panel supports plans import
""")
FAILED_CLOSE_SSH_CONNECTIONS = single_line_message("""
	Failed to close SSH connections
""")
PRINT_SUBSCRIPTION_MIGRATION_STATUS = single_line_message("""
	Print subscription migration status
""")
SUBSCRIPTION_MIGRATION_FINISHED_HERE_IS_STATUS = multi_line_message("""
	Subscription migration finished, here is a status:
	
""")
SUBSCRIPTION_MIGRATED_SUCCESSFULLY = single_line_message("""
	Subscription migrated successfully
""")
FAILED_PRINT_SUBSCRIPTION_MIGRATION_STATUS = single_line_message("""
	Failed to print subscription migration status
""")
FAILED_REMOVE_TEMPORARY_SSH_KEYS = single_line_message("""
	Failed to remove temporary SSH keys
""")
MIGRATION_LIST_FILE_S_ALREADY_EXISTS_1 = single_line_message("""
	Migration list file '%s' already exists, overwrite it
""")
MIGRATION_LIST_FILE_S_ALREADY_EXISTS = single_line_message("""
	Migration list file '%s' already exists. To overwrite it, use --overwrite option
""")
FAILED_CHECK_IF_MIGRATION_LIST_FILE = single_line_message("""
	Failed to check if migration list file already exists
""")
CHECK_IF_MIGRATION_LIST_FILE_ALREADY = single_line_message("""
	Check if migration list file already exists
""")
FAILED_GENERATE_MIGRATION_LIST_FILE = single_line_message("""
	Failed to generate migration list file
""")
FAILED_WRITE_MIGRATION_LIST_FILE = single_line_message("""
	Failed to write migration list file
""")
MIGRATION_LIST_FILE_TEMPLATE_IS_SAVED = single_line_message("""
	Migration list file template is saved to '%s'
""")
BROWSING_SERVICE_TEMPLATES_WHICH_COULD_USED = single_line_message("""
	Browsing service templates which could be used for migration
""")
CHECKING_IF_WEBSPACES_EXIST_IN_TARGET = single_line_message("""
	Checking, if webspaces exist in the target panel
""")
FAILED_CHECK_IF_MIGRATION_LIST_FILE_1 = single_line_message("""
	Failed to check if migration list file exists
""")
CHECK_IF_MIGRATION_LIST_FILE_EXISTS = single_line_message("""
	Check if migration list file exists
""")
MIGRATION_LIST_IS_NOT_DEFINED_PLEASE = multi_line_message("""
	A migration list is not defined. Please either:
	(*) Put the correct migration list to '%s', or
	(*) Specify its location with "--migration-list-file" command-line option.

	The migration list defines the list of object (client accounts, domains) that should
	be transferred from the source server. To generate the migration list sample, run the following command:
	# %s generate-migration-list config.ini

	Please check the migration tool documentation for more details.
""")
RESTORE_OLD_APACHE_RESTART_INTERVAL_VALUE = single_line_message("""
	Restore old Apache restart interval value
""")
FAILED_RESTORE_OLD_APACHE_RESTART_INTERVAL = single_line_message("""
	Failed to restore the old Apache restart interval value: %s
""")
RESTORE_APACHE_RESTART_INTERVAL = single_line_message("""
	Restore Apache restart interval
""")
FORCE_APACHE_RESTART = single_line_message("""
	Force Apache restart
""")
FAILED_FIX_PERMISSIONS_FOR_VHOST_DIRECTORY = single_line_message("""
	Failed to fix permissions for vhost directory of subscription '%s'
""")
FIX_PERMISSIONS_FOR_VHOST_DIRECTORY = single_line_message("""
	Fix permissions for vhost directory
""")
RSYNC_FAILED_COPY_FILES_FROM_SOURCE = multi_line_message("""
	Rsync failed to copy files from the source (%s) to the target server (%s): %s
	This could happen because of a network connection issue.
	Retry copying the files with the help of the "copy-content" command.
""")
FILE_DIRECTORY_S_SUBSCRIPTION_S_DOES = single_line_message("""
	File or directory '%s' of subscription '%s' does not exist on source server %s, so it won't be transferred
""")
FAILED_COPY_WEB_FILES_FOR_SUBSCRIPTION = single_line_message("""
	Failed to copy web files for subscription '%s'
""")
COPY_WEB_CONTENT_FAILED_FOR_SUBSCRIPTION = single_line_message("""
	Copy web content failed for subscription '%s': file or directory '%s' does not exist on source server %s
""")
COPY_WEB_FILES_FROM_WINDOWS_SERVERS = single_line_message("""
	Copy web files from Windows servers
""")
FAILED_COPY_WEB_FILES_FOR_SUBSCRIPTION_1 = single_line_message("""
	Failed to copy web files for subscription '%s'
""")
COPY_WEB_FILES_FROM_UNIX_SERVERS = single_line_message("""
	Copy web files from Unix servers
""")
RSYNC_FAILED_COPY_FILES_FROM_SOURCE_1 = multi_line_message("""
	Rsync failed to copy files from the source (%s) to the target server (%s): %s
	1. This could happen because of a network connection issue.
	Retry copying the files with the help of the "copy-content" command.
	2. Check whether rsync is installed and configured on the source server.
""")
FAILED_COPY_MAIL_CONTENT_SUBSCRIPTION_MOST = single_line_message("""
	Failed to copy mail content of subscription. Most probably that happens because of a network-related issue. Please
	check network connections between source and target servers, then re-copymail content with the help of 'copy-mail-
	content' command
""")
FAILED_COPY_DATABASE_CONTENT_SUBSCRIPTION_MOST = single_line_message("""
	Failed to copy database content of subscription. Most probably that happens because of a network-related issue.
	Please check network connections between source and target servers, then re-copydatabase content with the help of
	'copy-db-content' command
""")
EXTRACTING_FILES_FROM_BACKUP_S_S = single_line_message("""
	Extracting files from backup '%s' to '%s'
""")
FAILED_SAVE_CONVERTED_BACKUP_FILE = single_line_message("""
	Failed to save converted backup to file
""")
FAILED_CREATE_CONVERTED_BACKUPS = single_line_message("""
	Failed to create converted backups
""")
REMOVE_CONTENT_NODES_FROM_BACKUPS = single_line_message("""
	Remove content nodes from backups
""")
UNABLE_REMOVE_CONTENT_NODES_FROM_BACKUPS = single_line_message("""
	Unable to remove content nodes from backups
""")
FAILED_FIND_ACTION_S_AFTER_WHICH = single_line_message("""
	Failed to find action '%s' after which we should insert another action
""")
FAILED_FIND_ACTION_S_BEFORE_WHICH = single_line_message("""
	Failed to find action '%s' before which we should insert another action
""")
SKIPPED_CREATING_AN_EXISTING_AUXUSER = single_line_message("""
	Skipped creating an existing auxiliary user
""")
FAILED_CREATE_AUXILIARY_USER_PLESK_API = single_line_message("""
	Failed to create auxiliary user with Plesk API.
""")
CONCRETE_IMPORT_CLIENTS_AND_SUBSCRIPTIONS_ACTIONS = single_line_message("""
	Concrete import clients and subscriptions actions are not defined for target panel '%s'
""")
IMPORT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
	Create clients and subscriptions on target panel
""")
FAILED_IMPORT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
	Failed to create clients and subscriptions on target panel
""")
SKIPPED_CREATING_AN_EXISTING_ROLE = single_line_message("""
	Skipped creating an existing role
""")
FAILED_RESTORE_AUXUSER_ROLES = single_line_message("""
	Failed to restore auxiliary user roles
""")
SKIPPED_CREATING_DEFAULT_ROLE = single_line_message("""
	Skipped creating a default role
""")
FAILED_CREATE_AUXILIARY_USER_ROLE_PLESK_2 = single_line_message("""
	Failed to create auxiliary user role with Plesk API.
""")
FAILED_CREATE_SUBSCRIPTION_S_IN_TARGET = single_line_message("""
	Failed to create subscription '%s' in target panel
""")
PARALLEL_CREATION_SUBSCRIPTIONS_MAY_FAIL_ACQUIRE = single_line_message("""
	Parallel creation of subscriptions may fail, acquire lock
""")
CREATE_SUBSCRIPTION_IN_TARGET_PANEL = single_line_message("""
	Create subscription in target panel
""")
SUBSCRIPTION_ALREADY_EXISTS_BUT_NO_HOSTING = single_line_message("""
	Subscription already exists, but has no hosting. Enable virtual hosting.
""")
RELEASE_LOCK_FOR_CREATION_SUBSCRIPTIONS_OPERATION = single_line_message("""
	Release lock for creation of subscriptions operation
""")
CREATE_CLIENT_S_OWNED_BY_ADMINISTRATOR = single_line_message("""
	Create client '%s' owned by administrator
""")
CREATE_CLIENT_S_OWNED_BY_RESELLER = single_line_message("""
	Create client '%s' owned by reseller '%s'
""")
FAILED_CREATE_CLIENT_IN_TARGET_PANEL = single_line_message("""
	Failed to create client in target panel
""")
CREATE_CLIENTS_IN_TARGET_PANEL = single_line_message("""
	Create clients in target panel
""")
CLIENT_LOGIN_S_ALREADY_EXISTS_SKIP = single_line_message("""
	Client with login '%s' already exists, skip creating
""")
FAILED_CREATE_CLIENTS_TARGET_PANEL_MIGRATION = single_line_message("""
	Failed to create clients on target panel, migration can not proceed to the next steps
""")
INVALID_COMBINATION_MULTITHREADING_OPTIONS = single_line_message("""
	Invalid combination of multithreading options
""")
ANALYSING_HOSTING_OS_RESOURCE_USAGE_AND = single_line_message("""
	Analysing hosting OS resource usage and webspaces content
""")
FAILED_ANALYSE_MIGRATION_NODES = single_line_message("""
	Failed to analyse migration nodes
""")
FAILED_RESTORE_HOSTING_SETTINGS_SUBSCRIPTION_S = single_line_message("""
	Failed to restore hosting settings of subscription '%s'
""")
RESTORE_HOSTING_SETTINGS_SUBSCRIPTION = single_line_message("""
	Restore hosting settings of subscription
""")
TRANSFER_CUSTOM_ERROR_DOCUMENTS_SITE_S = single_line_message("""
	Transfer custom error documents of site '%s' and its virtual directories
""")
SKIP_TRANSFER_CUSTOM_ERROR_DOCUMENTS_FOR = single_line_message("""
	Skip transfer custom error documents for site '%s' of subscription '%s' as is has no virtual hosting
""")
RESTORE_ERROR_DOCUMENTS_VIRTUAL_DIRECTORY_S = single_line_message("""
	Restore error documents of virtual directory '%s'
""")
SKIP_TRANSFER_CUSTOM_ERROR_DOCUMENTS_TYPES = single_line_message("""
	Skip transfer custom error documents types for subscription '%s' as is has no virtual hosting
""")
TRANSFER_CUSTOM_ERROR_DOCUMENTS = single_line_message("""
	Transfer custom error documents
""")
RESTORE_ERROR_DOCUMENTS_VIRTUAL_HOSTS_ROOT = single_line_message("""
	Restore error documents of virtual host's root
""")
FAILED_TRANSFER_CUSTOM_ERROR_DOCUMENTS_FOR = single_line_message("""
	Failed to transfer custom error documents for subscription '%s'
""")
THERE_IS_NO_SYSTEM_USER_LOGIN = single_line_message("""
	There is no system user login in backup, skip changing
""")
THERE_IS_NO_SYSTEM_USER_LOGIN_1 = single_line_message("""
	There is no system user login on target system, skip changing
""")
UNABLE_RESTORE_ORIGINAL_USERNAME_S_FOR = single_line_message("""
	Unable to restore the original username ('%s') for the system user of the subscription %s: it does not conform to
	the target panel rules. For this reason, the subscription owner will not be able to log in to FTP under the original
	username.
""")
UNABLE_RESTORE_ORIGINAL_USERNAME_FOR_SYSTEM = single_line_message("""
	Unable to restore the original username for the system user of the subscription %s: a system user named %s is
	already present on target panel. For this reason, the subscription owner will not be able to log in to FTP under the
	original username.
""")
FAILED_RESTORE_LOGIN_SYSTEM_USER_FOR = single_line_message("""
	Failed to restore login of system user for subscription '%s'
""")
NOTIFY_SUBSCRIPTION_OWNER_NEW_FTP_USERNAME = single_line_message("""
	Notify the subscription owner of the new FTP username: %s. The subscription owner can change this username on target
	panel.
""")
RESTORE_LOGINS_SYSTEM_USERS_1 = single_line_message("""
	Restore logins of system users
""")
NOTIFY_SUBSCRIPTION_OWNER_NEW_FTP_USERNAME_1 = single_line_message("""
	Notify the subscription owner of the new FTP username: %s. The subscription owner can change this username on target
	panel.
""")
REMOVE_IMPORTED_BACKUP_DUMPS_FROM_TARGET = single_line_message("""
	Remove imported backup dumps from target panel's repository
""")
FAILED_REMOVE_IMPORTED_BACKUP_DUMPS_TARGET = single_line_message("""
	Failed to remove imported backup dumps to target panel's repository
""")
FOLLOWING_SITES_SUBSCRIPTION_WERE_NOT_RESTORED = single_line_message("""
	The following sites of subscription were not restored - they do not exist on target panel: %s
""")
SUBSCRIPTION_WAS_NOT_RESTORED_IT_DOES = single_line_message("""
	Subscription was not restored: it does not exist on target panel
""")
CHECK_THAT_EACH_SITE_SUBSCRIPTION_WAS = single_line_message("""
	Check that each site of subscription was restored and exists in target panel
""")
FAILED_VERIFY_THAT_HOSTING_SETTINGS_WERE = single_line_message("""
	Failed to verify that hosting settings were restored for subscription '%s'
""")
VERIFY_THAT_HOSTING_SETTINGS_WERE_RESTORED = single_line_message("""
	Verify that hosting settings were restored
""")
CHECK_IF_SUBSCRIPTION_WAS_RESTORED_IT = single_line_message("""
	Check if subscription was restored: it should exist in target panel
""")
SKIP_TRANSFER_MIME_TYPES_FOR_SITE = single_line_message("""
	Skip transfer MIME types for site '%s' of subscription '%s' as it has no virtual hosting
""")
SKIP_TRANSFER_MIME_TYPES_FOR_SUBSCRIPTION = single_line_message("""
	Skip transfer MIME types for subscription '%s' as is has no virtual hosting
""")
TRANSFER_MIME_TYPES_SITE_S_AND = single_line_message("""
	Transfer MIME types of site '%s' and its virtual directories
""")
TRANSFER_MIME_TYPES_FOR_SITES_SUBSCRIPTION = single_line_message("""
	Transfer MIME types for sites of subscription '%s'
""")
RESTORE_MIME_TYPES_VIRTUAL_HOSTS_ROOT = single_line_message("""
	Restore MIME types of virtual host's root
""")
FAILED_TRANSFER_MIME_TYPES_FOR_SUBSCRIPTION = single_line_message("""
	Failed to transfer MIME types for subscription '%s'
""")
RESTORE_MIME_TYPES_VIRTUAL_DIRECTORY_S = single_line_message("""
	Restore MIME types of virtual directory '%s'
""")
FAILED_IMPORT_BACKUP_DUMPS_TARGET_PANELS = single_line_message("""
	Failed to import backup dumps to target panel's repository
""")
IMPORT_BACKUP_DUMPS_TARGET_PANELS_REPOSITORY = single_line_message("""
	Import backup dumps to target panel's repository
""")
UPLOAD_BACKUP_DUMP_S_TARGET_NODE = single_line_message("""
	Upload backup dump '%s' to target node
""")
IMPORT_BACKUP_DUMP_TARGET_PANELS_REPOSITORY = single_line_message("""
	Import backup dump to target panel's repository
""")
CREATE_MAPPING_DOMAIN_NAME_BACKUP_XML = single_line_message("""
	Create mapping of domain name to backup XML file name
""")
TRANSFER_VIRTUAL_DIRECTORIES_SITE_S = single_line_message("""
	Transfer virtual directories of site '%s'
""")
FAILED_TRANSFER_VIRTUAL_DIRECTORIES_FOR_SUBSCRIPTION = single_line_message("""
	Failed to transfer virtual directories for subscription '%s'
""")
NO_VIRTUAL_DIRECTORIES_INFORMATION_FOR_SITE = single_line_message("""
	No virtual directories information for site '%s', won't transfer them
""")
SKIP_TRANSFER_VIRTUAL_DIRECTORIES_FOR_SUBSCRIPTION = single_line_message("""
	Skip transfer virtual directories for subscription '%s' as is has no virtual hosting
""")
SKIP_TRANSFER_VIRTUAL_DIRECTORIES_FOR_SITE = single_line_message("""
	Skip transfer virtual directories for site '%s' of subscription '%s' as is has no virtual hosting
""")
RESET_HOSTING_FOR_SUBSCRIPTIONS_WITHOUT_HOSTING = single_line_message("""
	Reset hosting for subscriptions without hosting
""")
FAILED_RESET_HOSTING_FOR_SUBSCRIPTIONS_WITHOUT = single_line_message("""
	Failed to reset hosting for subscriptions without hosting '%s'
""")
RESTORE_CATCHALL_SETTINGS_FOR_SMARTERMAIL_ASSIMILATION = single_line_message("""
	Restore catch-all settings for SmarterMail assimilation mode
""")
EXPECTED_EXACTLY_ONE_SUBSCRIPTION_GOT_S = single_line_message("""
	Expected exactly one subscription, got %s
""")
FAILED_RESTORE_CATCHALL_SETTINGS_FOR_SMARTERMAIL = single_line_message("""
	Failed to restore catch-all settings for SmarterMail assimilation mode for subscription '%s'
""")
CHANGE_NONVALID_SYSTEM_USER_PASSWORD = single_line_message("""
	Change non-valid system user password
""")
SYSTEM_USER_S_TRANSFERRED_ANOTHER_PASSWORD = single_line_message("""
	The system user '%s' will be transferred with another password: '%s'. You can change the password for the
	corresponding system/FTP/web user on target panel once the content transfer is finished.
""")
PASSWORD_SYSTEM_USER_S_DOES_NOT = single_line_message("""
	Password of system user '%s' does not meet target panel's requirements.
""")
FAILED_CHANGE_NONVALID_SYSTEM_USER_PASSWORDS = single_line_message("""
	Failed to change non-valid system user passwords for subscription '%s'
""")
CHANGE_LOGINS_SYSTEM_USERS_IN_BACKUP = single_line_message("""
	Change logins of system users in backup
""")
FAILED_CHANGE_LOGIN_SYSTEM_USER_FOR = single_line_message("""
	Failed to change login of system user for subscription '%s'
""")
FAILED_RESTORE_SUBSCRIPTION_SYSTEM_USERS_LOGIN_1 = single_line_message("""
	Failed to restore subscription system user's login.
""")
REMOVE_DEFAULT_DATABASE_SERVER_FROM_BACKUP = single_line_message("""
	Remove default database server from backup
""")
FAILED_REMOVE_DEFAULT_DATABASE_SERVERS_FOR = single_line_message("""
	Failed to remove default database servers for subscription '%s'
""")
SUBSCRIPTION_S_WEBMAIL_THAT_DOES_NOT = single_line_message("""
	Subscription '%s' has webmail that is not supported by target panel, so it was changed to Horde.
""")
FAILED_CHANGE_WEBMAIL_FOR_SUBSCRIPTION_S = single_line_message("""
	Failed to change webmail for subscription '%s'
""")
CHANGE_WEBMAIL_FROM_OLD_WEBMAILS_HORDE = single_line_message("""
	Change webmail from old webmails to Horde
""")
REMOVE_DISABLED_MAILSYSTEM_WITHOUT_RESOURCE_IN = single_line_message("""
	Remove disabled mailsystem without resource in backup
""")
FAILED_REMOVE_DISABLED_MAILSYSTEM_FOR_SUBSCRIPTION = single_line_message("""
	Failed to remove disabled mailsystem for subscription '%s'
""")
SUBSCRIPTION_S_DISABLED_MAIL_AND_SERVICE = multi_line_message("""
	Subscription '%s' has disabled mail and service template does not have mail
	resource, so mailsystem node was removed.
""")
MAIL_USER_S_TRANSFERRED_ANOTHER_PASSWORD = single_line_message("""
	The mail user '%s' will be transferred with another password: '%s'.
""")
FAILED_CHANGE_SMARTERMAIL_PASSWORDS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to change SmarterMail passwords for subscription '%s'
""")
PASSWORD_MAIL_USER_S_DOES_NOT = single_line_message("""
	Password of mail user '%s' does not meet Windows mail server requirements.
""")
CHANGE_SMARTERMAIL_PASSWORDS_IN_BACKUPS = single_line_message("""
	Change SmarterMail passwords in backups
""")
FAILED_CHANGE_CATCH_ALL_REDIRECT_FOR = single_line_message("""
	Failed to change catch all redirect for subscription '%s'
""")
CHANGE_SERVER_CATCHALL_REDIRECT_DISCART = single_line_message("""
	Change server catch-all redirect to discart
""")
REMOVE_RELATION_PLANS_AND_SUBSCRIPTIONS_FROM = single_line_message("""
	Remove relation of plans and subscriptions from backup
""")
FAILED_REMOVE_RELATION_PLANS_AND_SUBSCRIPTION = single_line_message("""
	Failed to remove relation of plans and subscription for '%s'
""")
FAILED_REMOVE_DOMAIN_KEYS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to remove domain keys for subscription '%s'
""")
REMOVE_DOMAINS_KEYS_FROM_BACKUP = single_line_message("""
	Remove domains keys from backup
""")
REMOVE_FEATURES_THAT_ARE_NOT_SUPPORTED = single_line_message("""
	Remove features that are not supported by SmarerMail from backup
""")
FAILED_REMOVE_FEATURES_THAT_ARE_NOT = single_line_message("""
	Failed to remove features that are not supported by SmarerMail for subscription '%s'
""")
FAILED_REMOVE_LIMITS_AND_PERMISSIONS_FOR = single_line_message("""
	Failed to remove limits and permissions for subscription '%s'
""")
REMOVE_LIMITS_AND_PERMISSIONS_FROM_BACKUP = single_line_message("""
	Remove limits and permissions from backup
""")
FAILED_REMAP_DATABASE_SERVERS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to remap database servers for subscription '%s'
""")
CHANGE_DATABASE_SERVERS_IN_BACKUPS = single_line_message("""
	Change database servers in backups
""")
CHANGE_DATABASE_SERVER_LOCATION_FOR_DATABASE = single_line_message("""
	Change database server location for database users
""")
CHANGE_DATABASE_SERVER_LOCATION_FOR_DATABASES = single_line_message("""
	Change database server location for databases
""")
DNS_CONVERSION_IS_IMPLEMENTED_ONLY_FOR = single_line_message("""
	DNS conversion is not implemented for current target panel
""")
FAILED_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to convert DNS records for subscription '%s'
""")
FAILED_SWITCH_PHP_ISAPI_PHP_FASTCGI = single_line_message("""
	Failed Switch PHP 5.3/ISAPI to PHP 5.3/FastCGI for Windows domains in backup for subscription '%s'
""")
SWITCH_PHP_ISAPI_PHP_FASTCGI_FOR = single_line_message("""
	Switch PHP 5.3/ISAPI to PHP 5.3/FastCGI for Windows domains in backup
""")
FAILED_REMOVE_EXTERNAL_IDS_FOR_SUBSCRIPTION = single_line_message("""
	Failed to remove external IDs for subscription '%s'
""")
DELETE_SUBSCRIPTIONS_EXTERNAL_ID = single_line_message("""
	Delete subscriptions' external ID
""")
REMOVE_EXTERNAL_IDS_FROM_BACKUP = single_line_message("""
	Remove external IDs from backup
""")
FAILED_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION_2 = single_line_message("""
	Failed to convert DNS records for subscription '%s'
""")
ACTION_CHECK_DATABASE_CONFLICTS_DESCRIPTION = single_line_message("""
	Check database conflicts, when database or database user already exists but owned by another subscription
""")
ACTION_CHECK_DATABASE_CONFLICTS_FAILURE = single_line_message("""
	Failed to check database conflicts for subscription '%s'
""")
DATABASE_EXISTS_ISSUE = single_line_message("""
	Database '{db_name}' of type '{db_type}' of subscription can not be migrated: database with such name already exists
	on target server and is owned by another subscription '{target_owner_subscription}'
""")
DATABASE_EXISTS_SOLUTION = single_line_message("""
	Rename database either on source or on target to make database name unique. Other possible way is to migrate
	subscription to another database server (attach new external database server, specify it in service plan the
	subscription is assigned to)
""")
DATABASE_USER_EXISTS_ISSUE = single_line_message("""
	Database '{db_name}' of type '{db_type}' of subscription can not be migrated: database user of the database with
	name '{db_user}' already exists on target server and is owned by another subscription '{target_owner_subscription}'.
""")
DATABASE_USER_EXISTS_SOLUTION = single_line_message("""
	Migrating database in such situation may lead to invalid ownership of database tables. Rename database user on
	source or on target to make database user name unique. Other possible way is to migrate subscription to another
	database server (attach new external database server, specify it in service plan the subscription is assigned to)
""")
FAILED_CHECK_FOR_EMPTY_PASSWORDS_MAILBOXES = single_line_message("""
	Failed to check for empty passwords of mailboxes for subscription '%s'
""")
SET_PASSWORD_FOR_S_MAILUSER_SOURCE = single_line_message("""
	Set password for '%s' mailuser on source panel.
""")
CONTENT_CAN_NOT_MIGRATED_FOR_S = single_line_message("""
	Content can not be migrated for '%s' mailuser because of empty password of mailuser.
""")
CHECK_EMPTY_PASSWORDS_MAILBOXES = single_line_message("""
	Check empty passwords of mailboxes
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS = single_line_message("""
	Failed to check if source panel supports setting DNS timings
""")
SETTING_LOW_DNS_TIMINGS_IS_NOT = single_line_message("""
	Setting low DNS timings is not supported by this type of migration. Set them manually in the configurations of DNS
	zones, or just wait for about two TTL intervals when migrating.
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_SETTING = single_line_message("""
	Check if source panel supports setting DNS timings
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_1 = single_line_message("""
	Failed to check if source panel supports DNS forwarding
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS = single_line_message("""
	Check if source panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_FOR = single_line_message("""
	DNS forwarding is not supported for this type of migration. Switch IP addresses of DNS servers manually at registar.
""")
FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS_1 = single_line_message("""
	Failed to check if target panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_WHEN = multi_line_message("""
					DNS forwarding is not supported when migrating to Parallels
					Plesk Panel. Switch IP addresses of DNS servers manually at
					registar.
""")
CHECK_IF_TARGET_PANEL_SUPPORTS_DNS = single_line_message("""
	Check if target panel supports DNS forwarding
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS_1 = single_line_message("""
	Check if source panel supports DNS forwarding
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_2 = single_line_message("""
	Failed to check if source panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_FOR_1 = single_line_message("""
	DNS forwarding is not supported for this type of migration. Switch IP addresses of DNS servers manually at registar.
""")
UNABLE_LOGIN_S_SSH_SERVICE_DUE = multi_line_message("""
	Unable to login to %s SSH service due to incorrect login/password specified in config file.
	Set valid credentials in 'ssh-username' and 'ssh-password' options in corresponding section in config file and
	re-run migration tool.
""")
CHECK_SSH_CONNECTION_FOR_S_SERVER = single_line_message("""
	Check SSH connection for %s server
""")
ALL_SSH_CONNECTIONS_WERE_ALREADY_CLOSED = single_line_message("""
	All SSH connections were already closed
""")
CLOSE_SSH_CONNECTION_S = single_line_message("""
	Close SSH connection to the %s
""")
CLOSE_SSH_CONNECTION_S_1 = single_line_message("""
	Close SSH connection to the %s
""")
SSH_CONNECTION_S_IS_ALREADY_OPENED = single_line_message("""
	SSH connection to the %s is already opened
""")
DOMAIN_NAME_S_NOT_FOUND = single_line_message("""
	Domain with name '%s' not found
""")
DOMAIN_NAME_S_NOT_FOUND_1 = single_line_message("""
	Domain with name '%s' not found
""")
OPENED_ZIP_FILE_FROM_FILEOBJECT = single_line_message("""
	Opened a zip file from a fileobject
""")
OPENED_TAR_FILE_FROM_FILEOBJECT = single_line_message("""
	Opened a tar file from a fileobject
""")
READING_DUMP_FROM_TAR_ARCHIVE_S = single_line_message("""
	Reading dump from a TAR archive %s
""")
PLESK_DOESNT_SUPPORT_RESELLERS_1 = single_line_message("""
	Plesk 8 doesn't support resellers
""")
READING_DUMP_FROM_ZIP_ARCHIVE_S = single_line_message("""
	Reading dump from a ZIP archive %s
""")
EXPECTED_HAVE_ONE_NO_DOMAINUSER_NODES = single_line_message("""
	Expected to have one or no domainuser nodes in Plesk backup XML for client '%s'
""")
DISCARD_PATH_R_AS_HAVING_UNKNOWN = single_line_message("""
	Discard path %r as having unknown type/purpose and being not needed.
""")
READING_DUMP_FROM_PLESK_BACKUP_FILE = single_line_message("""
	Reading dump from Plesk 8 backup file %s
""")
PLESK_DOESNT_SUPPORT_RESELLERS = single_line_message("""
	Plesk 8 doesn't support resellers
""")
FAILED_FIND_SUBSCRIPTION_S_IN_BACKUP = single_line_message("""
	Failed to find subscription '%s' in backup file
""")
SAVING_FILEOBJECT_USING_S_FORMAT = single_line_message("""
	Saving a fileobject using %s format
""")
S_PLEASE_FIX_MIGRATION_TOOL_CONFIGURATION = single_line_message("""
	%s. Please fix migration tool configuration file ('%s') and run migration tool again.
""")
SHOW_HELP_INTERNAL_COMMANDS = single_line_message("""
	Show help on internal commands
""")
ADVANCED_COMMANDS_ARE_EXECUTED_AS_SEPARATE = single_line_message("""
	The advanced commands are executed as separate steps of the commands listed in the main section, but can be invoked
	separately for problem resolution or more granular migration process. Advanced commands:
""")
START_PYTHON_SCRIPT_IN_MIGRATOR_ENVIRONMENT = single_line_message("""
	Start Python script in migrator environment
""")
ERROR_OCCURRED_WHILE_WORKING_FOLLOWING_STRING = single_line_message("""
	Error occurred while working with the following string: %r
""")
INTERNAL_COMMANDS_ARE_INTENDED_USE_BY = single_line_message("""
	The internal commands are intended to use by migration tool developers. Internal commands:
""")
INTERNAL_MIGRATOR_ERROR_CAUSED_BY_UNICODE = single_line_message("""
	Internal migrator error caused by unicode string processing: '%s', migration is aborted. See the traceback and the
	string that caused failure in debug log.
""")
SHOW_HELP_ADVANCED_COMMANDS = single_line_message("""
	Show help on advanced commands
""")
INTERNAL_MIGRATOR_ERROR_S_MIGRATION_IS = single_line_message("""
	Internal migrator error: '%s', migration is aborted. See the traceback in debug log for more information.
""")
PATH_PANEL_MIGRATOR_CONFIGURATION_FILE_SEE = multi_line_message("""
	
	Path to Panel Migrator configuration file.
	See http://docs.python.org/library/logging.config.html#configuration-file-format for configure logging.
""")
MIGRATION_STOPPED_BY_USER_REQUEST = single_line_message("""
	Migration stopped by user request
""")
START_PYTHON_INTERPRETER_IN_MIGRATOR_ENVIRONMENT = single_line_message("""
	Start Python interpreter in migrator environment
""")
AVAILABLE_VARIABLES_MIGRATOR_OPTIONS = single_line_message("""
	Available variables: migrator, options.
""")
FAILED_READ_CONFIGURATION_FILE_THERE_IS = single_line_message("""
	Failed to read configuration file: there is no section '[%s]'. Please fix migration tool configuration file ('%s')
	and run migration tool again.
""")
IGNORE_PREMIGRATION_ERRORS_AND_CONTINUE_MIGRATION = single_line_message("""
	Ignore pre-migration errors and continue migration even if there are some of them. Do not use it, it is left for use
	by support only.
""")
SWITCH_STRICT_MODE_IN_WHICH_NEW = single_line_message("""
	Switch to the strict mode in which new webspaces are created using only the resources required for the transfer of
	the corresponding subscriptions.
""")
DO_NOT_CHECK_ANY_LICENSES_ON_TARGET = single_line_message("""
	Do not check any licenses on target servers
""")
COMMAND_TEST_SERVICES = single_line_message("""
	Check that services are working correctly.
""")
DO_NOT_CHECK_SERVICES_FOR_ANY = single_line_message("""
	Do not check services for any issues that may affect migration
""")
FORCE_FETCHING_DATA_FROM_SOURCE_PANELS = single_line_message("""
	Force fetching data from source panels, do not use already fetched data.
""")
COMMAND_CHECK_TARGET_PANEL_LICENSES = single_line_message("""
	Check target panel licenses
""")
COMMAND_FETCH_SOURCE = single_line_message("""
	Download configuration data from source Plesk servers
""")
COMMAND_TRANSFER_WPB = single_line_message("""
	Transfer Web Presense Builder sites
""")
COPY_HOSTING_CONTENT_DESTINATION_SERVERS = single_line_message("""
	Copy hosting content to destination servers
""")
IMPORT_RESELLERS_NOTE_THAT_ONLY_CONTACT = single_line_message("""
	Import resellers. Note that only contact data is imported, and you should assign resellers to resellers plans
	manually
""")
CHECK_IF_BILLING_DATA_CAN_SUCCESSFULLY = single_line_message("""
	Check if billing data can be successfully transferred from H-Sphere
""")
COMMAND_UNDO_DNS_FORWARDING = single_line_message("""
	Undo DNS forwarding on all source Plesk servers
""")
TRANSFER_BILLING_DATA_FROM_HSPHERE = single_line_message("""
	Transfer billing data from H-Sphere
""")
COMMAND_RESTORE_STATUS = single_line_message("""
	Restore suspended status for the subscriptions, which were suspended in the originating system
""")
DO_NOT_CHECK_THAT_DNS_QUERIES = single_line_message("""
	Do not check that DNS queries for the transferred domains are correctly forwarded to target DNS servers
""")
SET_LOW_DNS_TIMING_VALUES_TTL = single_line_message("""
	Set low DNS timing values (TTL, refresh, retry, etc). This operation should be done in advance to insure quick
	transition to the new DNS server. Low DNS timing values are set for all domains on source Plesk servers.
""")
DO_NOT_USE_RELOAD_SOURCE_DATA = single_line_message("""
	Do not use reload source data if it was already fetched.
""")
COMMAND_VERIFY_HOSTING = single_line_message("""
	Verify that subscriptions, domains and hosting settings were restored
""")
COMMAND_TEST_USERS = single_line_message("""
	Check that system users are transferred correctly (access by FTP, SSH and RDP is checked).
""")
GENERATE_MIGRATION_LIST_FILE_FILE_COULD = single_line_message("""
	Generate migration list file. This file could be used to migrate only a specified set of plans and subscriptions,
	and to map subscriptions to plans. Comment out all objects that you don't want to be migrated
""")
WRITE_MIGRATION_LIST_FILE_FILE_COULD = single_line_message("""
	Write stdin into migration list file
""")
COMMAND_RESTORE_HOSTING = single_line_message("""
	Configure original hosting settings from source panel on target panel
""")
MIGRATION_LIST_FILENAME_DEFAULT_VALUE_IS = single_line_message("""
	Migration list filename, default value is $session_dir/migration-list
""")
SUSPEND_ACCOUNTS_IN_HSPHERE_EVEN_IF = single_line_message("""
	Suspend the accounts in H-Sphere even if H-Sphere is configured to delete the suspended accounts
""")
IGNORE_ERRORS_FETCHSOURCE_STAGE_HSPHERE_MIGRATION = single_line_message("""
	Ignore errors on fetch-source stage of H-Sphere migration
""")
COMMAND_CHECK_INFRASTRUCTURE = single_line_message("""
	Check infrastructure (connections between nodes, disk space requirements) for common issues that can make copy web,
	mail or database content stages to fail
""")
MIGRATOR_FROM_PARALLELS_PLESKS_PARALLELS_PLESK = single_line_message("""
	Migrator from Parallels Plesk(s) to Parallels Plesk Automation
""")
IP_MAPPING_FILENAME_FILE_CONTAINS_SOURCE = single_line_message("""
	IP mapping filename. This file contains source IP to target IP mapping.
""")
COMMAND_CONVERT = single_line_message("""
	Convert source data files to target panel format
""")
SOURCE_TYPE_NOT_SUPPORTED = single_line_message("""
	Source type '{source_type}' specified in 'source-type' option of '[GLOBAL]' section of configuration file is not
	supported. Supported types: {supported_types}
""")
TARGET_TYPE_NOT_SUPPORTED = single_line_message("""
	Target type '{target_type}' specified in 'target-type' option of '[GLOBAL]' section of configuration file is not
	supported. Supported types: {supported_types}
""")
COMMAND_TEST_DATABASES = single_line_message("""
	Check that the database service works fine for transferred domains.
""")
DO_NOT_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
	Do not check disk space requirements for the main node
""")
COMMAND_LIST_OPTIONS = single_line_message("""
	Return list of available options
""")
COMMAND_TEST_DNS = single_line_message("""
	Check that the DNS queries for transferred domains' records are ok.
""")
COMMAND_TEST_MAIL = single_line_message("""
	Check that the mail service works fine for transferred domains: check login to all transferred mailboxes by IMAP and
	SMTP.
""")
COMMAND_CONVERT_HOSTING_SETTINGS = single_line_message("""
	Convert source hosting settings according to target subscription settings
""")
DO_NOT_CHECK_INFRASTRUCTURE_FOR_ANY = single_line_message("""
	Do not check infrastructure for any issues that may affect migration
""")
COMMAND_TEST_ALL = single_line_message("""
	Check that the transferred domains are working correctly: test web sites, DNS, mail and FTP
""")
OVERWRITE_FILE_IF_IT_ALREADY_EXISTS = single_line_message("""
	Overwrite file if it already exists
""")
COMMAND_TEST_SITES = single_line_message("""
	Check that the web sites of the transferred domains are working correctly.
""")
COMMAND_UNPACK_BACKUPS = single_line_message("""
	Unpack all Plesk backups to $session_dir/unpacked directory
""")
CHECK_FOR_POTENTIAL_MIGRATION_ISSUES = single_line_message("""
	Check for potential migration issues
""")
COMMAND_TRANSFER_RESOURCE_LIMITS = single_line_message("""
	Transfer account resource limits and usage from H-Sphere
""")
COMMAND_CHECK_MAIN_NODE_DISK_SPACE_REQUIREMENTS = single_line_message("""
	Check main node disk space requirements
""")
FAILED_TO_DETECT_ARCH = multi_line_message("""
	Failed to detect OS architecture for {server}. Assuming 64-bit.
	Reason: {reason}
""")
LOG_NO_NEED_TO_COPY_MAILCONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
	Mail content migration for subscription '%s' is disabled in migration config file
""")
LOG_NO_NEED_TO_COPY_MAILCONTENT_BECAUSE_OF_ASSIMILATION = single_line_message("""
	Mail server of subscription '%s' is migrated in assimilate mode, no need to copy mail content
""")
LOG_NO_NEED_TO_COPY_WEBCONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
	Web content migration for subscription '%s' is disabled in migration config file
""")
LOG_NO_NEED_TO_COPY_DB_CONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
	Database content migration for subscription '%s' is disabled in migration config file
""")
OPTION_ASYNC_HELP = single_line_message("""
	Run command asynchronously
""")
OPTION_QUIET_HELP = single_line_message("""
	Do not display log entries in console output
""")
OPTION_SKIP_PROFILING_HELP = single_line_message("""
	Do not write profiler report
""")
OPTION_TYPE_CHECKER_HELP = single_line_message("""
	Write type checker report
""")

DISABLE_HIGH_LOG_PRIORITY = single_line_message("""
	Please change value of '{option_name}' option in {section_name} section in '{file_name}' file
	on {server_name} to '0'. If you want to debug Plesk panel and run migration tool
	specify 'skip-log-priority-check' option in [GLOBAL] section of config file of migration tool,
	but migration tool can hang in this case.
""")
CHANGE_MAIL_IPS_IN_BACKUP = single_line_message("""
	Change mail IP addresses in backup
""")
FAILED_TO_CHANGE_MAIL_IPS_IN_BACKUP = single_line_message("""
	Failed to change mail IP addresses in backup
""")
LOG_MAIL_IPS_SET_TO = single_line_message("""
	Subscription '{subscription_name}' mail IPs are set to ({ipv4}, {ipv6}).
""")
CHANGE_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Change web IP addresses in backup for subscription with virtual hosting
""")
FAILED_TO_CHANGE_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Failed to change web IP addresses in backup for subscription with virtual hosting
""")
LOG_WEB_IPS_SET_TO = single_line_message("""
	Subscription '{subscription_name}' web IPs are set to ({ipv4}, {ipv6})
""")
RUN_POST_MIGRATION_CHECKS = single_line_message("""
	Run post migration checks once migration is finished
""")
TEST_ALL_AFTER_TRANSFER_ACTION_DESCRIPTION = single_line_message("""
	Check that the services and transferred domains are working correctly
""")
TEST_ALL_AFTER_TRANSFER_ACTION_FAILURE = single_line_message("""
	Failed to check that the services and transferred domains are working correctly
""")
PRINT_POST_MIGRATION_REPORT_ACTION_DESCRIPTION = single_line_message("""
	Print post migration check report
""")
PRINT_POST_MIGRATION_REPORT_ACTION_FAILURE = single_line_message("""
	Failed to print post migration check report
""")
SKIP_CAPABILITY_CHECKS_OPTION = single_line_message("""
	Do not perform capability checks for target panel
""")
COMMAND_LIST_IP_ADDRESSES = single_line_message("""
	List IP addresses involved into migration process
""")
LIST_IP_ADDRESSES_ACTION_DESCRIPTION = single_line_message("""
	List IP addresses
""")
LIST_IP_ADDRESSES_ACTION_FAILURE = single_line_message("""
	Failed to list IP addresses
""")
IP_ADDRESSES_LIST_SAVED_TO = single_line_message("""
	IP addresses list was saved to '{filename}'
""")
SKIP_IP_MAPPING_CHECKS = single_line_message("""
	Skip IP mapping checks. No issues related to IP address mapping will be reported.
""")
LOG_CHECK_SOURCE_PLESK_API = single_line_message("""
	Check Plesk API connection to {server}
""")
FAILED_TO_CONNECT_BY_PLESK_API = single_line_message("""
	Failed to connect to {server} by Plesk API: {error}
""")
FAILED_TO_CHECK_PLESK_API_CONNECTION = single_line_message("""
	Failed to check Plesk API connection to {server}: {error}
""")
FAILED_TO_CHECK_PLESK_API_INVALID_CREDENTIALS = single_line_message("""
	Unable to login to Plesk API service of {server} due to incorrect login/password specified in config file.
	Set valid credentials in 'panel-username' and 'panel-password' options
	in corresponding section in config file and re-run migration tool.
""")
FAILED_TO_CHECK_PLESK_API_EXPIRED_LICENSE = single_line_message("""
	The license key has expired on {server}.
	To continue with migration, you need to install a valid license key, and then re-run the migration tool.
""")
WINDOWS_FAILED_TO_EXECUTE_REMOTE_COMMAND = single_line_message("""
	Failed to execute remote command on '{server_ip}' server. Check debug log at {debug_log_path} for more details.
""")
WINDOWS_AGENT_INSTALL_INSTRUCTIONS = multi_line_message("""
	Panel Migrator failed to install Transfer Agent to '{source_ip}' server.
	Transfer Agent is required for communication between current server and '{source_ip}' server

	First, check that Windows Administrator's credentials in config.ini are correct for the server

	If they are correct, it is very likely that Samba is disabled on the remote server,
	so automatic installation of agent is not possible.
	To install it manually:
	1) On the {source_ip} server create directory {windows_agent_dir}
	2) Upload {dist} file to {windows_agent_dir} of the {source_ip} server.
	3) Run panel-migrator-transfer-agent-installer.exe on the {source_ip} server.
	4) Open {windows_agent_dir} directory in Windows Explorer.
	5) Run 'start.bat' script there.

	Also, check that there are no firewall rules blocking connections
	to {port} port on {source_ip} from that server.

	For troubleshooting, refer to:
	1) debug.log and info.log files in {windows_agent_dir}
	directory on {source_ip} server.
	2) debug.log and info.log files on the current server.
""")
INVALID_OPTION_VALUE = single_line_message("""
	Invalid value for '{option_name}' option: '{specified_value}'. Please specify one of: {allowed_values}
""")

SECTION_DOES_NOT_EXIST = single_line_message("""
	Section '{section}' specified in '{option}' option does not exist in config
""")
MSSQL_DATABASE_NATIVE_DUMP_NO_PHYSICAL_ACCESS = single_line_message("""
	Unable to migrate MSSQL database '%s' using native MSSQL backups: there is no direct access
	to the server with MSSQL server: {server}. Provide access to it with the help of
	'external-db-servers' option in configuration file and run copy database content again.
""")
CANNOT_GET_OS_TYPE_FOR_EXTERNAL_DB_SERVER = single_line_message("""
	Panel migrator can not get OS type for external database server.
""")
FAILED_RESTORE_SECURITY_POLICY_SOME_TARGET = multi_line_message("""
	Failed to restore security policy on some of target servers: %s
	Restore 'PasswordComplexity' value with help of 'secedit' utility manually
	on all target Windows servers involved into migration.
""")
FAILED_RESTORE_SECURITY_POLICY_TARGET_NODE = multi_line_message("""
	Failed to restore security policy on target node %s: %s
	Restore 'PasswordComplexity' value with help of 'secedit' utility manually on the node
""")
ACTION_CREATE_CONVERTED_BACKUPS = single_line_message("""
	Create converted backups
""")
ACTION_SAVE_CONVERTED_BACKUPS = single_line_message("""
	Save converted backup to file
""")
ACTION_UNPACK_BACKUPS = single_line_message("""
	Unpack backups
""")
FAILED_TO_UNPACK_BACKUPS = single_line_message("""
	Failed to unpack backups
""")
FAILED_TO_PERFORM_ACTION = single_line_message("""
	Failed to perform action: {action_description}
""")
ACTION_COPY_DATABASE_CONTENT = single_line_message("""
	Copy databases
""")
ACTION_COPY_MAIL = single_line_message("""
	Copy mail messages
""")
DEBUG_COPY_WEB_FILES = single_line_message("""
	Copy the following web files: %r
""")
UNSUPPORTED_SOURCE_WEB_PATH_TYPE = single_line_message("""
	Unsupported source web path type
""")
UNSUPPORTED_TARGET_WEB_PATH_TYPE = single_line_message("""
	Unsupported target web path type
""")
ACTION_CONVERT_DNS_RECORDS = single_line_message("""
	Convert DNS records
""")
DEBUG_MAPPING_XML_FILES = single_line_message("""
	Mapping of backup XML files: %r
""")
ACTION_GENERATE_MIGRATION_LIST = single_line_message("""
	Generate migration list file
""")
ACTION_WRITE_MIGRATION_LIST_FILE = single_line_message("""
	Write migration list file
""")
ACTION_RESTORE_AUX_USER_ROLES = single_line_message("""
	Restore auxiliary user roles
""")
ACTION_RESTORE_AUX_USERS = single_line_message("""
	Restore auxiliary users
""")
FAILED_TO_RESTORE_AUX_USERS = single_line_message("""
	Failed to restore auxiliary users
""")
NO_SOURCE_SERVERS_FOR_CALLBACK = single_line_message("""
	There are no source servers found to perform callback
""")
ACTION_CLOSE_SSH_CONNECTIONS = single_line_message("""
	Close SSH connections
""")
ACTION_REMOVE_TEMP_SSH_KEYS = single_line_message("""
	Remove temporary SSH keys
""")
ACTION_UNINSTALL_DUMP_AGENT = single_line_message("""
	Uninstall migration agent files
""")
FAILED_TO_UNINSTALL_DUMP_AGENT = single_line_message("""
	Could not uninstall the migration agent files
""")
LOG_UNICODE_EXCEPTION = single_line_message("""
	Unicode exception:
""")
EXCEPTION_CONTEXT = single_line_message("""
	Context: {context}
""")
EXCEPTION_FAILED_TO_READ_CONFIG_ABSENT_OPTION = single_line_message("""
	Failed to read configuration file: no option '%s' in section '[%s]'. Please fix migration tool
	configuration file ('%s') and run migration tool again.
""")
FAILED_TO_READ_CONFIG_FILE = single_line_message("""
	Failed to read configuration file '%s': %s
""")
AVAILABLE_COMMANDS = single_line_message("""
	Available commands:
""")
HOW_TO_SEE_MORE_COMMANDS = multi_line_message("""
	To see more commands run
	{indent}{command} help --advanced
""")
OPTIONAL_ARGUMENTS = multi_line_message("""
	Optional arguments:
	{indent}--panel-migrator-config PANEL_MIGRATOR_CONFIG_FILE
	{indent}{indent}Path to Panel Migrator configuration file.
	{indent}{indent}See http://docs.python.org/library/logging.config.html#configuration-file-format for configure logging
	{indent}-h, --help Show help message of a command
""")
SCRIPT_TO_EXECUTE_OPTION = single_line_message("""
	Script to execute
""")
MIGRATOR_HELP_MESSAGE = multi_line_message("""
	%%(prog)s [--panel-migrator-config PANEL_MIGRATOR_CONFIG_FILE] COMMAND
	commands:
	%s
	To view detailed help run "%%(prog)s help".
	To view arguments of a command COMMAND run "%%(prog)s COMMAND -h".
""")
CONFIG_FILE_OPTION = single_line_message("""
	migrator configuration file
""")
COMMAND_TRANSFER_ACCOUNTS = single_line_message("""
	Perform accounts transfer
""")
COMMAND_COPY_WEB_CONTENT = single_line_message("""
	Copy web content
""")
COMMAND_COPY_MAIL_CONTENT = single_line_message("""
	Copy mail content
""")
COMMAND_COPY_DB_CONTENT = single_line_message("""
	Copy databases content
""")
COMMAND_SET_DNS_FORWARDING = single_line_message("""
	Set up DNS forwarding
""")
COMMAND_INSTALL_IMAPSYNC = single_line_message("""
	Install imapsync
""")
COMMAND_TRANSFER_APS_PACKAGES = single_line_message("""
	Transfer APS packages
""")
COMMAND_RESTORE_APS_APPLICATIONS = single_line_message("""
	Restore APS applications
""")
COMMAND_TRANSFER_VDIRS = single_line_message("""
	Transfer virtual directories
""")
FAILED_TO_CONNECT_BY_SSH = single_line_message("""
	Failed to connect to the %s at '%s' by SSH as '%s': %s
""")
ERROR_CONNECTING_BY_SSH = single_line_message("""
	Error while connecting to the %s at '%s' by SSH as '%s': %s
""")
DEBUG_OPEN_SSH_CONNECTION = single_line_message("""
	Open SSH connection to the %s
""")
DEBUG_CLOSE_SSH_CONNECTION = single_line_message("""
	Closing SSH connection to %s
""")
CHECKER_FAILED_TO_CONNECT_BY_SSH = single_line_message("""
	Failed to connect to %s by SSH: %s
""")
CHECKER_FAILED_TO_CHECK_SSH_CONNECTION = single_line_message("""
	Failed to check SSH connection to %s: %s
""")
DEBUG_CHECK_API_CONNECTION = single_line_message("""
	Check API connection for %s.
""")
DATABASE_SERVER_DESCRIPTION = single_line_message("""
	%s database server %s:%s
""")
MIGRATOR_SERVER_DESCRIPTION = single_line_message("""
	this server
""")
PHYSICAL_SERVER_DESCRIPTION = single_line_message("""
	server '%s'
""")
SOURCE_SERVER_DESCRIPTION = single_line_message("""
	the source server '%s' (%s)
""")
IMAPSYNC_LOG_EXIT_CODE_AND_OUTPUT = single_line_message("""
	Exit code: %s, command output:\n%s
""")
IMAPSYNC_UNABLE_TO_COPY_MAILBOX = multi_line_message("""
	Unable to copy mail content of mailbox '{email}'. Command exit code: {exit_code}, last 5 lines of output:
	{output}
""")
IMAPSYNC_TARGET_PANEL = single_line_message("""
	target panel
""")
IMAPSYNC_SOURCE_PANEL = single_line_message("""
	source panel
""")
LOG_DEPLOY_PSAMAILBACKUP = single_line_message("""
	Deploy PSAMailBackup to %s
""")
LOG_DEPLOY_PSAMAILRESTORE = single_line_message("""
	Deploy PSAMailRestore to %s
""")
LOG_MERGE_CLIENTS = single_line_message("""
	Merge clients
""")
MODEL_SOURCE_TARGET = single_line_message("""
	Target panel
""")
MODEL_SOURCE_SOURCE = single_line_message("""
	Source panel '%s'
""")
EMAIL_DIFFERENCE = single_line_message("""
	e-mail of a customer on another server: '%s', e-mail of the checked customer: '%s'
""")
EMAIL_DIFFERENCE_DEST = single_line_message("""
	e-mail of a customer on destination panel: '%s', e-mail of the verified customer: '%s'
""")
LOG_CONVERT_PLANS = single_line_message("""
	Convert service plans
""")
LOG_CONVERT_RESELLERS = single_line_message("""
	Convert resellers
""")
LOG_MERGE_RESELLERS = single_line_message("""
	Merge resellers
""")
RESELLER_EXISTS_ON_NUMBER_OF_SERVERS_ERROR = multi_line_message("""
	Reseller with the same username '{login}' but different {difference} exists on a number of servers:
	{info_list}
""")
RESELLER_EXISTS_ON_NUMBER_OF_SERVERS_WARNING = multi_line_message("""
	Reseller with the same username '{login}' exists on a number of servers:
	{info_list}
""")
RESELLER_DESCRIPTION = single_line_message("""
	%s: username '%s', contact (first and last names) '%s', e-mail '%s'
""")
DEBUG_CONVERT_RESELLERS_FROM_SERVER = single_line_message("""
	Convert resellers from '%s'
""")
CLIENT_DESCRIPTION = single_line_message("""
	%s: username '%s', contact (first and last names) '%s', e-mail '%s'
""")
LOG_CONVERT_CLIENTS_FROM_SERVER = single_line_message("""
	Convert clients from '%s'
""")
SOLUTION_FIX_MIGRATION_LIST = single_line_message("""
	Fix migration list.
""")
CLIENT_EXIST_ON_MULTIPLE_SERVERS = multi_line_message("""
	Client with the same username '{login}' but different {difference} exists on a number of servers:
	{info_list}
""")
CLIENT_DIFFERENCE_EMAIL = single_line_message("""
	e-mail
""")
CLIENT_DIFFERENCE_CONTACT = single_line_message("""
	contact (first and last names)
""")
LOG_REPLACED_IP = single_line_message("""
	Replaced IP in %s with %s
""")
UNKNOWN_IP_ADDRESS_TYPE = single_line_message("""
	Unknown IP address type: %s
""")
DEBUG_OPENING_DUMP = single_line_message("""
	Opening XML dump file: %s
""")
ERROR_UNSUPPORTED_DUMP_VERSION = single_line_message("""
	Unsupported backup dump version: %r
""")
ASSERT_BACKUP_UNKNOWN_OBJECT_TYPE = single_line_message("""
	Backup contains a path (%r), associated with an object of unknown type (%s)
""")
DEBUG_PARSE_PLAN = single_line_message("""
	Parse plan '%s'
""")
DEBUG_PARSE_RESELLER_PLAN = single_line_message("""
	Parse reseller plan '%s'
""")
DEBUG_PARSE_INFO_FOR_RESELLER = single_line_message("""
	Parsed info for reseller '%s'
""")
DEBUG_PARSE_INFO_FOR_CLIENT = single_line_message("""
	Parsed info for client '%s'
""")
DEBUG_PARSE_INFO_FOR_DOMAIN = single_line_message("""
	Parsed info for domain '%s'
""")
DEBUG_LOAD_RESELLERS_INFO = single_line_message("""
	Load resellers info
""")
DEBUG_LOAD_CLIENTS_INFO = single_line_message("""
	Load clients info
""")
DEBUG_DOMAINS_INFO = single_line_message("""
	Load domains info
""")
DEBUG_SAVING_BACKUP_INFO_FILE = single_line_message("""
	Saving a backup_info_file: %s
""")
DEBUG_SAVING_INDEXED_BY_PATH = single_line_message("""
	Saving a file indexed_by_path: %s
""")
DEBUG_SAVING_FILE = single_line_message("""
	Saving a file: %s, '%d' bytes
""")
DEBUG_CLOSED_ARCHIVE = single_line_message("""
	Closed an archive file
""")
DEBUG_OPENED_ZIP = single_line_message("""
	Opened a zip file %s
""")
DEBUG_OPENED_TAR = single_line_message("""
	Opened a tar file %s
""")
TARGET_DNS_SERVER_TITLE = single_line_message("""
	target DNS server
""")
SUMMARY_OPERATION_FINISHED_SUCCESSFULLY = single_line_message("""
	Operation finished successfully for %s out of %s %s
""")
NO_OBJECTS_CHECKED = single_line_message("""
	No objects were checked
""")
SUMMARY_TITLE_CHECKED_OBJECT = single_line_message("""
	Checked objects
""")
SUMMARY_TITLE_TOTAL = single_line_message("""
	Total
""")
SUMMARY_TITLE_SUCCESSFUL = single_line_message("""
	Successful
""")
SUMMARY_TITLE_WARNINGS = single_line_message("""
	Warnings
""")
SUMMARY_TITLE_FAILED = single_line_message("""
	Failed
""")
COMMAND_FAILED_WITH_EXIT_CODE = multi_line_message("""
	Command '%s' failed with exit code %d
	stdout: %s
	stderr: %s
""")
INVALID_BOOLEAN_VALUE = single_line_message("""
	Invalid boolean value string '%s', expected 'true' or 'false'
""")
STRING_EXPECTED_STARTS_WITH = single_line_message("""
	String '%s': expected that is starts with '%s'
""")
ASSERT_INVALID_ARGUMENTS_PASSED_TO_CONSTRUCTOR = single_line_message("""
	invalid arguments passed to constructor
""")
XML_TAGS_DO_NOT_MATCH = single_line_message("""
	Tags do not match: %s and %s
""")
XML_ATTRIBUTES_DO_NOT_MATCH = single_line_message("""
	Attributes do not match: %s=%r, %s=%r
""")
XML_ATTRIBUTE_MISSING = single_line_message("""
	x2 has an attribute x1 is missing:
""")
XML_TEXT_DIFFERS = single_line_message("""
	text: %r != %r
""")
XML_TAIL_DIFFERS = single_line_message("""
""")
XML_NUMBER_OF_CHILD_DIFFERS = single_line_message("""
	number of children of "%s" element differs, %i != %i
""")
XML_CHILDREN_DO_NOT_MATCH = single_line_message("""
	children %i do not match: %s
""")
DEBUG_API_REQUEST_TO = multi_line_message("""
	API request to %s:
	%s
""")
DEBUG_API_RESPONSE_FROM = multi_line_message("""
	API response from %s:
	%s
""")
INVALID_IPV4_MASK = single_line_message("""
	Invalid IPv4 mask: %s
""")
DEBUG_EXECUTE_SQL = single_line_message("""
	Execute SQL: '%s'
""")
DEBUG_SQL_ROW_COUNT = single_line_message("""
	SQL row count: '%s'
""")
DEBUG_SQL_QUERY_RESULTS = single_line_message("""
	SQL query result: '%s'
""")
DEBUG_XML_RPC_REQUEST_TO = multi_line_message("""
	XML-RPC request to %s:
	%s
""")
DEBUG_XML_RESPONSE = multi_line_message("""
	XML-RPC response:
	%s
""")
DEBUG_IMPORT_DUMP_REQUEST_XML = single_line_message("""
	Import dump request XML: %s
""")
DEBUG_RESTORE_REQUEST_XML = single_line_message("""
	Restore request XML: %s
""")
DEBUG_DELETE_DUMP_REQUEST_XML = single_line_message("""
	Delete dump request XML: %s
""")
DEBUG_RESTORE_TASK_FINISHED = single_line_message("""
	Restore task finished
""")
DEBUG_RESTORE_TASK_RUNNING = single_line_message("""
	Restore task is running
""")
FEATURE_WILL_BE_DISABLED = single_line_message("""
	This feature will be disabled.
""")
DOT_NET_RUNTIME = single_line_message("""
	.NET runtime
""")
UNABLE_TO_INSTALL_DUMP_AGENT_ANOTHER_INSTALLER = single_line_message("""
	Unable to install dump agent at %s because another software is installing right now. Please try again later.
""")
INSTALL_COMMAND_FAILED_WITH_EXIT_CODE = multi_line_message("""
	Command %s failed with exit code %d:
	stdout: %s
	stderr: %s
""")
DEBUG_UPLOAD_CONVERTER = single_line_message("""
	Uploaded converter to '%s'
""")
DATABASE_COPY_INFO_DESCRIPTION = single_line_message("""
	Database '%s' of subscription '%s': copy from %s to %s
""")
LOG_COPY_DB_CONTENT = single_line_message("""
	Copy database '{db_name}' content from {source} to {target}
""")
LOG_REMOVE_DB_DUMP_FILES = single_line_message("""
	Remove database dump files; source: %s, target: %s
""")
DB_CONNECTION_FAILURE = multi_line_message("""
	Connection to {server} failed.
	Command was: {command}
	Stdout: {stdout}
	Stderr: {stderr}
	Exit code: {exit_code}
""")
MSSQL_DB_CONNECTION_FAILURE = multi_line_message("""
	Connection to {server} failed.
	Command that checks MSSQL connection with Powershell was: {command}
	Stdout: {stdout}
	Stderr: {stderr}
	Exit code: {exit_code}
""")
STARTED_ASYNC_MIGRATION_PROCESS = single_line_message("""
	Started async migration process, pid=%s
""")
MESSAGE_SUMMARY = single_line_message("""
	Summary
""")
PROGRESS_STATUS_TOTAL = single_line_message("""
	Total
""")
PROGRESS_STATUS_FINISHED = single_line_message("""
	Finished
""")
PROGRESS_STATUS_NOT_FINISHED = single_line_message("""
	Not finished
""")
PROGRESS_STATUS_NOT_STARTED = single_line_message("""
	Not Started
""")
PROGRESS_STATUS_IN_PROGRESS = single_line_message("""
	In Progress
""")
PROGRESS_STATUS_ON_HOLD = single_line_message("""
	On Hold
""")
PROGRESS_STATUS_FINISHED_OK = single_line_message("""
	Finished successfully
""")
PROGRESS_STATUS_FINISHED_WARNINGS = single_line_message("""
	Finished with warnings
""")
PROGRESS_STATUS_FAILED = single_line_message("""
	Failed
""")
PROGRESS_ACTION = single_line_message("""
	Action
""")
PROGRESS_STATUS = single_line_message("""
	Status
""")
SUBSCRIPTION_TITLE = single_line_message("""
	Subscription
""")
UNABLE_TO_FIND_RSYNC_BINARY = single_line_message("""
	Unable to find rsync binary on the node %s. Checked the following paths: %s, %s
""")
FAILED_TO_SET_PLAIN_PASSWORDS = single_line_message("""
	Failed to %s. Command: %s, stdout: %s, stderr: %s
""")
FAILED_TO_DETERMINE_PLESK_API_SHOW_PASSWORD = single_line_message("""
	Failed to determine if Plesk API is allowed to show plain passwords. Command: %s, stdout: %s, stderr: %s
""")
TRACE_START = single_line_message("""
	START: %s
""")
TRACE_FINISH = single_line_message("""
	FINISH: %s
""")
TRACE_ABORT = single_line_message("""
	ABORT (by exception): %s
""")
DEBUG_CLIGATE_REQUEST = single_line_message("""
	Request to CLIGate: %s
""")
CLIGATE_COMMAND_FAILED = multi_line_message("""
	u'Command %s failed with exit code %d:
	stdout: %s
	stderr: %s'
""")
DEBUG_PLESK_BASE_DIRECTORY = single_line_message("""
	Plesk base directory is "%s"
""")
DEBUG_PLESK_DATA_DIRECTORY = single_line_message("""
	Plesk data directory is "%s"
""")
DEBUG_PLESK_DUMP_DIRECTORY = single_line_message("""
	Plesk dump directory is "%s"
""")
DEBUG_WINDOWS_VHOST_DIRECTORY = single_line_message("""
	Windows vhost directory: %s
""")
DEBUG_UNIX_VHOST_DIRECTORY = single_line_message("""
	Unix vhost directory: %s
""")
DEBUG_UNIX_VHOST_SYSTEM_DIRECTORY = single_line_message("""
	Unix vhost system directory: %s
""")
DEBUG_UNIX_VHOSTS_DIRECTORY = single_line_message("""
	Virtual hosts directory
""")
DEBUG_MAIL_MESSAGES_DIRECTORY = single_line_message("""
	Mail messages directory
""")
DEBUG_BACKUP_DUMPS_DIRECTORY = single_line_message("""
	Backup dumps directory
""")
DEBUG_UNIX_PRODUCT_ROOT_DIRECTORY = single_line_message("""
	Unix product root directory
""")
PHP_HANLDER_TYPE_DEFAULT_OS = single_line_message("""
	default OS PHP
""")
PHP_HANDLER_TYPE_DEFAULT_PLESK = single_line_message("""
	default Plesk handler
""")
PHP_HANDLER_TYPE_CUSTOM = single_line_message("""
	custom PHP handler (id='%s')
""")
PHP_UNKNOWN_VERSION = single_line_message("""
	of unknown version
""")
PHP_MODE_FASTCGI = single_line_message("""
	running in FastCGI mode
""")
PHP_MODE_CGI = single_line_message("""
	running in CGI mode
""")
PHP_MODE_FPM = single_line_message("""
	running in FPM mode
""")
PHP_MODE_APACHE_MODULE = single_line_message("""
	running as Apache module
""")
PHP_MODE_UNKNOWN = single_line_message("""
	running in unknown mode
""")
PHP_MODE_ID_STRING = single_line_message("""
	running in '%s' mode
""")
PHP_DESCRIPTION = single_line_message("""
	{title} for PHP {version} {mode}
""")
ERROR_FAILED_TO_IMPORT_DUMP = multi_line_message("""
	Failed to import backup XML: errcode must be '0' (no errors) or '116' (backup sign error).
	Output of pmmcli utility:
	%s
""")
DEBUG_IMPORTED_DUMP_ID = single_line_message("""
	Imported backup id is '%s'
""")
ERROR_WHEN_RESTORING_SETTINGS = multi_line_message("""
	An error occurred, when restoring {settings}:
	{text}
""")
PLESK_RESTORE_REPORT_PROBLEM = single_line_message("""
	Plesk restore report problem:
""")
DEBUG_INSTALL_RSYNC = single_line_message("""
	Install rsync on %s
""")
DEBUG_RSYNC_INSTALLED_TO = single_line_message("""
	Rsync on %s was installed into %s
""")
DEBUG_CONFIGURE_SSH_KEY_AUTH = single_line_message("""
	Configure SSH key auth from %s to %s
""")
DEBUG_REMOVE_SSH_KEY_AUTH = single_line_message("""
	Remove SSH key auth from %s to %s
""")
FAILED_TO_REMOVE_SSH_KEY = single_line_message("""
	Failed to remove SSH key from %s to %s: %s
""")
SSH_EXECUTION_ERROR = multi_line_message("""
	Remote command "%s" terminated with code %d
	stdout: %s
	stderr: %s
""")
LOG_SSH_COMMAND_EXECUTION_RESULT = single_line_message("""
	Exit status: %d, stdout: %s, stderr: %s
""")
SSH_UNABLE_TO_CONNECT_TO_HOST = single_line_message("""
	Unable to connect to '{host}' by SSH: {exception}. Retrying in {interval_between_attempts} seconds
""")
WAIT_RECONNECT_BY_SSH = single_line_message("""
	Reconnect by SSH
""")
PROFILE_TOTAL_TIME = single_line_message("""
	Total time: %s
""")
PROFILE_TIME_INSIDE_MIGRATOR = single_line_message("""
	Total time inside migrator: %s
""")
PROFILE_OTHER_TIME = single_line_message("""
	Other
""")
PROFILE_PER_SUBSCRIPTION = single_line_message("""
	%s per subscription
""")
FAILURE_NAME_NOT_UNIQUE = single_line_message("""
	Name is not unique: %s
""")
DEBUG_TRY_TO_CONNECT_TO_TRANSFER_AGENT = single_line_message("""
	Try to connect to panel migrator transfer agent at %s:%s
""")
DEBUG_UPLOAD_AND_INSTALL_AGENT = single_line_message("""
	Upload and install agent
""")
DEBUG_SSL_CLIENT_KEY = single_line_message("""
	SSL client key: %s
""")
DEBUG_SSL_CLIENT_CERT = single_line_message("""
	SSL client certificate: %s
""")
DEBUG_SSL_SERVER_CERT = single_line_message("""
	SSL server certificate: %s
""")
DEBUG_CONNECT_TO_AGENT = single_line_message("""
	Connect to agent at '%s'
""")
DEBUG_RECONNECT_TO_AGENT = single_line_message("""
	Reconnect to agent at '%s'
""")
REMOTE_OPERATION_OK_AFTER_ATTEMPTS = single_line_message("""
	Remote operation executed successfully at {host} after {attempts} attempt(s)
""")
REMOTE_OPERATION_FAILED_RETRY = single_line_message("""
	Failed to run remote operation, retry in {interval_between_attempts} seconds
""")
SLEEP_RETRY_RUNNING_REMOTE_COMMAND = single_line_message("""
	Retry running remote command
""")
DEBUG_EXECUTE_SMB_COMMAND = single_line_message("""
	Execute smbclient command: %s
""")
FAILED_TO_UPLOAD_FILE_SMB = single_line_message("""
	Failed to upload file {local} to \\\\{ip}\\{share}\\{remote}, stdout is {stdout}, stderr is {stderr}
""")
DEBUG_DOWNLOADING_FILE = single_line_message("""
	Downloading file '%s' to '%s'
""")
FAILED_TO_DOWNLOAD_FILE_SMB = single_line_message("""
	Failed to download file \\\\{ip}\\{share}\\{remote} to {local}, stdout is {stdout}, stderr is {stderr}
""")
LOG_DOWNLOAD_DIRECTORY = single_line_message("""
	Downloading directory '%s' to '%s'
""")
FILE_EXISTS_INVALID_COMMAND_OUTPUT = multi_line_message("""
	Invalid output for command {command} (expected 'true' or 'false'):
	{output}
""")
LOG_PROCESS_SUBSCRIPTION = single_line_message("""
	Process subscription '%s' (#%s out of %s)
""")
DEBUG_ENTER_COMMON_BLOCK = single_line_message("""
	Enter common action block
""")
DEBUG_EXIT_COMMON_BLOCK = single_line_message("""
	Exit common action block
""")
LOG_START_SUBSCRIPTION = single_line_message("""
	START Processing subscription '%s' (#%s out of %s)
""")
PROFILE_SUBSCRIPTION_TITLE = single_line_message("""
	Subscription '%s'
""")
DEBUG_EXECUTE_SHUTDOWN_ACTION = single_line_message("""
	Execute shutdown action '%s'
""")
ACTION_COPY_WEB_FILES = single_line_message("""
	Copy web files
""")
ACTION_SYNC_WEB_CONTENT_ASSESTS = single_line_message("""
	Sync web content assets
""")
ACTION_CHECK_MIGRATOR_UPDATES = single_line_message("""
	Check migrator updates
""")
ACTION_CHECK_CONNECTIONS = single_line_message("""
	Check connections
""")
ACTION_CHECK_SOURCE_CONNECTIONS = single_line_message("""
	Check source connections
""")
ACTION_CHECK_TARGET_CONNECTIONS = single_line_message("""
	Check target connections
""")
ACTION_READ_MIGRATION_LIST = single_line_message("""
	Read migration list
""")
ACTION_VERIFY_HOSTING = single_line_message("""
	Verify hosting
""")
ACTION_PRINT_PRE_MIGRATION_ERROR = single_line_message("""
	Print pre-migration report
""")
ACTION_RESTART_IIS_FOR_IDN_DOMAINS = single_line_message("""
	Restart IIS for IDN domains
""")
ACTION_PRINT_REPORT = single_line_message("""
	Print report
""")
ACTIONS_TEST_USERS = single_line_message("""
	Check that users are transferred correctly (FTP/SSH/RDP access)
""")
LOCAL_COMMAND_FAILED = multi_line_message("""
	Command '%s' executed locally failed with exit code %d.
	stdout: %s
	stderr:%s
""")
DEBUG_CALL_LOCAL_COMMAND = single_line_message("""
	Call local command: %s
""")
DEBUG_COMMAND_STDOUT = single_line_message("""
	Command stdout: %s
""")
DEBUG_COMMAND_STDERR = single_line_message("""
	Command stderr: %s
""")
DEBUG_COMMAND_EXIT_CODE = single_line_message("""
	Command exit code: %s
""")
FAILED_TO_EXECUTE_LOCAL_COMMAND = single_line_message("""
	Failed to execute local command '%s': %s
""")
IP_MAPPING_INVALID_ARGUMENTS_COUNT = single_line_message("""
	Line #%s: invalid number of arguments found on line. Expected: <source-ip> <target-ip>.
	For example: 10.52.1.17 10.52.12.32
""")
FAILED_TO_READ_IP_MAPPING = multi_line_message("""
	Failed to read IP mapping:
	%s
""")
CUSTOMER_ASSIGNED_TO_ANOTHER_RESELLER = single_line_message("""
	Line %s: customer '%s' was already assigned to another reseller '%s'
""")
SUBSCRIPTION_MUST_BE_ASSIGNED_TO_CUSTOMER = single_line_message("""
	Line %s: subscription '%s' must be assigned to a customer
""")
SUBSCRIPTION_IS_ALREADY_DEFINED = single_line_message("""
	Line %s: subscription '%s' is already defined
""")
INVALID_SSH_AUTH_VALUE = single_line_message("""
	Invalid value '%s' of 'ssh-auth-type' parameter in '[%s]' section of configuration file. Allowed values: %s.
""")
RUNNER_COMMAND_FAILED_WITH_EXIT_CODE = multi_line_message("""
	Command %s with arguments %r failed with exit code %d
	stdout: %s
	stderr: %s'
""")
COMMAND_RUN_ATTEMPTS = single_line_message("""
	Attempting to run "%s"
""")
COMMAND_EXECUTED_OK_AFTER_ATTEMPTS = single_line_message("""
	Command "%s" was executed successfully after %d attempt(s).
""")
SLEEP_RETRY_EXECUTING_COMMAND = single_line_message("""
	Retry executing command
""")
UNABLE_DETECT_WINDOWS_CODEPAGE = multi_line_message("""
	Unable to determine Windows CMD code page:
	stdout: %s
	stderr: %s
""")
DEBUG_DETECTED_CODEPAGE = single_line_message("""
	Detected CMD codepage: %s
""")
EXECUTE_COMMAND_ON_LOCAL_SERVER = single_line_message("""
	Execute a command on local server: '%s'
""")
LOCAL_SERVER_TITLE = single_line_message("""
	Local server
""")
DEBUG_COPY_LOCAL_FILE = single_line_message("""
	Copy local file '%s' to '%s'
""")
DEBUG_EXECUTE_SSH_REMOTE_COMMAND = single_line_message("""
	Execute remote command: ssh %s "%s"
""")
DEBUG_EXECUTE_COMMAND_AT = single_line_message("""
	Execute command at '%s': %s
""")
DEBUG_DOWNLOAD_FILE = single_line_message("""
	Download file '%s' to '%s' from '%s
""")
DEBUG_UPLOAD_FILE = single_line_message("""
	Upload file '%s' to '%s' at '%s'
""")
DEBUG_UPLOAD_FILE_CONTENTS = single_line_message("""
	Upload file contents to '%s' at '%s
""")
PROFILE_UPLOAD_FILE = single_line_message("""
	Upload file '%s'
""")
DEBUG_DOWNLOAD_FILE_CONTENTS = single_line_message("""
	Download contents of '%s' file from '%s'
""")
PROFILE_DOWNLOAD_FILE = single_line_message("""
	Download file '%s'
""")
DEBUG_MOVE_FILE = single_line_message("""
	Move '%s' to '%s' on '%s'
""")
PROFILE_MOVE_FILE = single_line_message("""
	Move '%s' to '%s'
""")
DEBUG_LIST_FILES = single_line_message("""
	List '%s' on '%s'
""")
PROFILE_LIST_FILES = single_line_message("""
	List '%s'
""")
DEBUG_REMOVE_FILE = single_line_message("""
	Remove file '%s' from '%s'
""")
PROFILE_REMOVE_FILE = single_line_message("""
	Remove file '%s'
""")
DEBUG_CREATE_DIRECTORY = single_line_message("""
	Create directory '%s' at '%s'
""")
PROFILE_CREATE_DIRECTORY = single_line_message("""
	Create directory '%s'
""")
FAILED_TO_EXECUTE_COMMAND = single_line_message("""
	Failed to execute command '%s'. Stdout: %s. Stderr: %s.
""")
ERRORS_WHEN_EXECUTING_COMMAND = multi_line_message("""
	Errors while executing command:
	%s
""")
EXECUTED_AT = single_line_message("""
	executed at %s
""")
FAILED_TO_PERFORM_ACTION_ON_SUBSCRIPTION = single_line_message("""
	Failed to perform an action on subscription '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_PLAN = single_line_message("""
	Failed to perform an action on plan '%s' owned by %s: %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_RESELLER = single_line_message("""
	Failed to perform an action on reseller '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_CLIENT = single_line_message("""
	Failed to perform an action on client '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_AUX_USER = single_line_message("""
	Failed to perform an action on auxiliary user '%s' of client '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_AUX_USER_ROLE = single_line_message("""
	Failed to perform an action on auxiliary user role '%s' of client '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_SUBSCRIPTION_ERROR_STRING = single_line_message("""
	Failed to perform an action on subscription '%s': %s
""")
FAILED_TO_PERFORM_ACTION_ON_CLIENT_ERROR_STRING = single_line_message("""
	Failed to perform an action on client '%s': %s
""")
FAILED_TO_PERFORM_ACTION_ON_RESELLER_ERROR_STRING = single_line_message("""
	Failed to perform an action on reseller '%s': %s
""")
ATTEMPT_FAILED_WITH_ERROR = multi_line_message("""
	Attempt #%s failed with the following error:
	%s
""")
MIGRATOR_TRIED_TO_PERFORM_ACTION_IN_ATTEMPTS = single_line_message("""
	Migration tools tried to perform operation in %s attempts: %s
""")
ASSERT_NO_ATTEMPS = single_line_message("""
	No attempts were performed to perform operation
""")
RSYNC_INTERACTION_OK_AFTER_ATTEMPTS = single_line_message("""
	Interaction via rsync with server at {source_ip} ad client at {target_ip}
	was finished successfully after {attempts} attempt(s).
""")
RSYNC_INTERACTION_FAILED = single_line_message("""
	Interaction via rsync with server at {source_ip} and client at {target_ip} was failed
""")
RSYNC_RETRY_IN = single_line_message("""
	retry in {interval} seconds
""")
SLEEP_RETRY_RSYNC = single_line_message("""
	Retry interaction via rsync
""")
MIGRATOR_START = single_line_message("""
	START: %s %s
""")
LOG_INITIALIZE_MIGRATOR = single_line_message("""
	Initialize migrator
""")
REPORT_POTENTIAL_ISSUES = single_line_message("""
	Detected potential issues
""")
REPORT_DNS_FORWARDING_ISSUES = single_line_message("""
	DNS forwarding issues
""")
LOG_LOAD_CONFIGURATION = single_line_message("""
	Load configuration
""")
DEBUG_TARGET_PANEL = single_line_message("""
	Target panel: %s
""")
DEBUG_SOURCE_PANEL = single_line_message("""
	Source panel: %s
""")
INVALID_VALUE_TRANSFER_DOMAIN_TO_SUBSCRIPTION = single_line_message("""
	Invalid value '%s' is specified for 'transfer-domains-to-subscription' setting in the GLOBAL
	section of tool's configuration file, should be one of: %s (case-insensitive).
""")
LOG_CHECK_MIGRATOR_UPDATES = single_line_message("""
	Check panel migrator updates
""")
LOG_NO_UPDATES = single_line_message("""
	No updates available
""")
FAILED_TO_CHECK_MIGRATOR_UPDATES = multi_line_message("""
	Failed to check migration tools updates
	Please perform check updates manually:
	wget http://autoinstall.plesk.com/panel-migrator/installer.sh
	chmod +x ./installer.sh
	./installer.sh --check-updates'
""")
FAILED_TO_UPDATE_MIGRATOR = single_line_message("""
	Failed to upgrade migration tools
	Please perform upgrade manually:
	wget http://autoinstall.plesk.com/panel-migrator/installer.sh
	chmod +x ./installer.sh
	./installer.sh --upgrade'
""")
REPORT_SERVICE_ISSUES = single_line_message("""
	Services' Issues
""")
REPORT_DETECTED_PROBLEMS = single_line_message("""
	Detected problems
""")
FAILED_TO_READ_MIGRATION_LIST = single_line_message("""
	Failed to read migration list file '%s': %s
""")
DEBUG_ENABLE_SECURITY_POLICY = single_line_message("""
	Enable security policy on '%s'
""")
DEBUG_DISABLE_SECURITY_POLICY = single_line_message("""
	Disable security policy on '%s'
""")
LOG_CONVERT_HOSTING_SETTINGS = single_line_message("""
	Convert hosting settings
""")
SUSPEND_TARGET_SUBSCRIPTION = single_line_message("""
	Suspend target subscription '%s'
""")
FAILED_TO_SUSPEND_CUSTOMER = single_line_message("""
	Failed to suspend customer
""")
DEBUG_SUSPEND_CUSTOMER = single_line_message("""
	Suspend customer
""")
FAILED_TO_SUSPEND_RESELLER = single_line_message("""
	Failed to suspend reseller
""")
REPORT_WEBSITE_ISSUES = single_line_message("""
	Transferred Web Sites' Issues
""")
REPORT_USER_ISSUES = single_line_message("""
	Transferred Users Issues
""")
FAILED_TO_SAVE_EXTERNAL_REPORT = single_line_message("""
	Unable to save external report data into file '%s': %s
""")
FAILED_OBJECTS_SUBSCRIPTIONS = single_line_message("""
	subscription(s)
""")
FAILED_OBJECTS_RESELLERS = single_line_message("""
	reseller(s)
""")
FAILED_OBJECTS_CLIENTS = single_line_message("""
	client(s)
""")
FAILED_OBJECTS_PLANS = single_line_message("""
	plan(s)
""")
FAILED_OBJECTS_AUX_USERS = single_line_message("""
	auxiliary user(s)
""")
FAILED_OBJECTS_AUX_USER_ROLES = single_line_message("""
	auxiliary user role(s)
""")
OWNED_BY_ADMIN = single_line_message("""
	'%s' owned by admin
""")
OWNED_BY_RESELLER = single_line_message("""
	'%s' owned by reseller '%s'
""")
OWNED_BY_CUSTOMER = single_line_message("""
	'%s' owned by customer '%s'
""")
FAILED_TO_PERFORM_OPERATION = single_line_message("""
	Failed to perform operation on %s %s: %s
""")
EXCEPTION_MESSAGE = single_line_message("""
	Exception message: %s
""")
SUBSCRIPTIONS_FAILED_TO_MIGRATE = multi_line_message("""
	%s of %s subscription(s) failed to migrate.
	All of them are listed in "%s".
	To repeat migration for these subscriptions only, run migrator in the following way:
	# %s %s config.ini --migration-list-file %s
""")
REPORT_MIGRATION_STATUS = single_line_message("""
	Detailed Migration Status
""")
FAILED_TO_DETECT_DB_LIST = single_line_message("""
	Failed to detect list of databases on %s: %s
""")
DB_NOT_COPIED_NO_DB_SERVER = single_line_message("""
	Database '{db.name}' from {db.dbtype} server at {db.host}:{db.port} will not be copied
	as no {db.dbtype} DB server is assigned to subscription '{subscr}'
""")
DEBUG_DB_ASSIMILATION = single_line_message("""
	Database '{db.name}' from {db.dbtype} server at {db.host}:{db.port} remains on the same server,
	content will not be copied
""")
HOW_TO_SKIP_DISK_SPACE_CHECK = single_line_message("""
	To skip disk space requirements, check for %s pass --skip-main-node-disk-space-checks command line option
""")
ERROR_AND_EXCEPTION_MESSAGE = single_line_message("""
	%s Exception message: %s
""")
FAILED_TO_CHECK_CONNECTIONS = single_line_message("""
	Failed to check connections
""")
REPORT_INFRASTRUCTURE = single_line_message("""
	Infrastructure
""")
LOG_CHECK_CONNECTION_REQUIREMENTS = single_line_message("""
	Check connection requirements
""")
LOG_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
	Check disk space requirements
""")
REPORT_DISK_SPACE_REQUIREMENTS = single_line_message("""
	Disk space requirements
""")
FAILED_TO_SET_DBDUMP_DIR_PERMISSIONS = single_line_message("""
	Failed to set permissions for directory with MSSQL database dumps: {reason}.
	Default (inherited) permissions will be used.
	If there are some problems when copying database content, ensure that {server} is provided with
	full access to {directory}
""")
FAILED_TO_FIND_ELEMENT_IN_LIST = single_line_message("""
	Failed to find element in list
""")
DEBUG_FILES_TO_COPY = single_line_message("""
	Files to copy for subscription '{subscription_name}': {files}
""")
DEBUG_START_COPY_FILES = single_line_message("""
	Start copy files for subscription '{subscription_name}': {files_item}
""")