#!/bin/bash -e
### Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.

ln -sf /usr/local/psa/var/modules/panel-migrator/sessions /var/log/plesk/PMM

packages="plesk-py27 plesk-py27-dnspython plesk-py27-ecdsa plesk-py27-paramiko plesk-py27-psycopg2 plesk-py27-pyasn1 plesk-py27-pycrypto plesk-py27-pysmb plesk-py27-pyyaml"

export DEBIAN_FRONTEND=noninteractive

if [ "$PLESK_DEBUG" != "1" ] ; then
  yum_quiet="-q"
  apt_quiet="-qq"
fi

remove_debian()
{
	rm -f /etc/apt/sources.list.d/plesk-migrator.list
	[ -n "$(which apt-get)" ] && apt-get remove -y $apt_quiet $packages
}

remove_centos()
{
  rm -f /etc/yum.repos.d/plesk-migrator.repo
  [ -n "$(which yum)" ] && yum remove -y $yum_quiet $packages
}

if [ "$1" = "remove" ] ; then
  psa_version=( $(cat /usr/local/psa/version) )
  case "${psa_version[1]}${psa_version[2]}" in
      Debian*|Ubuntu*) remove_debian ;;
      CentOS*|RedHatel*) remove_centos ;;
      *) not_supported "${psa_version[1]} ${psa_version[2]}" ;;
  esac
  exit 0
fi

ai_url="http://autoinstall.plesk.com"
pmm_version="PMM_0.1.10"

not_supported()
{
  echo "Sorry, your operating system $1 is not supported"
  exit 1
}

bootstrap_debian()
{
  local os_name="$1"
  local os_version="$2"
  local arch_spec=""
  ! expr match "$(uname -m)" '.*64' > /dev/null || arch_spec="[arch=amd64]"
  echo "Bootstrapping dependencies for $os_name $os_version..."
  echo "deb $arch_spec $ai_url/$os_name/$pmm_version $os_version all" > /etc/apt/sources.list.d/plesk-migrator.list
  apt-get update $apt_quiet -o Dir::Etc::sourcelist="sources.list.d/plesk-migrator.list" \
                    -o Dir::Etc::sourceparts="-" \
                    -o APT::Get::List-Cleanup="0"
  apt-get install -y $apt_quiet -o APT::Install-Suggests=false -o APT::Install-Recommends=false $packages
}

bootstrap_centos()
{
  local os_version="$1"
  local os_arch="$(uname -m)"
  expr match "$os_arch" '.*64' > /dev/null || os_arch='i386'
  echo "Bootstrapping dependencies for centos $os_version $os_arch..."
  cat > /etc/yum.repos.d/plesk-migrator.repo <<EOF
[plesk-migrator]
name=Plesk packages for migrator
baseurl=$ai_url/$pmm_version/dist-rpm-CentOS-$os_version-$os_arch
enabled=1
gpgcheck=1
gpgkey=$ai_url/plesk.gpg

[plesk-migrator-tp]
name=Plesk 3d-party packages for migrator
baseurl=$ai_url/$pmm_version/thirdparty-rpm-CentOS-$os_version-$os_arch
enabled=1
gpgcheck=0
EOF
  yum install -y $yum_quiet $packages
}

psa_version=( $(cat /usr/local/psa/version) )
case "${psa_version[1]}${psa_version[2]}" in
	Debian6*) bootstrap_debian "debian" "squeeze" ;;
	Debian7*) bootstrap_debian "debian" "wheezy" ;;
	Debian8*) bootstrap_debian "debian" "jessie" ;;
	Ubuntu12.04) bootstrap_debian "ubuntu" "precise" ;;
	Ubuntu14.04) bootstrap_debian "ubuntu" "trusty" ;;
	Ubuntu16.04) bootstrap_debian "ubuntu" "xenial" ;;
	CentOS6*|RedHatel6*) bootstrap_centos "6" ;;
	CentOS7*|RedHatel7*) bootstrap_centos "7" ;;
	*) not_supported "${psa_version[1]} ${psa_version[2]}" ;;
esac

echo "Done"