# coding=utf-8
from parallels.core.utils.common_constants import PLESK_PANEL_DEFAULT_PORT
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

OPERATIONS_ARE_NOT_SUPPORTED_BY_CLIENT = single_line_message("""
    Operations %s are not supported by the client using protocol version %s
""")
ONLY_SERVER_BACKUP_TASK_INFO_IS_SUPPORTED = single_line_message("""
    Only server backup task info is supported.
""")
HOW_TO_REPRODUCE_FAILED_REQUEST = multi_line_message("""
    Unexpected Plesk API Error: {error_message}
    If you referring to a technical support representative,
    please attach a stack trace with the error message from Plesk Migrator's logs.
    To execute a Plesk API request manually:
    1. Open debug.log and copy the Plesk API request from the end of the file.
    2. Execute it with the help of the command
        curl https://<plesk_api_server_ip>:<plesk_api_server_port>/enterprise/control/agent.php -s -d "<quoted_packet>"
            -H "HTTP_AUTH_LOGIN: admin" -H "HTTP_AUTH_PASSWD: <password>"
            -H "Content-Type: text/xml" --insecure
    Replace
        <plesk_api_server_ip> with the required IP address
        <plesk_api_server_port> with the required Plesk Panel port (by default %s)
        <quoted_packet> with the Plesk API request from debug.log
        <password> with the appropriate password.
""" % PLESK_PANEL_DEFAULT_PORT)

HOW_TO_REPRODUCE_FAILED_REQUEST_WITH_DETAILS = multi_line_message("""
    Unexpected Plesk API Error: {error_message}

    Request:
    ===============================================================================
    {request_str}
    ===============================================================================
    Response:
    ===============================================================================
    {response_str}
    ===============================================================================

    To execute a Plesk API request manually:
    1. Copy the Plesk API request XML from above, save to file "request.xml".
    2. Execute it with the help of the command (replace password with an actual Plesk password)
        curl {url} -s -d @request.xml
            -H "HTTP_AUTH_LOGIN: admin" -H "HTTP_AUTH_PASSWD: <password>"
            -H "Content-Type: text/xml" --insecure
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
