from parallels.core.utils.paths import web_paths
from parallels.core.utils.paths.copy_web_content import CopyWebContentItem
from parallels.core.utils.paths.web_files import BaseWebFiles
from parallels.core.utils.paths.web_paths import WebHostingPath


class WebWebFiles(BaseWebFiles):
    """List web files and directories to be copied from custom panel"""

    def need_to_copy_files(self, global_context, subscription):
        """Check whether we need to copy files of that subscription

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        :rtype: bool
        """
        return True

    def list_files_to_copy(self, global_context, subscription):
        """Make a list of source server directories and files to be transferred.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        :rtype: list[parallels.core.utils.paths.copy_web_content.CopyWebContentItem]
        """
        return [
            CopyWebContentItem(
                source_path=FtpPath('/'),
                target_path=web_paths.WebspaceRoot(subscription.converted_dump),
                fix_application_paths=False
            )
        ]


class FtpPath(WebHostingPath):
    """Path to web hosting related file or directory, relative to FTP root directory on the server
    """

    def __init__(self, ftp_path):
        """
        :type ftp_path: str
        """
        self._ftp_path = ftp_path

    @property
    def ftp_path(self):
        """
        :rtype: str | unicode
        """
        return self._ftp_path

    def __eq__(self, other):
        return (
            isinstance(other, FtpPath) and
            self.ftp_path == other.ftp_path
        )

    def __repr__(self):
        return '%s(%r)' % (self.__class__.__name__, self.ftp_path)
