from contextlib import contextmanager

from parallels.core.connections.source import Source
from parallels.core.connections.server import Server
from parallels.core.runners.web.runner import WebAgentRunner
from parallels.core.utils.common import cached
from parallels.core.utils.windows_mysql_client_deploy import deploy_mysqldump
from parallels.plesk.source.web.session_dir import WebSessionDir


class WebSource(Source, Server):
    """Source for migration from web
    """

    def __init__(self, source_id, config, migrator_server):
        Source.__init__(self, source_id, config, migrator_server)
        Server.__init__(self)

    @property
    def config(self):
        """Return web source config

        :rtype: parallels.plesk.source.web.connections.WebSourceConfig
        """
        return super(WebSource, self).config

    @contextmanager
    def runner(self):
        """Get runner object to execute commands on the source server"""
        yield self._get_runner()

    @cached
    def get_path_to_mysqldump(self):
        if self.is_windows():
            return deploy_mysqldump(self)
        else:
            return 'mysqldump'

    def is_windows(self):
        with self.runner() as runner:
            return runner.is_windows

    def _create_session_dir(self):
        return WebSessionDir(self.runner, self.config.session_dir)

    @cached
    def _get_runner(self):
        return WebAgentRunner(self.config.ftp_host, self.config)
