import posixpath
import ntpath

from parallels.core.utils.session_dir import SessionDir


class WebSessionDir(SessionDir):
    """
    Migration session storage directory on web server
    """

    def _join_paths(self, *paths):
        with self._runner_cm() as runner:
            if runner.is_windows:
                return ntpath.join(*paths)
            else:
                return posixpath.join(*paths)

    def _set_permissions(self, runner):
        # TODO: protect session dir using basic authorization
        pass
