import logging

from parallels.core.migrator import Migrator as CommonMigrator
from parallels.plesk.source.web.connections import WebConnections
from parallels.plesk.source.web.global_context import WebGlobalMigrationContext
from parallels.plesk.source.web.session_files import WebSessionFiles
from parallels.plesk.source.web.web_files import WebWebFiles

logger = logging.getLogger(__name__)


class Migrator(CommonMigrator):
    logger = logging.getLogger(__name__)

    @property
    def web_files(self):
        """Object to list files to be transferred from source to target

        :rtype: parallels.plesk.source.web.web_files.WebWebFiles
        """
        return WebWebFiles()

    def _load_connections_configuration(self, global_context, target_panel_type):
        return WebConnections(global_context, self._get_target_panel_by_name(target_panel_type))

    def _create_global_context(self):
        """Create global context object

        :rtype: parallels.plesk.source.web.global_context.WebGlobalMigrationContext
        """
        return WebGlobalMigrationContext()

    def _create_session_files(self):
        """Create session files object

        :rtype: parallels.plesk.source.web.session_files.WebSessionFiles
        """
        return WebSessionFiles(self.global_context.conn, self._get_migrator_server())
