from parallels.core.migrator_config import SourceConfig, FtpServerConfig


class WebSourceConfig(SourceConfig, FtpServerConfig):
    def __init__(
        self, source_id, config_section, ftp_host, ftp_username, ftp_password, session_dir, document_root, base_url
    ):
        SourceConfig.__init__(self, source_id, config_section)
        FtpServerConfig.__init__(self, source_id, ftp_host, ftp_username, ftp_password, session_dir)
        self._document_root = document_root
        self._base_url = base_url

    @property
    def document_root(self):
        return self._document_root

    @property
    def base_url(self):
        return self._base_url
