import posixpath

from parallels.plesk.source.legacy.global_context import LegacyGlobalMigrationContext
from parallels.plesk.source.ppcpl.pmm_agent import PPCPLPmmMigrationAgent
from parallels.core.utils import plesk_utils
from parallels.plesk.source.ppcpl import settings
import parallels.plesk.source.ppcpl


class PPCPLGlobalMigrationContext(LegacyGlobalMigrationContext):
    def __init__(self):
        super(PPCPLGlobalMigrationContext, self).__init__()
        self.source_has_dns_forwarding = False

    @staticmethod
    def get_domain_filesystem_root(domain):
        """Get full path to domain's filesystem root on PPCPL server,
        this is the main location of all domain files.

        :type domain: str
        :rtype: str
        """
        return '/home/virtual/%s' % domain

    def _deploy_dump_agent(self):
        migrator_pmm_dir = posixpath.join(
            plesk_utils.get_migrator_root_path(parallels.plesk.source.ppcpl),
            'extras', 'pmm'
        )
        return PPCPLPmmMigrationAgent(self, self.conn.ppcpl, migrator_pmm_dir, self.conn.source_settings)

    @property
    def settings(self):
        return settings