from parallels.core.utils.common import cached
from parallels.plesk.source.plesk.shallow_dump.model.base.client import Client
from parallels.plesk.source.plesk.shallow_dump.model.base.reseller import Reseller
from parallels.plesk.source.plesk.shallow_dump.model.plesk8 import Plesk8And9CommonShallowDumpModel


class Plesk9ShallowDumpModel(Plesk8And9CommonShallowDumpModel):
    """Shallow dump object for source Plesk 9.x panel"""
    @property
    @cached
    def clients(self):
        return [
            Client(client_id=data['id'], login=data['login'], contact_name=data['pname'], owner_id=data['parent_id'])
            for data in self._dump_agent.execute_sql(
                "SELECT id, parent_id, login, pname FROM clients WHERE type = 'client'"
            )
        ]

    @property
    def resellers(self):
        return [
            Reseller(reseller_id=data['id'], login=data['login'], contact_name=data['pname'], subscription_id=None)
            for data in self._dump_agent.execute_sql(
                "SELECT id, login, pname FROM clients WHERE type = 'reseller'"
            )
        ]

    @property
    @cached
    def admin_ids(self):
        query_results = self._dump_agent.execute_sql("""
            SELECT id FROM clients WHERE type = 'admin'
        """)
        return {data['id'] for data in query_results}