from parallels.plesk.source.plesk import messages
from parallels.core import MigrationError
from parallels.plesk.source.plesk.shallow_dump.model.plesk10 import Plesk10ShallowDumpModel
from parallels.plesk.source.plesk.shallow_dump.model.plesk8 import Plesk8ShallowDumpModel
from parallels.plesk.source.plesk.shallow_dump.model.plesk9 import Plesk9ShallowDumpModel


def create_plesk_shallow_model(dump_agent, plesk_version):
    """Create corresponding shallow dump model by Plesk version

    :type dump_agent: parallels.core.utils.pmm.agent.PmmMigrationAgentBase
    :type plesk_version: tuple[str | unicode]
    :rtype: parallels.plesk.source.plesk.shallow_dump.model.base.model.ShallowDumpModel
    """
    major_version = int(plesk_version[0])
    if major_version == 8:
        return Plesk8ShallowDumpModel(dump_agent)
    elif major_version == 9:
        return Plesk9ShallowDumpModel(dump_agent)
    elif major_version >= 10:
        return Plesk10ShallowDumpModel(dump_agent)
    else:
        raise MigrationError(
            messages.PLESK_VERSION_NOT_SUPPORTED_BY_SHALLOW_DUMP.format(plesk_version='.'.join(plesk_version))
        )
