from parallels.core.utils.entity import Entity
from parallels.plesk.source.plesk.shallow_dump.model.base.constants import PLESK_ADMIN_ID


class Client(Entity):
    """Shallow information about client"""

    def __init__(self, client_id, login, contact_name, owner_id=PLESK_ADMIN_ID):
        self._client_id = client_id
        self._login = login
        self._contact_name = contact_name
        self._owner_id = owner_id

    @property
    def client_id(self):
        """Client's ID

        :rtype: str | unicode
        """
        return self._client_id

    @property
    def login(self):
        """Client's login

        :rtype: str | unicode
        """
        return self._login

    @property
    def contact_name(self):
        """Client's contact name (usually first name and last name)

        :rtype: str | unicode
        """
        return self._contact_name

    @property
    def owner_id(self):
        """Client's owner ID (reseller ID, or administrator's ID)

        :rtype: str | unicode
        """
        return self._owner_id
