from parallels.core.session_files import CommonSessionFiles


class PleskSessionFiles(CommonSessionFiles):
    def get_extension_traces_file(self, extension_name, data_type, target_entity_id=None):
        if target_entity_id is None:
            return self.get_file(u'extensions', u'%s.%s.json' % (extension_name, data_type))
        else:
            return self.get_file(u'extensions', u'%s.%s.%s.json' % (extension_name, data_type, target_entity_id))

    def get_path_to_applications_filename(self, server_id):
        return self.get_file_path(u"plesk.applications.%s.yaml" % server_id)

    def get_converted_vdir_xml(self, site_name):
        return self.get_file_path(u"vdir-converted.%s.xml" % site_name)

    def get_raw_vdir_xml(self, site_name):
        return self.get_file_path(u"vdir-raw.%s.xml" % site_name)

    def get_dns_timings_file(self):
        return self.get_file_path(u'dns_timings.yaml')

    def get_path_to_capability_dump(self, server_id):
        return self.get_file_path(u'capability_dump.%s.xml' % server_id)

    def get_path_to_capability_dump_selection(self, server_id):
        return self.get_file_path(u'capability_dump.%s.selection.yaml' % server_id)

    def get_path_to_capability_check_report(self, server_id):
        return self.get_file_path(u'capability_check_report.%s.xml' % server_id)
