# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

ACTION_CHECK_SOURCE_ACCOUNT = single_line_message("""
    Check that specified source servers accounts are built-in Windows administrators
""")
ACTION_CHECK_SOURCE_ACCOUNT_FAILED = single_line_message("""
    Failed to check that specified source servers accounts are built-in Windows administrators
""")
ACTION_CHECK_SOURCE_ACCOUNT_UNABLE = single_line_message("""
    Unable to check that RPC agent on source server '{source_ip}' is running
    under built-in administrator account: {exception}
""")
ACTION_CHECK_SOURCE_ACCOUNT_BUILT_IN_MANUAL = single_line_message("""
    RPC agent on source server '{source_ip}' is running under built-in administrator account
""")
ACTION_CHECK_SOURCE_ACCOUNT_BUILT_IN_AUTO = single_line_message("""
    Interaction with source server '{source_ip}' is going on via built-in administrator account
""")
ACTION_CHECK_SOURCE_ACCOUNT_NOT_BUILT_IN_MANUAL = single_line_message("""
    RPC agent on source server '{source_ip}' is running not under built-in administrator account.
""")
ACTION_CHECK_SOURCE_ACCOUNT_NOT_BUILT_IN_AUTO = multi_line_message("""
    Interaction with source server '{source_ip}' is going on not via built-in administrator account.

    Check username and password specified in configuration file. It should be credentials of
    the built-in administrator account on the source server '{source_ip}'.
""")

ACTION_CHECK_EXTENSIONS = single_line_message("""
    Check ability to migrate data of Plesk extensions
""")
ACTION_CHECK_EXTENSIONS_FAILED = single_line_message("""
    Failed to check ability to migrate data of Plesk extensions
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_MISSED = single_line_message("""
    Plesk extension '{extension_name}' not installed on target Plesk, data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_MISSED_SOLUTION = single_line_message("""
    Install Plesk extension '{extension_name}' on target Plesk
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_SERVER = single_line_message("""
    Plesk extension '{extension_name}' on target Plesk is not able to restore server-wide data,
    such data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_RESELLER = single_line_message("""
    Plesk extension '{extension_name}' on target Plesk is not able to restore resellers data,
    such data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_CUSTOMER = single_line_message("""
    Plesk extension '{extension_name}' on target Plesk is not able to restore customers data,
    such data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_SUBSCRIPTION = single_line_message("""
    Plesk extension '{extension_name}' on target Plesk is not able to restore subscriptions data,
    such data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_SITE = single_line_message("""
    Plesk extension '{extension_name}' on target Plesk is not able to restore domains and subdomains data,
    such data of this extension will not be migrated
""")
ACTION_CHECK_EXTENSIONS_EXTENSION_HOOK_MISSED_SOLUTION = single_line_message("""
    Update Plesk extension '{extension_name}' to the latest version,
    if it does not help you can safely ignore this issue
""")

ACTION_DEPLOY_EXTENSIONS_BACKUP_EMPTY = single_line_message("""
    Backup of Plesk extension on {server_description} is empty; extension id: '{extension_id}',
    object type: '{object_type}', object id: '{object_id}'
""")

ACTION_DEPLOY_EXTENSIONS_SERVER = single_line_message("""
    Deploy server-wide Plesk extensions data
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_FAILED = single_line_message("""
    Failed to deploy server-wide Plesk extensions data
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' on {server_description}; server-wide data
    of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' manually on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' from {source_description} to {target_description};
    some server-wide data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' on {server_description}
    after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' on {server_description}; server-wide data
    of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' manually on {server_description} after migration
""")

ACTION_DEPLOY_EXTENSIONS_RESELLERS = single_line_message("""
    Deploy Plesk extensions data for resellers
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for resellers
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_RESELLER_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for reseller '{reseller_username}'
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_RESELLER_NOT_EXISTS = single_line_message("""
    Reseller '{reseller_username}' was not deployed on target yet, deployment of Plesk extensions data
    for reseller '{reseller_username}' will be skipped
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' for reseller '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' for reseller '{entity_name}' on {server_description};
    reseller data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for reseller '{entity_name}' manually
    on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' for reseller '{entity_name}'
    from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' for reseller '{entity_name}'
    from {source_description} to {target_description};
    some reseller data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' for reseller '{entity_name}'
    on {server_description} after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    for reseller '{entity_name}' on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' for reseller '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' for reseller '{entity_name}' on {server_description};
    customer data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_RESELLERS_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for reseller '{entity_name}' manually
    on {server_description} after migration
""")

ACTION_DEPLOY_EXTENSIONS_CUSTOMERS = single_line_message("""
    Deploy Plesk extensions data for customers
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for customers
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_CUSTOMER_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for customer '{customer_username}'
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_CUSTOMER_NOT_EXISTS = single_line_message("""
    Customer '{customer_username}' was not deployed on target yet, deployment of Plesk extensions data
    for customer '{customer_username}' will be skipped
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' for customer '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' for customer '{entity_name}' on {server_description};
    customer data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for customer '{entity_name}' manually
    on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' for customer '{entity_name}'
    from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' for customer '{entity_name}'
    from {source_description} to {target_description};
    some customer data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' for customer '{entity_name}'
    on {server_description} after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    for customer '{entity_name}' on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' for customer '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' for customer '{entity_name}' on {server_description};
    customer data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_CUSTOMERS_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for customer '{entity_name}' manually
    on {server_description} after migration
""")

ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION = single_line_message("""
    Deploy Plesk extensions data for subscription
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for subscription '{subscription_name}'
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_NOT_EXISTS = single_line_message("""
    Subscription '{subscription_name}' was not deployed on target yet, deployment of Plesk extensions data
    for subscription '{subscription_name}' will be skipped
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' for subscription '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' for subscription '{entity_name}' on {server_description};
    subscription data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for subscription '{entity_name}' manually
    on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' for subscription '{entity_name}'
    from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' for subscription '{entity_name}'
    from {source_description} to {target_description};
    some subscription data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' for subscription '{entity_name}'
    on {server_description} after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    for subscription '{entity_name}' on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' for subscription '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' for subscription '{entity_name}' on {server_description};
    subscription data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBSCRIPTION_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for subscription '{entity_name}' manually
    on {server_description} after migration
""")

ACTION_DEPLOY_EXTENSIONS_DOMAINS = single_line_message("""
    Deploy Plesk extensions data for domains
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for domains within subscription '{subscription_name}'
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_DOMAIN_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for domain '{domain_name}' within subscription '{subscription_name}'
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_DOMAIN_NOT_EXISTS = single_line_message("""
    Domain '{domain_name}' was not deployed on target yet, deployment of Plesk extensions data
    for domain '{domain_name}' will be skipped
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' for domain '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' for domain '{entity_name}' on {server_description};
    domain data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for domain '{entity_name}' manually
    on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' for domain '{entity_name}'
    from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' for domain '{entity_name}'
    from {source_description} to {target_description};
    some domain data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' for domain '{entity_name}'
    on {server_description} after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    for domain '{entity_name}' on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' for domain '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' for domain '{entity_name}' on {server_description};
    domain data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_DOMAINS_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for domain '{entity_name}' manually
    on {server_description} after migration
""")

ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS = single_line_message("""
    Deploy Plesk extensions data for subdomains
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for subdomains within subscription '{subscription_name}'
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_SUBDOMAIN_FAILED = single_line_message("""
    Failed to deploy Plesk extensions data for subdomain '{subdomain_name}' within subscription '{subscription_name}'
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_SUBDOMAIN_NOT_EXISTS = single_line_message("""
    Subdomain '{subdomain_name}' was not deployed on target yet, deployment of Plesk extensions data
    for subdomain '{subdomain_name}' will be skipped
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_BACKUP = single_line_message("""
    Backup Plesk extension '{extension_name}' for subdomain '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_BACKUP_FAILED = single_line_message("""
    Unable to backup Plesk extension '{extension_name}' for subdomain '{entity_name}' on {server_description};
    subdomain data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_BACKUP_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for subdomain '{entity_name}' manually
    on {server_description} after migration
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_COPY_CONTENT = single_line_message("""
    Copy content of Plesk extension '{extension_name}' for subdomain '{entity_name}'
    from {source_description} to {target_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_COPY_CONTENT_FAILED = single_line_message("""
    Unable to copy content of Plesk extension '{extension_name}' for subdomain '{entity_name}'
    from {source_description} to {target_description};
    some subdomain data of this extension could not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_COPY_CONTENT_FAILED_SOLUTION = single_line_message("""
    You need to check configuration of Plesk extension '{extension_name}' for subdomain '{entity_name}'
    on {server_description} after migration and configure it manually if needed
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_CLEAR_BACKUP_TEMP_DATA_FAILED = single_line_message("""
    Unable to clean up temporary data created after backing up of Plesk extension '{extension_name}'
    for subdomain '{entity_name}' on {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_RESTORE = single_line_message("""
    Restore Plesk extension '{extension_name}' for subdomain '{entity_name}' at {server_description}
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_RESTORE_FAILED = single_line_message("""
    Unable to restore Plesk extension '{extension_name}' for subdomain '{entity_name}' on {server_description};
    subdomain data of this extension will not be deployed
""")
ACTION_DEPLOY_EXTENSIONS_SUBDOMAINS_RESTORE_FAILED_SOLUTION = single_line_message("""
    You need to configure Plesk extension '{extension_name}' for subdomain '{entity_name}' manually
    on {server_description} after migration
""")

LOG_EXCEPTION = single_line_message("""
    Exception:
""")
COULD_NOT_ADD_ZONE_TO_DNS_ISSUE = single_line_message("""
    Could not add the zone '%s' (secondary, with master server '%s') to DNS. The error is: '%s'
""")
LOG_CREATE_SOURCE_PANEL_MIGRATION_DUMP = single_line_message("""
    Create source dump.
""")
LOG_CREATE_SOURCE_PANEL_MIGRATION_SHALLOW_DUMP = single_line_message("""
    Create source shallow dump.
""")
LOG_CREATE_SOURCE_PANEL_MIGRATION_CAPABILITY_DUMP = single_line_message("""
    Create source capability dump.
""")
FAILED_DNS_FORWARDING_UNDO_MANUAL_SOLUTION = single_line_message("""
    Restore DNS hosting settings manually or from Plesk backup file '%s'
""")
COULD_NOT_UNASSIGN_DNS_SERVER = single_line_message("""
    Could not unassign the DNS server serving domain '%s' in master mode, error code: %s, error message: '%s'
""")
LOG_GET_DNS_TIMINGS_FROM = single_line_message("""
    Get old DNS timing values from '%s' Plesk
""")
LOG_SET_DNS_TIMINGS = single_line_message("""
    Set low DNS timing values on '%s' Plesk
""")
LOG_SKIP_SETTING_UP_DNS_FORWARDING_FOR_SLAVE = single_line_message("""
    Skip setting up the DNS forwarding for domain '%s' zone which is already in slave mode
""")
COULD_NOT_GET_DOMAIN_IDENTIFIER_FROM_PLESK_API = single_line_message("""
    Could not get identifier of domain '%s' on source server using Plesk API, error message: '%s'
""")
LOG_CHANGE_DNS_ZONE_ON_PLESK = single_line_message("""
    Change %d zone(s) on Plesk '%s'
""")
COULD_NOT_ENABLE_DNS_ZONE_OF_DOMAIN = single_line_message("""
    Could not enable the DNS zone of domain '%s', error code: %s, error message: '%s'
""")
LOG_UNDO_DNS_FORWARDING = single_line_message("""
    Undo DNS forwarding on Plesk '%s'
""")
COULD_NOT_SWITCH_TO_SLAVE_DNS_SERVICE = single_line_message("""
    Could not switch to 'slave' the DNS service mode for domain '%s', error code: %s, error message: '%s'
""")
COULD_NOT_DISABLE_DNS_ZONE = single_line_message("""
    Could not disable the DNS zone of domain '%s', error code: %s, error message: '%s'
""")
COULD_NOT_GET_TARGET_DNS_SERVER = single_line_message("""
    Could not get target DNS server for zone '%s', error is '%s'
""")
COULD_NOT_SWITCH_DNS_TO_MASTER = single_line_message("""
    Could not switch to 'master' the DNS service mode for domain '%s', error code: %s, error message: '%s'
""")
COULD_NOT_GET_DOMAIN_IDENTIFIER = single_line_message("""
    Could not get identifier of domain '%s' on source server using Plesk API
""")
LOG_STORE_OLD_DNS_TIMINGS_TO = single_line_message("""
    Store old DNS timing values to '%s'
""")
FAILED_DNS_FORWARDING_SET_UP_MANUAL_SOLUTION = single_line_message("""
    Configure this zone on the source server to be served in slave mode, with the corresponding target DNS server as
    master.
""")
FILE_WITH_TIMINGS_ALREADY_EXISTS = single_line_message("""
    File '%s' with old DNS timing values already exists. Rewrite is not performed not to loose old timing settings
""")
LOG_SET_UP_DNS_FORWARDING_ON_PLESK_SERVER = single_line_message("""
    Set up DNS forwarding on Plesk '%s'
""")
LOG_PLESK_SERVER_INFO = single_line_message("""
    Plesk version '%s', Plesk API version '%s'
""")
INTERNAL_FAILURE_UNABLE_TO_DETECT_SOURCE_PANEL_VERSION = single_line_message("""
    Unable to detect source panel version. Skip checking.
""")
SOURCE_PLESK_VERSION_IS_NOT_SUPPORTED = single_line_message("""
    You are trying to migrate from Plesk version '%s'. Migration from this version is not supported yet.
""")
CHECKING_CONNECTIONS_FAILURE = single_line_message("""
    Error while checking connection settings: '%s'
""")
LOG_REQUIRED_DISK_SPACE_WINDOWS = single_line_message("""
    Required disk space for '%s:' disk: %s bytes
""")
LOG_TOTAL_DISK_USAGE_ON_SOURCE = multi_line_message("""
    Total disk usage on the source servers for domains migrated to server %s:
    - Web: %s bytes
    - Mail: %s bytes
    - MySQL databases: %s bytes
""")
INSUFFICIENT_DISK_SPACE_TARGET_WINDOWS_ISSUE = multi_line_message("""
    Insufficient disk space on {target}:
    
""")
LOG_AVAILABLE_DISK_SPACE_SOURCE = single_line_message("""
    Available disk space on %s, '%s:' disk: %s bytes
""")
INSUFFICIENT_WINDOWS_DISK_SPACE_SOURCE_ISSUE = multi_line_message("""
    Insufficient disk space on {description}:
    
""")
EXPECTED_DISK_SPACE_BY_WINDOWS_DISKS = multi_line_message("""
    - Disk {disk_letter}: - expected to have more than {required} for migrated content, actually have {available}
    
""")
INSUFFICIENT_DISK_SPACE_TARGET_ = multi_line_message("""
    Insufficient disk space on {target}:
    
""")
WINDOWS_RSYNC_PROBLEM_SOLUTION = multi_line_message("""
    Please check that:
    1) There are no firewall rules blocking rsync connections from the target server to the source server.
    TCP port 10156 on the source server is open for incoming connections,
    TCP port 10156 on the target server is open for outgoing connections.
    2) rsync server is configured on the source server according to the Migration Guide.
    3) rsync server is started on the source server.
""")
LACK_OF_DISK_SPACE_ON_DEVICE = single_line_message("""
    Required to have more than {required} on {device} device, available: {available}.
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_SUCCESS = single_line_message("""
    Successfully checked the rsync connection between %s and the source server at %s
""")
ENOUGH_DISK_SPACE_FOR_CONTENT = single_line_message("""
    {target} has enough disk space for content.
""")
LOG_CHECK_CONNECTIONS_TO_TARGET_DATABASE_SERVERS = single_line_message("""
    Check connections to target database servers
""")
ENOUGH_DISK_SPACE_WINDOWS_SOURCE = single_line_message("""
    {source} has enough disk space for temporary files.
""")
NOTICE_THAT_WE_IGNORE_EXCEPTION_AND_USE_0_AS_DISK_SPACE_USAGE = single_line_message("""
    As exception occurred - we just consider database uses 0 bytes not to break all checks. It is very likely that
    database simply does not exist which makes command to fail.
""")
MAX_ALLOWED_MYSQL_PACKET_ISSUE_INTRO = multi_line_message("""
    Some database objects might not be restored.
    
""")
MAX_ALLOWED_MYSQL_PACKET_ISSUE_DESCRIPTION = single_line_message("""
    - The 'max_allowed_packet' parameter on {source_host} is {source},
    which is bigger than on {target_host}, where it is {target}.
""")
LOG_AVAILABLE_DISK_SPACE_WINDOWS = single_line_message("""
    Available disk space for '%s:' disk: %s bytes
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_FAILURE = multi_line_message("""
    Unable to check the rsync connection between %s and the source server at %s:
    %s
    While this problem persists, it may not be possible to copy the %s content of the following subscriptions:%s
""")
LOG_REQUIRED_DISK_SPACE = single_line_message("""
    Required disk space for '%s' device: %s bytes
""")
UNIX_DF_OUTPUT_PARSE_ISSUE_EXPECTED_MORE_LINES = single_line_message("""
    Expected to have more than 2 lines from 'df' utility, got %s. 'df' utility output: %s
""")
LOG_TOTAL_DISK_USAGE_ON_TARGET = multi_line_message("""
    Total disk usage on the target server for domains migrated to %s:
    - Web: %s bytes
    - Mail: %s bytes
    - MySQL databases: %s bytes
""")
UNABLE_CONNECT_NODE_BY_POP3_PORT = multi_line_message("""
    Unable to connect to {node} by POP3 ({port_number} port).
    Please check that:
    1) There are no firewall rules blocking POP3 connections from the current server to the source server.
    2) POP3 server is running on the source server.
""")
MSSQL_UNABLE_TO_FIND_DB_SIZE_IN_SCRIPT_OUTPUT = multi_line_message("""
    Unable to detect database size or/and database file location for database {db_name} on {server}
""")
DEBUG_MSSQL_DISK_USAGE_INFO = single_line_message("""
    MSSQL disk usage info: {disk_usage_info}
""")
LOG_AVAILABLE_DISK_SPACE = single_line_message("""
    Available disk space for '%s' device: %s bytes
""")
COMMAND_DESCRIPTION = multi_line_message("""
    Command the migrator tried to execute on {target} was: {command_str}
    exit code: {exit_code}
    stdout: {stdout}
    stderr: {stderr}
    
""")
LOG_REQUIRED_DISK_SPACE_SOURCE = single_line_message("""
    Required disk space for temporary files on %s, '%s:' disk: %s bytes
""")
MSSQL_UNABLE_TO_PARSE_DISK_SPACE_SCRIPT_OUTPUT = single_line_message("""
    Unable to parse string that should contain disk usage. String: %s
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_SOLUTION = multi_line_message("""
    Make sure that:
    1) There are no firewall rules blocking rsync connections from the target server to the source server:
    the incoming connections on the TCP port 10156 of the source server are allowed, the outgoing connections
    on the TCP port 10156 of the target server are allowed.
    2) The rsync service is configured on the source server according to the Migration Guide.
    3) The rsync service is started on the source server.
""")
INSUFFICIENT_DISK_SPACE_TARGET_WINDOWS_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Increase disk space on the server.
    2) Migrate subscriptions to another server.

    Fix found issues and run the transfer-accounts command again.
""")
CHECK_CONNECTIONS_TO_COPY_MSSQL_DATABASES = single_line_message("""
    Check connections required to copy MSSQL databases from {source} to {target}
""")
INSUFFICIENT_WINDOWS_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Free disk space on the disk.
    2) Change 'session-dir' config.ini parameter for the server so it points
    to directory located on a disk that has enough space.
    
    Fix found issues and run the transfer-accounts command again.
""")
REQUIRED_DISK_SPACE_BY_LETTER = single_line_message("""
    - Disk {disk_letter}: - expected to have more than {required} for migrated content, actually have {available}.
""")
SUCCESS_CHECK_MSSQL_CONNECTIONS = single_line_message("""
    Successfully checked connections required to copy databases from {source} to {target}
""")
LOG_CHECK_CONNECTION_TO_TARGET_DATABASE_SERVER = single_line_message("""
    Check connection to target database server %s
""")
INSUFFICIENT_DISK_SPACE_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Increase disk space on the server.
    2) Migrate subscriptions to another server.

    Fix found issues and run the transfer-accounts command again.
""")
DATABASE_SERVER_CONNECTION_ISSUE = multi_line_message("""
    1) Check that database server is configured and working.
    2) Check that you can create database from target panel for that database server
    3) Check that there are no firewall rules that may block connection to the server
    4) Check that credentials specified in the target panel are correct for that database server
""")
REPORT_TITLE_CONNECTIONS_TO_TARGET_DATABASE_SERVERS = single_line_message("""
    Connections to target database servers
""")
SESSION_DIR_ENOUGH_DISK_SPACE_SOURCE = single_line_message("""
    {source} has enough disk space for temporary files.
""")
SESSION_DIR_INSUFFICIENT_DISK_SPACE_SOURCE_FAILURE = multi_line_message("""
    Insufficient disk space on {source}:
    
""")
UNABLE_TO_CONNECT_FROM_TARGET_MSSQL_SERVER = multi_line_message("""
    Check connections required to copy databases from {source} to {target} failed:
    {reasons}

    Affected subscriptions for which copy database content will fail:
    {affected_subscriptions}
    
    Please check that:
    1) There are no firewall rules blocking required MSSQL connections.
    2) Remote connections to MSSQL server are allowed when necessary.
    3) MSSQL server is running.
""")
UNIX_DF_OUTPUT_PARSE_ISSUE_EXPECTED_AT_LEAST_ONE_ITEM = single_line_message("""
    Expected to have at least 4 item in filesystem line of 'df' utility. Parsed filesystem line items as: %r
""")
UNABLE_CONNECT_BY_IMAP_PORT = multi_line_message("""
    Unable to connect to {node} by IMAP ({port_number} port).
    Please check that:
    1) There are no firewall rules blocking IMAP connections from the current server to the source server.
    2) IMAP server is running on the source server
    3) If you have enforced access by SSL, make sure you specified correct value for 'imap-encryption' option in config.ini
    4) If you don't have IMAP on the source server, configure the tool
    to copy Inbox messages only with 'copy-mail-content: messages'
    option in corresponding section of configuration file.
    In that case migration tools will use POP3 to copy messages
""")
INTERNAL_ERROR_CHECKING_TARGET_DATABASE_SERVER = single_line_message("""
    Internal error: failed to check connection to target database server %s: %s
""")
SESSION_DIR_INSUFFICIENT_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Free disk space for the partition.
    2) Change 'session-dir' config.ini parameter for the server so it points
    to directory located on partition that has enough disk space.
    
    Fix found issues and run the transfer-accounts command again.
""")
UNABLE_TO_CONNECT_TARGET_BY_IMAP_PORT = multi_line_message("""
    Unable to connect to {node} by IMAP ({port_number} port).
    Please check that:
    1) There are no firewall rules blocking IMAP connections from the current server to the target server.
    2) IMAP server is running on the target server
""")
LOG_MAX_ALLOWED_MYSQL_PACKET = single_line_message("""
    Maximum allowed packet size on %s: %s bytes
""")
UNIX_COPY_FILE_CONNECTION_FAILED_SOLUTION = multi_line_message("""
    Please check that:
    1) There are no firewall rules blocking SSH connections from the target server to the source server.
    TCP port {ssh_port} on the source server is open for incoming connections,
    TCP port {ssh_port} on the target server is open for outgoing connections.
    2) The SSH service is running on the source server.
    3) The source server allows using the key-based SSH authentication for the target server.
""")
FAILED_TO_READ_INFORMATION_ABOUT_WPB_SITES = single_line_message("""
    Failed to read information about Web Presence Builder sites.
""")
LOG_RESTORE_RELATION_PLESK_DOMAIN_TO_WPB_SITE = single_line_message("""
    Restore relation between Plesk domain and Web Presence Builder site
""")
LOG_UPLOAD_BACKUP_FILE_TO_TARGET = single_line_message("""
    Upload backup file to target panel management server
""")
LOG_DOWNLOAD_BACKUP_FILE_TO_LOCAL_SERVER = single_line_message("""
    Download backup file to local server
""")
LOG_BACKUP_WPB_SITE_ON_SOURCE = single_line_message("""
    Backup Web Presence Builder site on the source server
""")
ACTION_TRANSFER_WPB_FAILURE = single_line_message("""
    Failed to transfer WPB sites of subscription '%s'
""")
ACTION_TRANSFER_WPB_DESCRIPTION = single_line_message("""
    Transfer WPB sites
""")
LOG_RESTORE_WPB_SITE_ON_TARGET = single_line_message("""
    Restore Web Presence Builder site on target panel management server
""")
DEBUG_COLLECTING_INFO_ABOUT_WPB_SITES = single_line_message("""
    Collecting information about Web Presence Builder sites
""")
ACTION_RESTORE_DEDICATED_APPLICATION_POOL_DESCRIPTION = single_line_message("""
    Restore IIS dedicated application pools
""")
ACTION_RESTORE_DEDICATED_APPLICATION_POOL_FAILURE = single_line_message("""
    Failed to restore dedicated application pool for subscription '%s'
""")
ACTION_FIX_SECURITY_FILES_DESCRIPTION = single_line_message("""
    Fix files with permissions settings for Windows
""")
ACTION_FIX_SECURITY_FILES_FAILURE = single_line_message("""
    Failed to restore file permissions for subscription '%s'
""")
ACTION_CREATE_SECURED_WEB_CONTENT_DESCRIPTION = single_line_message("""
    Create files and directories that have customized Windows permissions
""")
ACTION_CREATE_SECURED_WEB_CONTENT_FAILURE = single_line_message("""
    Failed to create files and directories that have customized Windows permissions. After migration
    these files may have default (inherited) permissions.
""")
LOG_CREATE_SECURED_WEB_CONTENT = single_line_message("""
    Create secured web content from file '{path}'
""")
LOG_GET_IIS_DEDICATED_APPLICATION_POOL_USER = single_line_message("""
    Get IIS dedicated application pool user on target server
""")
LOG_UPLOAD_FIXED_FILE_TO_TARGET = single_line_message("""
    Upload fixed '%s' file to target server
""")
LOG_SKIP_PROCESSING_SECURITY_FILE = single_line_message("""
    Skip processing '%s' file as it does not exist on source
""")
LOG_GET_FILE_TO_CHANGE_IIS_POOL_USER = single_line_message("""
    Get '%s' file to change dedicated IIS application user that was changed, put it to '%s'
""")
LOG_IIS_DEDICATED_APPLICATION_POOL_USER_ON_TARGET = single_line_message("""
    IIS dedicated application pool user on target server: '%s'
""")
LOG_FIX_SECURITY_FILE = single_line_message("""
    Fix '%s' file, write fixed file to '%s'
""")
ACTION_FIX_UNIX_VHOST_STRUCTURE_FAILURE = single_line_message("""
    Failed to fix vhost structure for subscription '%s'
""")
ACTION_FIX_UNIX_VHOST_STRUCTURE_DESCRIPTION = single_line_message("""
    Fix vhost structure for Unix servers
""")
CAN_NOT_CREATE_LINKS_FOR_SUBSCRIPTION = single_line_message("""
    Can't create links for subscription '%s' with error '%s'.
""")
ACTION_FIX_PERMISSIONS_FOR_IIS6_DOMAIN_DESCRIPTION = single_line_message("""
    Fix permissions for domains from IIS 6 with disabled ASP.NET
""")
ACTION_FIX_PERMISSIONS_FOR_IIS6_DOMAIN_FAILURE = single_line_message("""
    Failed to fix permissions of files for subscription '%s'
""")
ACTION_RESET_PERMISSIONS_DESCRIPTION = single_line_message("""
    Fix file permissions for Windows
""")
ACTION_RESET_PERMISSIONS_FAILURE = single_line_message("""
    Failed to restore file permissions for subscription '%s'
""")
REPAIR_PERMISSIONS_FOR_SUBSCRIPTION = single_line_message("""
    Repair permissions for the '%s' subscription
""")
UPDATE_WEBSPACE_SUBDOMAINS_SECURITY = single_line_message("""
    Update webspace subdomains security for the '%s' subscription
""")
ACTION_FIX_UNIX_PERMISSIONS_DESCRIPTION = single_line_message("""
    Fix permissions for web files
""")
ACTION_FIX_UNIX_PERMISSIONS_FAILED = single_line_message("""
    Failed to fix permissions for web files of subscription '%s'
""")
LOG_FIX_FILE_OWNERSHIP_AFTER_MOVING = single_line_message("""
    Fix file ownership for files in domain directory after moving
""")
ACTION_CHECK_TARGET_WEB_HOSTING_FAILURE = single_line_message("""
    Failed to check if subscription '%s' has web IP
""")
ACTION_CHECK_TARGET_WEB_HOSTING_DESCRIPTION = single_line_message("""
    Check that each subscription with virtual hosting has web IP
""")
NO_WEB_HOSTING_ERROR = single_line_message("""
    Unable to continue migration: web hosting of the corresponding webspace in target panel is not configured.
    Make sure that web hosting of the corresponding webspace is configured.
""")
ACTION_FIX_UNIX_PERMISSIONS_ON_OLD_PLESKS_FAILURE = single_line_message("""
    Failed set permissions for statistics and logs directories for subscription '%s'
""")
ACTION_FIX_UNIX_PERMISSIONS_ON_OLD_PLESKS_DESCRIPTION = single_line_message("""
    Set permissions for statistics and logs directories
""")
LOG_FIX_LOGS_DIRECTORIES_PERMISSION = single_line_message("""
    Fix logs directories permission after migration from Plesk 8/9/10
""")
ACTION_RESTORE_APS_APPLICATIONS_FAILURE = single_line_message("""
    Failed to restore APS applications settings for subscription '%s'
""")
ACTION_TRANSFER_APS_PACKAGES_FAILURE_SOLUTION = single_line_message("""
    Old and custom APS applications will be likely not registered in target panel as APS applications (still migration
    tools will try to transfer their files and databases). To fix the issue manually, you could try to register APS
    packages manually in the target panel, then restart copy content with 'copy-content' command.
""")
ACTION_TRANSFER_APS_PACKAGES_FAILURE = single_line_message("""
    Failed to transfer APS packages.
""")
FAILED_TO_INSTALL_APS_PACKAGE = single_line_message("""
    Failed to install APS package '%s-%s-%s'. Target panel will not consider this application as installed.
    However all application-related content should be restored correctly.
""")
APS_PACKAGE_WAS_NOT_FOUND_SOURCE = single_line_message("""
    APS package was not found on the source Plesk server
""")
UNABLE_TO_FIND_FILENAME_FOR_APS_PACKAGE = single_line_message("""
    Unable to find filename for APS package '%s-%s-%s'. This can cause errors while restoring APS applications.
""")
FAILED_TO_READ_INFORMATION_ABOUT_APS_PACKAGES = single_line_message("""
    Failed to read information about APS packages for subscription.
""")
LOG_LOOKING_FOR_APS_PACKAGES_TO_TRANSFER = single_line_message("""
    Looking for APS packages to transfer
""")
LOG_COPY_PACKAGE = single_line_message("""
    Copy package '%s-%s-%s' required to restore the following subscription(s): %s (#%d out of #%d)
""")
FETCH_CONFIGURATION_DATA_FROM_PLESK_SERVERS = single_line_message("""
    Fetch configuration data from Plesk servers
""")
FAILED_FETCH_CONFIGURATION_DATA_FROM_PLESK = single_line_message("""
    Failed to fetch configuration data from Plesk servers
""")
LOG_USING_CACHED_DUMP = single_line_message("""
    Using the existing dump '{dump_filename}' for '{source_id}'
""")
FETCH_INFORMATION_ABOUT_WEB_APPLICATIONS_INSTALLED = single_line_message("""
    Fetch information about web applications installed on '%s'
""")
ACTION_FETCH_APPLICATIONS_DESCRIPTION = single_line_message("""
    Fetch information about APS web applications
""")
ACTION_FETCH_APPLICATIONS_FAILURE = single_line_message("""
    Failed to fetch information about APS web applications
""")
ACTION_FETCH_SHALLOW_BACKUP_DESCRIPTION = single_line_message("""
    Fetch basic information about resellers, clients and domains data from source servers
""")
LOG_USING_CACHED_SHALLOW_DUMP = single_line_message("""
    Using the existing shallow dump for '%s'
""")
ACTION_FETCH_SHALLOW_BACKUP_FAILURE = single_line_message("""
    Failed to fetch basic information about resellers, clients and domains data from source servers
""")
ACTION_MERGE_APPLICATIONS_DESCRIPTION = single_line_message("""
    Merge information about APS web applications into backup
""")
ACTION_MERGE_APPLICATIONS_FAILURE = single_line_message("""
    Failed to merge information about APS web applications into backup
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_ACL_DESCRIPTION = single_line_message("""
    Add source server to target DNS ACL
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_ACL_FAILURE = single_line_message("""
    Failed to add source server to target DNS ACL
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_AXFR_DESCRIPTION = single_line_message("""
    Add source server's AXFR record to target DNS
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_AXFR_FAILURE = single_line_message("""
    Failed to add source server's AXFR record to target DNS
""")
ACTION_FETCH_CAPABILITY_INFO_FROM_PLESK_SERVERS = single_line_message("""
    Fetch capability info from Plesk servers
""")
ACTION_FAILED_FETCH_CAPABILITY_INFO_FROM_PLESK = single_line_message("""
    Failed to fetch capability info from Plesk servers
""")
FAILED_TO_CONFIGURE_DNS_FORWARDING_FOR_ZONE = single_line_message("""
    Failed to configure DNS forwarding for DNS zone {zone}: {error}
""")
ACTION_RESTORE_APS_APPLICATIONS = single_line_message("""
    Restore APS applications
""")
APS_APPLICATIONS_HOSTING_DESCRIPTION = single_line_message("""
    APS applications
""")
ACTION_TRANSFER_APS_PACKAGES = single_line_message("""
    Transfer APS packages
""")
INFRASTRUCTURE_CHECK_DB_ISSUES = multi_line_message("""
    %s
    Fix found issues and run the transfer-accounts command again.
    If the issues are not fixed, it will be not possible to transfer databases for the following subscription(s): %s
""")
INFRASTRUCTURE_CHECK_CONTENT_ISSUES_SUBSCRIPTION = multi_line_message("""
    %s
    Fix found issues and run the transfer-accounts command again.
    If the issues are not fixed, it will be not possible to transfer %s for the following subscription(s): %s
""")
INFRASTRUCTURE_CHECK_WEB_CONTENT_ISSUES_DOMAINS = multi_line_message("""
    {reason}
    Fix found issues and run the transfer-accounts command again.
    If the issues are not fixed, it will be not possible to transfer web files for the following domain(s): {domains}
""")
DEBUG_DISK_SPACE_CHECK = single_line_message("""
    Target main server disk space check - subscriptions count: %s, required: %r, available: %r
""")
INFRASTRUCTURE_INVALID_FILE_CONTENT = multi_line_message("""
    Unexpected error: invalid content of file was transferred with '%s'
    Expected content: %s
    Actual content on target server: %s
""")
SOLUTION_INCREASE_MAX_ALLOWED_PACKET = single_line_message("""
    Please increase the 'max_allowed_packet' value on the destination database server.
""")
MAX_ALLOWED_PACKET_OK = single_line_message("""
    {description_target_database} has enough max allowed packet for all MySQL databases.
""")
MYSQL_COMMAND_NON_ZERO_EXIT_CODE = multi_line_message("""
    MySQL command '%s' with args %r returned non-zero exit code.
    Stdout: %s
    Stderr: %s
""")
LOG_CHECK_CONNECTION_BY_IMAP = single_line_message("""
    Check connection to {node} by IMAP ({port_number} port
""")
IMAP_CONNECTION_OK = single_line_message("""
    Successfully connected to {node} by IMAP ({port_number} port).
""")
LOG_CONNECTION_BY_POP3 = single_line_message("""
    Check connection to {node} by POP3 ({port_number} port)
""")
POP3_CONNECTION_OK = single_line_message("""
    Successfully connected to {node} by POP3 ({port_number} port).
""")
COPY_SAMPLE_FILE_FAILURE = multi_line_message("""
    Unable to copy the sample file from {source} to {target} using '{command_name}'.

    {problem_description}

    The following command has failed:
    {failed_command_description}
""")
COPY_SAMPLE_FILE_OK = single_line_message("""
    Successfully copied the sample file using '{command_name}' from {source} to {target}
""")
LOG_COPY_SAMPLE_FILE = single_line_message("""
    Copy the sample file from {source} to {target} using '{command_name}'
""")
DISK_SPACE_LACK = single_line_message("""
    - '{device}': expected to have more than {required} for migrated content, actually have {available}.
""")
CHECK_SKIPPED = single_line_message("""
    The check was skipped.
""")
SUCCESSFULLY_CONNECTED_TO = single_line_message("""
    Successfully connected to %s
""")
LOG_SOURCE_PLESK_HOST = single_line_message("""
    Source Plesk '%s' host: %s
""")
LOG_GET_OLD_DNS_TIMING_VALUES = single_line_message("""
    Get old DNS timing values
""")
LOG_SET_LOW_DNS_TIMING_VALUES = single_line_message("""
    Set low DNS timing values
""")
LOG_RUN_MIGRATION_AGENT = single_line_message("""
    Run migration agent
""")
LOG_DOWNLOAD_DUMP_XML = single_line_message("""
    Download dump XML to '%s'
""")
LOG_DOWNLOAD_FILE_TO = single_line_message("""
    Download a file to '%s'
""")
LOG_CAPABILITY_DUMP_LOG_FILE = single_line_message("""
    Capability dump log file was saved to '{filename}'
""")
LOG_CONFIGURATION_DUMP_LOG_FILE = single_line_message("""
    Configuration dump log file was saved to '{filename}'
""")
ERROR_DOWNLOADING_FILE = single_line_message("""
    Error downloading file: %s
""")
ERROR_RUNNING_COMMAND = single_line_message("""
    Error running command: %s
""")
LOG_GET_SERVER_INFO = single_line_message("""
    Get server '%s' info
""")
ACTION_FORWARD_DNS = single_line_message("""
    Forward DNS
""")
ACTION_PRINT_FORWARDING_REPORT = single_line_message("""
    Print DNS forwarding report
""")
ACTION_UNDO_DNS_FORWARDING = single_line_message("""
    Undo DNS forwarding
""")
ACTION_SET_LOW_DNS_TIMINGS = single_line_message("""
    Set low DNS timings
""")
FAILED_TO_EXECUTE_SQL_QUERY_PARSE_JSON = multi_line_message("""
    Failed to execute SQL query on Plesk database: failed to parse JSON returned by SQL script.
    Query: {query}
    Command's exit code: {exit_code}
    Command's stdout: {stdout}
    Command's stderr: {stderr}
""")
EXECUTE_SQL_QUERY = single_line_message("""
    Execute SQL query on panel database: {query}
""")
FAILED_TO_EXECUTE_SQL_QUERY = single_line_message("""
    Failed to execute SQL query on panel database: {reason}
""")
PLESK_VERSION_NOT_SUPPORTED_BY_SHALLOW_DUMP = single_line_message("""
    Plesk version '{plesk_version}' is not supported by fast shallow dump
""")
PLESK_VERSION_NOT_SUPPORTED_BY_CAPABILITY_DUMP = single_line_message("""
    Plesk version '{plesk_version}' is not supported by capability dump model
""")
WPB_SITE_DESCRIPTION = single_line_message("""
    Domain '{domain_name}', site ID '{site_id}
""")
WPB_NOT_INSTALLED_ERROR = multi_line_message("""
    Unable to register Web Presence Builder sites of subscription in Web Presence Builder:
    {sites}

    Web Presence Builder component is not installed on the target Plesk server.
    The site(s) will work, but you will not be able to edit them with Web Presence Builder.
""")
WPB_NOT_INSTALLED_SOLUTION = multi_line_message("""
    To resolve the issue, install the component and run migration again for that domain:
    1. Open "Tools & Settings".
    2. Click on "Updates and Upgrades".
    3. Select "Web Presence Builder" component for installation and click "Continue".
    4. Run migration again for that subscription.
""")
UNABLE_TO_FIND_ADMIN_USER = single_line_message("""
    Unable to find admin user
""")
UNABLE_TO_GET_PHP_HANDLER_PROPERTIES = multi_line_message("""
    Unable to get properties of PHP handler from '{description}'.
    That may cause selection of inappropriate PHP handlers on the target server.
    Update components list on the source server and make sure valid PHP handlers are registered there.
    Error message: {error}
""")
SKIP_ERROR_DOCUMENTS_FOR_VDIR_IN_WEB_ROOT = single_line_message("""
    Skip restoration of error documents of virtual directory '{directory}', as it refers to document root ('{path}').
    Error documents can not be restored correctly in that case for recent Plesk versions.
""")
UNABLE_TO_CHECK_COMMAND = single_line_message("""
    Unable to check '{command}' command availability: {error}
""")
DOMAIN_CONFIGURATION_BACKUP_IS_NOT_FOUND = single_line_message("""
    The configuration backup of subscription '{name}' is not found. Not all subscription settings may be migrated.
""")
FAILED_TO_MERGE_DOMAIN_CONFIGURATION_BACKUP = multi_line_message("""
    Failed to merge the configuration backup of subscription '{name}'. Not all subscription settings may be migrated.
    Error message: {error}
""")
PLESK_VERSION_NOT_SUPPORTED_BY_HOSTING_DESCRIPTION_DUMP = single_line_message("""
    Plesk version '{plesk_version}' is not supported by hosting description dump model
""")
FAILED_TO_DECRYPT_ACCOUNTS_PASSWORDS = multi_line_message("""
    Failed to decrypt accounts passwords. Passwords may be reset.
    Error message: {error}
""")
FAILED_TO_DECRYPT_DATABASE_SERVERS_PASSWORDS = multi_line_message("""
    Failed to decrypt database servers administrators passwords. Databases contents may not be migrated.
    Error message: {error}
""")
FAILED_TO_GET_PANEL_DATABASE_PASSWORD = multi_line_message("""
    Failed to get the panel database password. Not all databases contents may be migrated.
    Error message: {error}
""")
FAILED_TO_MAKE_APS_APPLICATIONS_DUMP = multi_line_message("""
    Failed to make APS applications dump. Not all applications data may be migrated.
    Error message: {error}
""")
FAILED_TO_PARSE_STATUS = multi_line_message("""
    Failed to parse status '{status}': {error}
""")
FAILED_TO_PARSE_CUSTOM_BUTTON_OPTIONS = multi_line_message("""
    Failed to parse custom button options '{options}': {error}
""")
FAILED_TO_PARSE_FTP_USER_PERMISSION = multi_line_message("""
    Failed to parse ftp user permissions '{permission}': {error}
""")
INVALID_INT_VALUE = single_line_message("""
    String should contain integer number
""")
FAILED_TO_ENCODE_DNS_ZONE_PARAMETER = multi_line_message("""
    Failed to encode DNS zone parameter '{value}' ({unit}): {error}
""")
LOAD_SCHEMA_FROM = single_line_message("""
    Load schema from '{path}'
""")
FAILED_TO_DUMP_DATA = multi_line_message("""
    Failed to dump the following data: {description}. Not all data may be migrated.
    Error message: {error}
""")
FAILED_TO_DUMP_CAPABILITY_DATA = multi_line_message("""
    Failed to dump the following capability data: {description}. Not all potential problems may be detected.
    Error message: {error}
""")
FAILED_TO_DUMP_ENTITY = multi_line_message("""
    Failed to dump the following data: {entity_path}. Not all data may be migrated.
    Error message: {error}
""")
FAILED_TO_DUMP_ENTITY_CAPABILITY = multi_line_message("""
    Failed to dump the following capability data: {entity_path}. Not all potential problems may be detected.
    Error message: {error}
""")
FAILED_TO_DUMP_ENTITY_DATA = multi_line_message("""
    Failed to dump the following data: {entity_path}: {description}. Not all data may be migrated.
    Error message: {error}
""")
FAILED_TO_DUMP_ENTITY_CAPABILITY_DATA = multi_line_message("""
    Failed to dump the following capability data: {entity_path}: {description}. Not all potential problems may be detected.
    Error message: {error}
""")
DATA_DUMP_SUBSCRIPTIONS_PROPERTIES = single_line_message("""
    Subscriptions properties
""")
DATA_DUMP_SUBSCRIPTION_USERS = single_line_message("""
    Subscription users
""")
DATA_DUMP_SUBSCRIPTIONS_USERS = single_line_message("""
    Subscriptions users
""")
DATA_DUMP_SUBSCRIPTION_USERS_ROLES = single_line_message("""
    Subscription users roles
""")
DATA_DUMP_SUBSCRIPTIONS_USERS_ROLES = single_line_message("""
    Subscriptions users roles
""")
DATA_DUMP_SETTINGS = single_line_message("""
    Settings
""")
DATA_DUMP_SERVER_SETTINGS = single_line_message("""
    Server settings
""")
DATA_DUMP_DNS_SETTINGS = single_line_message("""
    DNS settings
""")
DATA_DUMP_FTP_SETTINGS = single_line_message("""
    FTP settings
""")
DATA_DUMP_WEB_APPLICATION_FIREWALL_SETTINGS = single_line_message("""
    Web application firewall settings
""")
DATA_DUMP_APACHE_MODULES = single_line_message("""
    Apache modules
""")
DATA_DUMP_POSTGRESQL_SETTINGS = single_line_message("""
    PostgreSQL settings
""")
DATA_DUMP_PHP_HANDLERS = single_line_message("""
    PHP handlers
""")
DATA_DUMP_COMPONENTS = single_line_message("""
    Components
""")
DATA_DUMP_WEB_HOSTING_COMPONENTS = single_line_message("""
    Web hosting components
""")
DATA_DUMP_WEBMAIL_COMPONENTS = single_line_message("""
    Webmail components
""")
DATA_DUMP_DNS_COMPONENTS = single_line_message("""
    DNS components
""")
DATA_DUMP_MAIL_COMPONENTS = single_line_message("""
    Mail components
""")
DATA_DUMP_MAILLISTS_COMPONENTS = single_line_message("""
    Mailing lists components
""")
DATA_DUMP_SERVER_COMPONENTS = single_line_message("""
    Server components
""")
DATA_DUMP_RESOURCES_USAGE = single_line_message("""
    Resources usage
""")
DATA_DUMP_DISK_USAGE = single_line_message("""
    Disk usage
""")
DATA_DUMP_SERVER_RESOURCES_USAGE = single_line_message("""
    Server resources usage
""")
DATA_DUMP_PHP_SETTINGS = single_line_message("""
    PHP settings
""")
DATA_DUMP_SERVICE_PLANS = single_line_message("""
    Service plans
""")
DATA_DUMP_IP_ADDRESSES = single_line_message("""
    IP addresses
""")
DATA_DUMP_APPLICATIONS = single_line_message("""
    Applications
""")
DATA_DUMP_APPLICATIONS_FILTERS = single_line_message("""
    Applications filters
""")
DATA_DUMP_APPLICATIONS_FILTER = single_line_message("""
    Applications filter
""")
DATA_DUMP_LOG_ROTATION_SETTINGS = single_line_message("""
    Log rotation settings
""")
DATA_DUMP_PASSWORDS = single_line_message("""
    Passwords
""")
DATA_DUMP_CUSTOM_BUTTONS = single_line_message("""
    Custom buttons
""")
DATA_DUMP_IIS_APPLICATION_POOL_SETTINGS = single_line_message("""
    IIS application pool settings
""")
DATA_DUMP_IIS_APPLICATIONS_POOLS_SETTINGS = single_line_message("""
    IIS applications pools settings
""")
DATA_DUMP_DOMAINS = single_line_message("""
    Domains
""")
DATA_DUMP_WEB_HOSTING_SETTINGS = single_line_message("""
    Web hosting settings
""")
DATA_DUMP_DOMAINS_SERVICES_SETTINGS = single_line_message("""
    Domains services settings
""")
DATA_DUMP_SYSTEM_USERS = single_line_message("""
    System users
""")
DATA_DUMP_FTP_USERS = single_line_message("""
    FTP users
""")
DATA_DUMP_WEB_USERS = single_line_message("""
    Web users
""")
DATA_DUMP_MAILBOXES = single_line_message("""
    Mailboxes
""")
DATA_DUMP_MAIL_SETTINGS = single_line_message("""
    Mail settings
""")
DATA_DUMP_DOMAIN_KEYS = single_line_message("""
    Domain keys
""")
DATA_DUMP_MAIL_ALIASES = single_line_message("""
    Mail aliases
""")
DATA_DUMP_MAIL_FORWARDING = single_line_message("""
    Mail forwarding settings
""")
DATA_DUMP_MAIL_AUTO_REPLY_SETTINGS = single_line_message("""
    Mail auto-reply settings
""")
DATA_DUMP_MAILLISTS = single_line_message("""
    Mailing lists
""")
DATA_DUMP_MAILLISTS_SETTINGS = single_line_message("""
    Mailing lists settings
""")
DATA_DUMP_LIMITS = single_line_message("""
    Limits
""")
DATA_DUMP_PERMISSIONS = single_line_message("""
    Permissions
""")
DATA_DUMP_DOMAIN_ALIASES = single_line_message("""
    Domain aliases
""")
DATA_DUMP_DNS_ZONE = single_line_message("""
    DNS zone
""")
DATA_DUMP_DNS_ZONES = single_line_message("""
    DNS zones
""")
DATA_DUMP_DNS_RECORDS = single_line_message("""
    DNS records
""")
DATA_DUMP_DNS_TEMPLATES_RECORDS = single_line_message("""
    DNS templates records
""")
DATA_DUMP_DATABASES = single_line_message("""
    Databases
""")
DATA_DUMP_DATABASES_USERS = single_line_message("""
    Databases users
""")
DATA_DUMP_SCHEDULED_TASKS = single_line_message("""
    Scheduled tasks
""")
DATA_DUMP_SSL_CERTIFICATES = single_line_message("""
    SSL certificates
""")
DATA_DUMP_PROTECTED_DIRECTORIES = single_line_message("""
    Protected directories
""")
DATA_DUMP_PROTECTED_DIRECTORIES_USERS = single_line_message("""
    Protected directories users
""")
DATA_DUMP_SPAM_FILTERING_SETTINGS = single_line_message("""
    Spam filtering settings
""")
DATA_DUMP_CLIENTS = single_line_message("""
    Clients
""")
DATA_DUMP_RESELLER_PLANS = single_line_message("""
    Reseller plans
""")
DATA_DUMP_HOSTING_PLANS = single_line_message("""
    Hosting plans
""")
DATA_DUMP_RESELLERS = single_line_message("""
    Resellers
""")
DATA_DUMP_CUSTOMERS = single_line_message("""
    Customers
""")
DATA_DUMP_SUBSCRIPTIONS = single_line_message("""
    Subscriptions
""")
DATA_DUMP_APPLICATION_LICENSE = single_line_message("""
    Application license
""")
DATA_DUMP_APPLICATION_ENTRY_POINTS = single_line_message("""
    Application entry points
""")
DATA_DUMP_CONTACT_INFO = single_line_message("""
    Contact info
""")
DATA_DUMP_SUBSCRIPTION_INFO = single_line_message("""
    Subscription info
""")
DATA_DUMP_DOCUMENT_ROOT = single_line_message("""
    Document root
""")
DATA_DUMP_ANONYMOUS_FTP = single_line_message("""
    Anonymous FTP settings
""")
DATA_DUMP_PERFORMANCE = single_line_message("""
    Performance settings
""")
DATA_DUMP_HOTLINK_PROTECTION = single_line_message("""
    Hotlink protection settings
""")
DATA_DUMP_DYNAMIC_IP_SECURITY = single_line_message("""
    Dynamic IP security settings
""")
DATA_DUMP_WEB_SERVER_SETTINGS = single_line_message("""
    Web server settings
""")
DATA_DUMP_DATABASE_SERVERS = single_line_message("""
    Database servers
""")
DATA_DUMP_WORDPRESS_INSTANCES = single_line_message("""
    Wordpress instances
""")
DATA_DUMP_EXTENSIONS = single_line_message("""
    Extensions
""")
ENTITY_DUMP_RESELLER_PLAN = single_line_message("""
    Reseller plan
""")
ENTITY_DUMP_HOSTING_PLAN = single_line_message("""
    Hosting plan
""")
ENTITY_DUMP_RESELLER = single_line_message("""
    Reseller
""")
ENTITY_DUMP_CUSTOMER = single_line_message("""
    Customer
""")
ENTITY_DUMP_SUBSCRIPTION = single_line_message("""
    Subscription
""")
ENTITY_DUMP_DATABASE_SERVER = single_line_message("""
    Database server
""")
ENTITY_DUMP_DATABASE = single_line_message("""
    Database
""")
ENTITY_DUMP_DATABASE_USER = single_line_message("""
    Database user
""")
ENTITY_DUMP_DOMAIN = single_line_message("""
    Domain
""")
ENTITY_DUMP_SUBDOMAIN = single_line_message("""
    Subdomain
""")
ENTITY_DUMP_DOMAIN_ALIAS = single_line_message("""
    Domain alias
""")
ENTITY_DUMP_SYSTEM_USER = single_line_message("""
    System user
""")
ENTITY_DUMP_FTP_USER = single_line_message("""
    FTP user
""")
ENTITY_DUMP_WEB_USER = single_line_message("""
    Web user
""")
ENTITY_DUMP_SSL_CERTIFICATE = single_line_message("""
    SSL certificate
""")
ENTITY_DUMP_APPLICATION = single_line_message("""
    Application
""")
ENTITY_DUMP_MAILBOX = single_line_message("""
    Mailbox
""")
ENTITY_DUMP_MAILLIST = single_line_message("""
    Mailing list
""")
ENTITY_DUMP_SUBSCRIPTION_USER = single_line_message("""
    Subscription user
""")
ENTITY_DUMP_SUBSCRIPTION_USER_ROLE = single_line_message("""
    Subscription user role
""")
SOURCE_PLESK_INVALID_PLAN_ID = single_line_message("""
    Source Plesk server has inconsistency in database: plan with ID '{plan_id}' does not exists.
    In most cases that issue could be safely ignored.
""")
FAILED_TO_DECODE_SUBSCRIPTIONS_USERS_PASSWORDS = multi_line_message("""
    Failed to decode the passwords of some subscriptions users. The passwords will be reset.
    Users: {users}
""")
MAILLISTS_SETTINGS_DUMPING_ERRORS = multi_line_message("""
    The errors occurred while dumping mailing lists settings. Not all settings may be migrated.
    {errors}
""")
FAILED_TO_GET_MAILLIST_SUBSCRIBERS = single_line_message("""
    Failed to get subscribers of the mailing list '{name}': {error}
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
