from functools import wraps
import logging

from parallels.core.registry import Registry
from parallels.core.reports.model.issue import Issue
from parallels.core.utils.common import safe_format
from parallels.plesk.source.plesk import messages

logger = logging.getLogger(__name__)


def data_dump(description, default=None):
    """
    :type description: str | unicode
    :type default:
    """
    def migration_entity_decorator(func):
        @wraps(func)
        def func_wrapper(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except Exception as e:
                logger.debug(messages.LOG_EXCEPTION, exc_info=True)
                Registry.get_instance().get_context().pre_check_report.add_issue(
                    'dump_data',
                    Issue.SEVERITY_WARNING,
                    safe_format(messages.FAILED_TO_DUMP_DATA, description=description, error=e)
                )
                return default
        return func_wrapper
    return migration_entity_decorator
