from parallels.core.utils.entity import Entity


class IisAppPool(Entity):
    def __init__(
        self, iis_app_pool_id, owner_id, owner_type, is_started, identity, max_processes, cpu_limit, cpu_limit_action,
        cpu_limit_interval, idle_timeout, idle_timeout_action, recycling_by_time, recycling_by_requests,
        recycling_by_virtual_memory, recycling_by_private_memory, managed_pipeline_mode,
    ):
        self._iis_app_pool_id = iis_app_pool_id
        self._owner_id = owner_id
        self._owner_type = owner_type
        self._is_started = is_started
        self._identity = identity
        self._max_processes = max_processes
        self._cpu_limit = cpu_limit
        self._cpu_limit_action = cpu_limit_action
        self._cpu_limit_interval = cpu_limit_interval
        self._idle_timeout = idle_timeout
        self._idle_timeout_action = idle_timeout_action
        self._recycling_by_time = recycling_by_time
        self._recycling_by_requests = recycling_by_requests
        self._recycling_by_virtual_memory = recycling_by_virtual_memory
        self._recycling_by_private_memory = recycling_by_private_memory
        self._managed_pipeline_mode = managed_pipeline_mode

    @property
    def iis_app_pool_id(self):
        """
        :rtype: str | unicode
        """
        return self._iis_app_pool_id

    @property
    def owner_id(self):
        """
        :rtype: str | unicode
        """
        return self._owner_id

    @property
    def owner_type(self):
        """
        :rtype: str | unicode
        """
        return self._owner_type

    @property
    def is_started(self):
        """
        :rtype: str | unicode
        """
        return self._is_started

    @property
    def identity(self):
        """
        :rtype: str | unicode
        """
        return self._identity

    @property
    def max_processes(self):
        """
        :rtype: str | unicode
        """
        return self._max_processes

    @property
    def cpu_limit(self):
        """
        :rtype: str | unicode
        """
        return self._cpu_limit

    @property
    def cpu_limit_action(self):
        """
        :rtype: str | unicode
        """
        return self._cpu_limit_action

    @property
    def cpu_limit_interval(self):
        """
        :rtype: str | unicode
        """
        return self._cpu_limit_interval

    @property
    def idle_timeout(self):
        """
        :rtype: str | unicode
        """
        return self._idle_timeout

    @property
    def idle_timeout_action(self):
        """
        :rtype: str | unicode
        """
        return self._idle_timeout_action

    @property
    def recycling_by_time(self):
        """
        :rtype: str | unicode
        """
        return self._recycling_by_time

    @property
    def recycling_by_requests(self):
        """
        :rtype: str | unicode
        """
        return self._recycling_by_requests

    @property
    def recycling_by_virtual_memory(self):
        """
        :rtype: str | unicode
        """
        return self._recycling_by_virtual_memory

    @property
    def recycling_by_private_memory(self):
        """
        :rtype: str | unicode
        """
        return self._recycling_by_private_memory

    @property
    def managed_pipeline_mode(self):
        """
        :rtype: str | unicode | None
        """
        return self._managed_pipeline_mode
