# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package Storage::DbBundle;

use strict;
use Storage::Bundle;
use Db::Connection;
use File::Path;
use vars qw|@ISA|;

@ISA = qw|Storage::Bundle|;

sub _init {
  my ($self, %params) = @_;
  $self->SUPER::_init(%params);

  $self->{params} = \%params;

  return 1;
}

sub commandLine {
  my ($self) = @_;
  return Db::Connection::getDumpCmdLine(%{$self->{params}});
}

sub isLogAllowed {
  my ($self) = @_;
  return Db::Connection::isLogAllowed();
}

sub cleanup {
  my ($self) = @_;

  my $exit_code = $self->SUPER::cleanup();
  
  my @files = Db::Connection::getFileToRemove(%{$self->{params}});
  
  foreach my $file (@files) {
    if (-f $file) {
      unlink $file;
    } elsif (-d $file) {
      rmtree $file;
    }
  }

  return $exit_code;
}


1;
