# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package DumpStatus;

use strict;

use vars qw|@ISA|;

# -- Factory

my @reg_errors;
my @reg_warns;

sub createBackup {
  require BackupDumpStatus;
  return BackupDumpStatus->new();
}

sub createMigration {
  my ($outputFile) = @_;

  require MigrationDumpStatus;
  return MigrationDumpStatus->new($outputFile);
}

# -- DumpStatus interface

sub new {
  my $self = {};
  bless($self, shift);
  $self->_init(@_);
  return $self;
}

sub _init {
  my ($self) = @_;
}

sub start {
  my ($self, $clients, $domains) = @_;

  die "Pure virtual function call";
}

sub startDomain {
  my ($self, $domain) = @_;

  die "Pure virtual function call";
}

sub startClient {
  my ($self, $client) = @_;

  die "Pure virtual function call";
}

sub finish {
  my ($self) = @_;

  die "Pure virtual function call";
}


1;
# Local Variables:
# mode: cperl
# cperl-indent-level: 2
# indent-tabs-mode: nil
# tab-width: 4
# End: