# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package CommonPacker;

use XmlNode;
use Logging;

sub normalizeCountry {
    my ($country) = @_;
    return 'RU' if $country eq 'SU';
    return 'GB' if $country eq 'UK';
    return $country;
}

# Converts 'crypt' -> 'encrypted'.
sub normalizePasswordType {
  my ($type) = @_;
  return $type if ( $type eq "sym" );
  return "empty" if $type eq "empty";
  return "encrypted" if ( $type ne "plain" );
  return "plain";
}

sub makePasswordNode {
  my ($password, $type, $encoding) = @_;

  if (!defined $password) {
    Logging::debug("'undef' password passed to makePasswordNode. Set to empty");
    $password = '';
  }

  if (!$password) {
    $type = 'plain';
  } else {
    my %supportedTypes = (map {$_ => $_}  'empty', 'plain', 'sym');
    if (!exists($supportedTypes{$type})) {
      $type = 'encrypted';
    }
  }
  

  my $passwordNode = XmlNode->new('password',
                                  'content' => $password,
                                  'attributes' => {'type' => $type});
  $passwordNode->setAttribute('encoding', $encoding) if defined $encoding;
  return $passwordNode;
}


1;