# coding=utf-8
"""
Messages overrides: messages specific to GUI
"""
from parallels.core.utils.message_utils import single_line_message, multi_line_message

UNABLE_TO_PERFORM_DNS_FORWARDING_OPERATION_FOR_DOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
    Unable to %s for domain '%s', because Expand centralized DNS server serving it (IP: %s) was not described.
""")
UNABLE_TO_PERFORM_DNS_FORWARDING_OPERATION_FOR_ALL_CDNS_NOT_DESCRIBED = single_line_message("""
    Failed to %s for all domains of Plesk '%s', because associated centralized DNS server (IP: %s) was not specified.
""")
UNABLED_TO_UNDO_DNS_FORWARDING_FOR_ALL_SUBDOMAINS_CDNS_NOT_DESCRIBED = single_line_message("""
    Unable to undo the DNS forwarding for all subdomains of Plesk '%s', because associated centralized DNS server (IP:
    %s) was not described.
""")
UNABLE_UNDO_DNS_FORWARDING_FOR_SUBDOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
    Unable to undo the DNS forwarding for subdomain '%s' because Expand centralized DNS server (IP: %s) serving its DNS
    zone was not described.
""")
UNABLE_TO_SET_DNS_FORWARDING_FOR_SUBDOMAIN_CDNS_NOT_DESCRIBED = single_line_message("""
    Unable to set up the DNS forwarding for subdomain '%s' because Expand centralized DNS server (IP: %s) serving its
    DNS zone was not described.
""")
UNABLE_TO_SET_DNS_FORWARDING_FOR_ALL_SUBDOMAINS_CDNS_NOT_DESCRIBED = single_line_message("""
    Unable to set up the DNS forwarding for all subdomains of Plesk '%s', because associated centralized DNS server (IP:
    %s) was not described.
""")
FAILED_TO_LOGIN_TO_EXPAND_BY_SSH = multi_line_message("""
    Unable to login to Expand SSH service due to incorrect login/password specified.
    Set valid credentials and restart migration.
""")
CMAIL_MIGRATION_FROM_UNIX_TO_WINDOWS_NOT_SUPPORTED = single_line_message("""
    Migration from Unix centralized mail server '%s' to Plesk for Windows is not supported.
    If you want to proceed migration to Plesk you should remove that
    centralized mail server from migration configuration.
""")
FAILED_TO_LOGIN_TO_EXPAND_BY_EXPAND_API = multi_line_message("""
    Unable to login to Expand API service due to incorrect login/password specified.
    Set valid credentials and restart migration.
""")
CLIENT_DOES_NOT_EXIST = single_line_message("""
    Client '{login}' is presented neither on source Expand nor on target Plesk.
""")
SOLUTION_SPECIFY_THE_ONLY_SERVER_TO_MIGRATE_SUBSCRIPTION = single_line_message("""
    Migrate from the only server of these source servers to migrate that subscription.
""")
SOLUTION_CORRECT_SUBSCRIPTION_NAME = single_line_message("""
    Subscription can not be migrated, exclude it from migration.
""")
