import argparse
from parallels.core.cli.common_cli import Command, CommandTypes
from parallels.core.cli.extension import CLIExtensionBase
from parallels.plesk.source.custom import messages


class CLIExtension(CLIExtensionBase):
    """Command line migrator interface extension for source custom panel"""

    def get_additional_commands(self, common_options):
        """
        :type common_options: parallels.core.cli.migration_cli.CommonMigrationOptions
        :rtype: list[parallels.core.cli.common_cli.Command]
        """

        source_hosting_description_opts = argparse.ArgumentParser(add_help=False)
        source_hosting_description_opts.add_argument(
            '--source-file', action='store',
            help=messages.SOURCE_HOSTING_DESCRIPTION_FILE_OPTION
        )
        source_hosting_description_opts.add_argument(
            '--source-format', action='store',
            help=messages.SOURCE_HOSTING_DESCRIPTION_FORMAT_OPTION,
            default='yaml'
        )

        target_dump_opts = argparse.ArgumentParser(add_help=False)
        target_dump_opts.add_argument(
            '--target-file', action='store',
            help=messages.TARGET_DUMP_FILE_OPTION
        )

        return [
            Command(
                'create-dump-from-hosting-description', CommandTypes.INTERNAL,
                messages.COMMAND_CREATE_DUMP_FROM_HOSTING_DESCRIPTION,
                lambda m, o: m.create_plesk_config_dump_from_hosting_description(),
                common_options.global_options_list + [source_hosting_description_opts] + [target_dump_opts],
                is_legacy=True
            ),
            Command(
                'validate', CommandTypes.INTERNAL,
                messages.COMMAND_VALIDATE_HOSTING_DESCRIPTION,
                lambda runner: runner.run_entry_point('validate'),
                common_options.global_options_list
            ),
        ]