import posixpath

from parallels.plesk.source.cpanel.pmm_agent import CpanelPmmMigrationAgent
from parallels.core.utils import plesk_utils
import parallels.plesk.source.cpanel
from parallels.plesk.source.legacy.global_context import LegacyGlobalMigrationContext
from parallels.plesk.source.cpanel import settings


class CpanelGlobalMigrationContext(LegacyGlobalMigrationContext):
    def __init__(self):
        super(CpanelGlobalMigrationContext, self).__init__()
        self.source_has_dns_forwarding = False

    def _deploy_dump_agent(self):
        migrator_pmm_dir = posixpath.join(
            plesk_utils.get_migrator_root_path(parallels.plesk.source.cpanel),
            'extras', 'pmm'
        )
        return CpanelPmmMigrationAgent(
            self, self.conn.cpanel, migrator_pmm_dir, self.conn.source_settings
        )

    @property
    def settings(self):
        return settings