from parallels.core.utils.common import cached
from parallels.core.connections.connections import Connections
from parallels.plesk.source.cpanel.server import CpanelSourceServer
from parallels.plesk.source.cpanel import settings


class MigratorConnections(Connections):
    def __init__(self, global_context, target_panel):
        super(MigratorConnections, self).__init__(global_context, target_panel)
        self.source_settings = self.get_source_config_by_id(settings.PANEL_ID)
        self.cpanel = self.get_source_by_id(settings.PANEL_ID)

    @cached
    def get_source_config_by_id(self, source_id):
        """Return configuration of source with given identifier

        :type source_id: str
        :rtype: parallels.plesk.source.cpanel.settings.CpanelConfig
        """
        return settings.init(self._global_context.config)

    @cached
    def get_source_by_id(self, source_id):
        """Return source cPanel server with given identifier

        :type source_id: str
        :rtype: parallels.plesk.source.cpanel.server.CpanelSourceServer
        """
        source_config = self.get_source_config_by_id(source_id)
        return CpanelSourceServer(source_id, source_config, self._global_context.migrator_server)

    def get_stats_server(self):
        """Get source panel server used for statistics reporting (for example, source IP and OS version)

        Source panel could have multiple servers, but this function should return only one of them.
        If there are no source panel servers - return None
        """
        return self.cpanel

    @staticmethod
    def _get_source_config_section_names():
        """Get names of sections describing sources of data

        :rtype: list[str | unicode]
        """
        return [settings.PANEL_ID]
