from parallels.core.actions.content.web.copy_unix_content_base import CopyUnixWebContent
from parallels.plesk.source.confixx import messages
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.web.fix_unix_htaccess import FixUnixHtaccess
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.actions.base.legacy_action import LegacyAction
from parallels.plesk.source.confixx.actions.content.web.fix_permissions import FixPermissions


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-files', CopyUnixWebContent()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-permissions', FixPermissions()
        )
        workflow.get_path('check/check-data').insert_action(
            'check-additional', LegacyAction(
                description='Check additional',
                function=lambda ctx: ctx.migrator._check_additional(ctx.pre_check_report)
            )
        )

        workflow.replace_shared_action('fetch-source-shallow', CompoundAction())
        for fetch_action in ('fetch-source', 'fetch-source-shallow'):
            workflow.get_shared_action(fetch_action).insert_action(
                'fetch-data', LegacyAction(
                    description=messages.FETCH_DATA_FROM_SOURCE_CONFIXX,
                    function=lambda ctx: ctx.migrator._fetch_source(
                        ctx.options, ctx.options.reload_source_data
                    ),
                    logging_properties=LoggingProperties(info_log=False)
                )
            )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-unix-htaccess', FixUnixHtaccess()
        )
