import posixpath

from parallels.core.utils.common import cached
import parallels.plesk.source.confixx
from parallels.core.utils import plesk_utils
from parallels.plesk.source.confixx.pmm_agent import ConfixxPmmMigrationAgent
from parallels.plesk.source.confixx.utils import ConfixxConfiguration
from parallels.plesk.source.legacy.global_context import LegacyGlobalMigrationContext
from parallels.plesk.source.confixx import settings


class ConfixxGlobalMigrationContext(LegacyGlobalMigrationContext):
    def __init__(self):
        super(ConfixxGlobalMigrationContext, self).__init__()
        self.source_has_dns_forwarding = False

    @property
    @cached
    def confixx_configuration(self):
        return ConfixxConfiguration(
            self.conn.confixx,
            self.dump_agent.get_confixx_config_path()
        )

    def _deploy_dump_agent(self):
        migrator_dump_dir = posixpath.join(
            plesk_utils.get_migrator_root_path(parallels.plesk.source.confixx),
            'extras', 'pmm'
        )
        return ConfixxPmmMigrationAgent(
            self, self.conn.confixx, migrator_dump_dir, self.conn.source_settings
        )

    @property
    def settings(self):
        return settings