# coding=utf-8
"""
Messages overrides: messages specific to GUI
"""
from parallels.core.utils.message_utils import multi_line_message, single_line_message

FAILED_TO_CREATE_SERVICE_TEMPLATES_ON_TARGET = multi_line_message("""
    Failed to create the following plans on target panel:
    %s

    Migration will be stopped. To continue migration, create these plans manually on target panel.
""")
FAILED_TO_CREATE_RESELLER_PLAN_SOLUTION = multi_line_message("""
    To continue migration, create the plan manually on target panel.
""")
CLIENT_MAPPED_TO_RESELLER_THAT_DOES_NOT_EXIST_SOLUTION = single_line_message("""
    Create this reseller in destination panel
""")
# We don't have any reassignment features in GUI, so there is no solution
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_RESELLER_SOLUTION = ""
# We don't have any reassignment features in GUI, so there is no solution
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_ADMIN_RESELLER_ISSUE_SOLUTION = ""
PLAN_DOES_NOT_EXIST_SOLUTION = single_line_message("""
    Create a service template with this name
""")
CUSTOMER_DOES_NOT_EXIST_ISSUE_SOLUTION = single_line_message("""
    Create the customer with such login manually.
""")
NO_SUCH_ADMIN_RESELLER_PLAN_SOLUTION = single_line_message("""
    Create reseller plan with such name
""")

MIGRATION_ERROR_PLESK_CREDENTIALS_NOT_SPECIFIED = single_line_message("""
    Unable to access Plesk API on server '{plesk_server}' because Plesk Migrator can not retrieve credentials
    for some reason, see debug log for details
""")
