from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class RoleCli(BaseCli):
    def __init__(self, runner, role, owner):
        """Construct command to create user in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type role: parallels.core.target_data_model.AuxiliaryUserRole
        :type owner: parallels.core.target_data_model.Client | parallels.core.target_data_model.Reseller
        """
        super(RoleCli, self).__init__(runner)
        self._role = role
        self._owner = owner

    @property
    def name(self):
        return 'role'

    def _get_args(self):
        args = ['--create', self._role.name]
        if self._owner.login is not None:
            args.extend(['-owner', self._owner.login])
        else:
            args.extend(['-owner', 'admin'])
        for permission_name, is_granted in self._role.permissions.iteritems():
            if not is_granted:
                # no permissions granted by default, so no need to deny anything explicitly
                continue
            args.extend(['-%s' % permission_name, 'true'])
        args.extend(['-notify', 'false'])
        return args
