from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class ReapirSubdomainsSecurityCli(BaseCli):
    def __init__(self, runner, subscription_name):
        """Construct command to update location of security metadata
        for subdomains of given subscription in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type subscription_name: str
        """
        super(ReapirSubdomainsSecurityCli, self).__init__(runner)
        self._subscription_name = subscription_name

    @property
    def name(self):
        return 'repair'

    def _get_args(self):
        return [
            '--update-webspace-subdomains-security-metadata-location',
            '-webspace-name', self._subscription_name
        ]


class ReapirSubscriptionSecurityCli(BaseCli):
    def __init__(self, runner, subscription_name):
        """Construct command to update security metadata of given subscription in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type subscription_name: str
        """
        super(ReapirSubscriptionSecurityCli, self).__init__(runner)
        self._subscription_name = subscription_name

    @property
    def name(self):
        return 'repair'

    def _get_args(self):
        return [
            '--repair-webspace-security',
            '-webspace-name', self._subscription_name
        ]
