from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class DomainAliasCreateCli(BaseCli):
    def __init__(self, runner, domain_alias_dump, domain_name):
        """Construct command to create domain alias in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type domain_alias_dump: parallels.core.dump.data_model.DomainAlias
        :type domain_name: str
        """
        super(DomainAliasCreateCli, self).__init__(runner)
        self._domain_alias_dump = domain_alias_dump
        self._domain_name = domain_name

    @property
    def name(self):
        return 'domalias'

    def _get_args(self):
        return [
            '--create', self._domain_alias_dump.name,
            '-domain', self._domain_name,
            '-notify', 'false'
        ]
