from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class DnsRecordRemoveCli(BaseCli):
    def __init__(self, runner, domain_name, name, data):
        super(DnsRecordRemoveCli, self).__init__(runner)
        self._domain_name = domain_name
        self._name = name
        self._data = data

    @property
    def name(self):
        return 'dns'

    def _get_args(self):
        return [
            '--del', self._domain_name,
            self._get_name_arg_name(), self._name,
            self._get_data_arg_name(), self._data
        ]

    def _get_name_arg_name(self):
        raise NotImplementedError()

    def _get_data_arg_name(self):
        raise NotImplementedError()


class DnsRecordNsRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-ns'

    def _get_data_arg_name(self):
        return '-nameserver'


class DnsRecordARemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-a'

    def _get_data_arg_name(self):
        return '-ip'


class DnsRecordAaaaRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-aaaa'

    def _get_data_arg_name(self):
        return '-ip'


class DnsRecordCnameRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-cname'

    def _get_data_arg_name(self):
        return '-canonical'


class DnsRecordMxRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-mx'

    def _get_data_arg_name(self):
        return '-mailexchanger'


class DnsRecordTxtRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-domain'

    def _get_data_arg_name(self):
        return '-txt'


class DnsRecordDsRemoveCli(DnsRecordRemoveCli):
    def _get_name_arg_name(self):
        return '-domain'

    def _get_data_arg_name(self):
        return '-ds'
