from parallels.core.hosting_repository.model import HostingRepositoryModel
from parallels.plesk.hosting_repository.base import PleskBaseModel
from parallels.plesk.hosting_repository.customer import PleskCustomerModel
from parallels.plesk.hosting_repository.database import PleskDatabaseModel
from parallels.plesk.hosting_repository.database_user import PleskDatabaseUserModel
from parallels.plesk.hosting_repository.dns_record import PleskDnsRecordModel
from parallels.plesk.hosting_repository.domain import PleskDomainModel
from parallels.plesk.hosting_repository.domain_alias import PleskDomainAliasModel
from parallels.plesk.hosting_repository.extension import PleskExtensionModel
from parallels.plesk.hosting_repository.mail_account import PleskMailAccountModel
from parallels.plesk.hosting_repository.panel import PleskPanelModel
from parallels.plesk.hosting_repository.panel_user import PleskPanelUserModel
from parallels.plesk.hosting_repository.panel_user_role import PleskPanelUserRoleModel
from parallels.plesk.hosting_repository.reseller import PleskResellerModel
from parallels.plesk.hosting_repository.service_plan import PleskServicePlanModel
from parallels.plesk.hosting_repository.service_plan_addon import PleskServicePlanAddonModel
from parallels.plesk.hosting_repository.subdomain import PleskSubdomainModel
from parallels.plesk.hosting_repository.subscription import PleskSubscriptionModel


class PleskHostingRepositoryModel(HostingRepositoryModel, PleskBaseModel):
    @property
    def panel_user(self):
        """Model of Plesk panel user

        :rtype: parallels.plesk.hosting_repository.panel_user.PleskPanelUserModel
        """
        return PleskPanelUserModel(self._plesk_server)

    @property
    def panel_user_role(self):
        """Model of Plesk panel user role

        :rtype: parallels.plesk.hosting_repository.panel_user_role.PleskPanelUserRoleModel
        """
        return PleskPanelUserRoleModel(self._plesk_server)

    @property
    def reseller(self):
        """Model of Plesk reseller

        :rtype: parallels.plesk.hosting_repository.reseller.PleskResellerModel
        """
        return PleskResellerModel(self._plesk_server)

    @property
    def customer(self):
        """Model of Plesk customer

        :rtype: parallels.plesk.hosting_repository.customer.PleskCustomerModel
        """
        return PleskCustomerModel(self._plesk_server)

    @property
    def service_plan(self):
        """Model of Plesk service plan

        :rtype: parallels.plesk.hosting_repository.service_plan.PleskServicePlanModel
        """
        return PleskServicePlanModel(self._plesk_server)

    @property
    def service_plan_addon(self):
        """Model of Plesk service plan add-on

        :rtype: parallels.core.hosting_repository.service_plan_addon.ServicePlanAddonModel
        """
        return PleskServicePlanAddonModel(self._plesk_server)

    @property
    def subscription(self):
        """Model of Plesk subscription

        :rtype: parallels.plesk.hosting_repository.subscription.PleskSubscriptionModel
        """
        return PleskSubscriptionModel(self._plesk_server)

    @property
    def domain(self):
        """Model of Plesk add-on domain

        :rtype: parallels.plesk.hosting_repository.domain.PleskDomainModel
        """
        return PleskDomainModel(self._plesk_server)

    @property
    def subdomain(self):
        """Model of Plesk subdomain

        :rtype: parallels.plesk.hosting_repository.subdomain.PleskSubdomainModel
        """
        return PleskSubdomainModel(self._plesk_server)

    @property
    def domain_alias(self):
        """Model of Plesk domain alias

        :rtype: parallels.plesk.hosting_repository.domain_alias.PleskDomainAliasModel
        """
        return PleskDomainAliasModel(self._plesk_server)

    @property
    def mail_account(self):
        """Model of Plesk mail account

        :rtype: parallels.plesk.hosting_repository.mail_account.PleskMailAccountModel
        """
        return PleskMailAccountModel(self._plesk_server)

    @property
    def database(self):
        """Model of Plesk database

        :rtype: parallels.plesk.hosting_repository.database.PleskDatabaseModel
        """
        return PleskDatabaseModel(self._plesk_server)

    @property
    def database_user(self):
        """Model of Plesk database user

        :rtype: parallels.plesk.hosting_repository.database_user.PleskDatabaseUserModel
        """
        return PleskDatabaseUserModel(self._plesk_server)

    @property
    def dns_record(self):
        """Model of Plesk DNS record

        :rtype: parallels.plesk.hosting_repository.dns_record.PleskDnsRecordModel
        """
        return PleskDnsRecordModel(self._plesk_server)

    @property
    def extension(self):
        """Model Plesk extension

        :rtype: parallels.plesk.hosting_repository.extension.PleskExtensionModel
        """
        return PleskExtensionModel(self._plesk_server)

    @property
    def panel(self):
        """Model of Plesk panel

        :rtype: parallels.plesk.hosting_repository.panel.PleskPanelModel
        """
        return PleskPanelModel(self._plesk_server)
