from parallels.plesk.hosting_description.validate.validators.base import ValidatorBase
from parallels.plesk import messages


class ValidatorList(ValidatorBase):
    """Check that specified document is a list, that conforms specified restrictions for items"""

    def __init__(self, item):
        """
        :type item: parallels.plesk.hosting_description.validate.validators.base.ValidatorBase
        """
        self._item = item

    def validate(self, document, context=None):
        """Validate specified document (variable) according to current validator's rules

        Return list of found issues.

        :rtype: list[unicode]
        """
        if not self.match_type(document):
            return [self._format_error(messages.VALIDATOR_LIST_VALUE_EXPECTED, context)]

        errors = []
        for value in document:
            errors += self._item.validate(value, context)
        return errors

    def match_type(self, document):
        """Check whether data type of document matched the validator

        That is necessary condition for "validate" method not to return errors

        :rtype: bool
        """
        return isinstance(document, list)

    @property
    def item(self):
        """
        :rtype: parallels.plesk.hosting_description.validate.validators.base.ValidatorBase
        """
        return self._item

    def __repr__(self):
        return 'ValidatorList(%r)' % (self._item,)

    def __eq__(self, other):
        return isinstance(other, ValidatorList) and other.item == self.item
