import parallels.core.reports.plain_report
from parallels.core.converter.adapter.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.plesk.converter.converter import PleskConverter


class TargetPleskClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
    def convert(self, global_context, reseller_plans, hosting_plans, resellers, report):
        """Convert customers and subscriptions

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type reseller_plans: list[parallels.core.target_data_model.ResellerPlan]
        :type hosting_plans: dict[str|None, list[parallels.core.target_data_model.HostingPlan]]
        :type resellers: list[parallels.core.target_data_model.Reseller]
        :type report: parallels.core.reports.model.report.Report
        """
        skip_ip_mapping = hasattr(global_context.options, 'skip_ip_mapping') and global_context.options.skip_ip_mapping
        converter = PleskConverter(
            global_context.target_existing_objects,
            skip_ip_mapping=skip_ip_mapping,
            encrypted_passwords_supported=global_context.target_panel_obj.is_encrypted_passwords_supported()
        )

        converter.set_ip_mapping(global_context.ip_mapping)

        plain_report = parallels.core.reports.plain_report.PlainReport(
            report, global_context.migration_list_data
        )
        converter.convert_dumps(
            global_context.get_sources_info(), plain_report,
            global_context.migration_list_data.subscriptions_mapping,
            global_context.migration_list_data.customers_mapping,
            reseller_plans,
            hosting_plans,
            resellers,
            global_context.password_holder,
        )

        return converter.get_target_model()
