import logging

from parallels.core.actions.base.common_action import CommonAction
from parallels.core.migrator_config import read_adjust_applications_enabled
from parallels.core.reports.printer import print_report
from parallels.plesk import messages

logger = logging.getLogger(__name__)


class PrintApplicationAdjustReport(CommonAction):
    def get_description(self):
        """Get short description of action as string

        :rtype: str
        """
        return messages.ACTION_PRINT_ADJUST_REPORT_DESCRIPTION

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_PRINT_ADJUST_REPORT_FAILURE

    def is_critical(self):
        """If action is critical or not"""
        return False

    def filter_action(self, global_context):
        """Check whether we should run this action or not. By default True - action should be executed.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: bool
        """
        return read_adjust_applications_enabled(global_context.config)

    def run(self, global_context):
        """Run action on given subscription

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: None
        """
        print_report(global_context.application_adjust_report, 'adjusted-applications')
