from parallels.core import messages
from parallels.core.actions.base.subscription_action import SubscriptionAction
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.converter import dns as dns_converter


class ConvertDns(SubscriptionAction):
    def get_description(self):
        return messages.ACTION_CONVERT_DNS_RECORDS

    def get_logging_properties(self):
        return LoggingProperties(info_log=False)

    def get_failure_message(self, global_context, subscription):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        return messages.FAILED_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION_2 % subscription.name

    def filter_subscription(self, global_context, subscription):
        skip_ip_mapping = hasattr(global_context.options, 'skip_ip_mapping') and global_context.options.skip_ip_mapping
        if skip_ip_mapping:
            # XXX: unable to perform DNS conversion if IP-mapping was skipped, so just skip this action;
            # need to redesign workflow to avoid cases when hosting conversion could be performed w/
            # this option; probably ability to skip IP-mapping should be removed
            return False
        return True

    def run(self, global_context, subscription):
        """Make subscription DNS records resolve to target server IP.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        dns_converter.replace_resource_record_ips(subscription)
