from parallels.hosting_check.utils.text_utils import format_string
from parallels.hosting_check.messages.utils import load_messages


def MSG(message_id, **format_args):
    """Get problem/log message by its ID and format it in string.format way"""
    return format_string(
        unicode(_messages.get(message_id, message_id)),
        format_args
    )


def get_solutions(target_panel, util_name):
    """Get solutions for all known issues, by target panel
    
    Return dictionary with key - issue id, value - solution text.
    """
    solutions = load_messages('solutions/%s' % (target_panel,))
    return dict([
        (issue_type, format_string(solution, dict(util_name=util_name))) 
        for issue_type, solution in solutions.iteritems()
    ])

_messages = load_messages('problem')
