from parallels.core.registry import Registry
from parallels.core import migrator_config
from parallels.core.workflow.runner.by_subscription import ActionRunnerBySubscription


def create_action_runner():
    """Create runner according current configuration
    """
    config = Registry.get_instance().get_context().config
    if config is None:
        multithreading = None
    else:
        multithreading = migrator_config.read_multithreading_params(config)

    return ActionRunnerBySubscription(multithreading)
