from parallels.core.utils.paths.converters.unix.target import UnixTargetWebPathConverter
from parallels.core.utils.paths.converters.windows.target import WindowsTargetWebPathConverter
from parallels.core.utils.paths.copy_web_content import BaseWebPathConverter


class TargetWebPathConverter(BaseWebPathConverter):
    """Class to convert abstract path descriptor to concrete absolute path on target Plesk server"""

    def __init__(self, is_rsync=False):
        self._is_rsync = is_rsync

    def expand(self, path, server):
        """Convert abstract path descriptor to concrete absolute path on target Plesk server

        :type path: parallels.core.utils.web_paths.WebHostingPath
        :type server: parallels.plesk.connections.target_server.PleskTargetServer
        :rtype: str | unicode
        """
        if server.is_windows():
            return WindowsTargetWebPathConverter(self._is_rsync).expand(path, server)
        else:
            return UnixTargetWebPathConverter().expand(path, server)
