from parallels.core.utils.paths.converters.unix.source import UnixSourceWebPathConverter
from parallels.core.utils.paths.converters.windows.source import WindowsSourceWebPathConverter
from parallels.core.utils.paths.copy_web_content import BaseWebPathConverter


class SourceWebPathConverter(BaseWebPathConverter):
    def __init__(self, vhost_dir=None, is_rsync=False):
        self._vhost_dir = vhost_dir
        self._is_rsync = is_rsync

    def expand(self, path, server):
        """Convert abstract path descriptor to concrete absolute path for source server

        :type path: parallels.core.utils.web_paths.WebHostingPath
        :type server: parallels.core.connections.source_server.SourceServer
        :rtype: str | unicode
        """
        if server.is_windows():
            return WindowsSourceWebPathConverter(self._vhost_dir, self._is_rsync).expand(path, server)
        else:
            return UnixSourceWebPathConverter().expand(path, server)
