import logging
from contextlib import closing

from parallels.core import messages
from parallels.core.thirdparties import pymysql

logger = logging.getLogger(__name__)


def query(connection_args, query_str, query_args=None, is_result_as_dict=False):
    """Execute given MySQL query

    :type connection_args: dict
    :type query_str: str
    :type query_args: dict | None
    :type is_result_as_dict: bool
    :rtype: list | dict
    """
    log_query = query_str
    if query_args is not None:
        log_query = log_query % {k: "'%s'" % (v,) for k, v in query_args.iteritems()}
    log_server = connection_args['host'] if 'host' in connection_args else 'localhost'
    logger.debug(messages.SQL_QUERY.format(query=log_query, server=log_server))

    with closing(pymysql.connect(**connection_args)) as connection:
        with connection.cursor(pymysql.cursors.DictCursor if is_result_as_dict else None) as cursor:
            cursor.execute(query_str, query_args)
            results = cursor.fetchall()
    logger.debug(messages.SQL_QUERY_RESULTS.format(results=results))
    return results


def escape_args_list(args, prefix):
    """Prepare list of placeholders for SQL query and corresponding list of values for SQL query formatting

    :type args: list[str | int]
    :type prefix: str
    :rtype: list[str], dict[str]
    """
    placeholders = []
    values = {}
    for i, arg in enumerate(args):
        key = '%s_%s' % (prefix, i)
        placeholders.append('%(' + key + ')s')
        values[key] = arg
    return placeholders, values
