import logging
from parallels.core.migrator_config import is_hosting_analyser_enabled

from parallels.plesk.hosting_analyser.hosting_analyser import HostingAnalyser

logger = logging.getLogger(__name__)


def apply_hosting_analyser_strategy(global_context, subscription, rsync_additional_args):
    """
    :type global_context: parallels.core.global_context.GlobalMigrationContext
    """
    if not global_context.hosting_analyzer_enabled:
        return

    if is_hosting_analyser_enabled(global_context.config):
        # choose transfer strategy
        hosting_analyser = HostingAnalyser(global_context.migrator_server)
        transfer_strategy = hosting_analyser.get_webspace_actual_transfer_strategy(subscription)
        if rsync_additional_args.count('-z') == 0 and transfer_strategy.need_compression:
            rsync_additional_args.append('-z')
            if transfer_strategy.compression_level is not None:
                rsync_additional_args.append('--compress-level={compression_level}'.format(
                    compression_level=transfer_strategy.compression_level
                ))