"""Color configuration for console logging

Check documentation of "colorama" library (https://github.com/tartley/colorama)
for more details on available colors.
"""

from parallels.core.thirdparties.colorama import Style, Fore
from parallels.core.utils.common import is_run_on_windows

# Foreground colors
FORE_COLORS = {
    # Parts: 'time', 'level', 'message', 'context'
    'time': {
        # Colors by level: 'default', 'error', 'warning'
        'default': Fore.LIGHTWHITE_EX
    },
    'level': {
        'default': Fore.GREEN,
        'error': Fore.RED,
        'warning': Fore.YELLOW
    },
    'message': {
        'default': None,
        'error': Fore.RED,
        'warning': Fore.YELLOW
    },
    'context': {
        'default': None
    },
}
# Background colors
BACK_COLORS = {
}

# Styles
if is_run_on_windows():
    STYLES = {
        'time': {
            'default': Style.BRIGHT
        },
        'level': {
            'default': Style.BRIGHT,
        },
        'message': {
            'default': None,
            'error': Style.BRIGHT,
            'warning': Style.BRIGHT
        },
        'context': {
            'default': Style.BRIGHT
        },
    }
else:
    STYLES = {

    }

