from parallels.core.utils.entity import Entity


class SubscriptionServiceIPs(Entity):
    def __init__(self, v4=None, v6=None):
        """
        :type v4: str | None
        :type v6: str | None
        """
        self._v4 = v4
        self._v6 = v6

    @property
    def v4(self):
        """
        :rtype: str | None
        """
        return self._v4

    @property
    def v6(self):
        """
        :rtype: str | None
        """
        return self._v6


class TargetServices(Entity):
    def __init__(self, web_ips, mail_ips, db_servers, dns_ips):
        """
        :type web_ips: parallels.core.subscription_target_info.SubscriptionServiceIPs
        :type mail_ips: parallels.core.subscription_target_info.SubscriptionServiceIPs
        :type db_servers: dict[str, parallels.plesk.utils.xml_rpc.plesk.operator.db_server.DbServerInfo]
        :type dns_ips: list[parallels.core.subscription_target_info.SubscriptionServiceIPs]
        """
        self._web_ips = web_ips
        self._mail_ips = mail_ips
        self._db_servers = db_servers
        self._dns_ips = dns_ips

    @property
    def web_ips(self):
        """
        :rtype: parallels.core.subscription_target_info.SubscriptionServiceIPs
        """
        return self._web_ips

    @property
    def mail_ips(self):
        """
        :rtype: parallels.core.subscription_target_info.SubscriptionServiceIPs
        """
        return self._mail_ips

    @property
    def db_servers(self):
        """
        :rtype: dict[str, parallels.plesk.utils.xml_rpc.plesk.operator.db_server.DbServerInfo]
        """
        return self._db_servers

    @property
    def dns_ips(self):
        """
        :rtype: list[parallels.core.subscription_target_info.SubscriptionServiceIPs]
        """
        return self._dns_ips


class TargetServers(Entity):
    def __init__(self, web, mail, database, dns):
        """
        :type web: parallels.core.connections.target_servers.TargetServer | None
        :type mail: parallels.core.connections.target_servers.TargetServer | None
        :type database: dict[str, parallels.core.connections.database_servers.base.DatabaseServer | None]
        :type dns: list[parallels.core.connections.target_servers.TargetServer]
        """
        self._web = web
        self._mail = mail
        self._database = database
        self._dns = dns

    @property
    def web(self):
        """
        :rtype: parallels.core.connections.target_servers.TargetServer | None
        """
        return self._web

    @property
    def mail(self):
        """
        :rtype: parallels.core.connections.target_servers.TargetServer | None
        """
        return self._mail

    @property
    def database(self):
        """
        :rtype: dict[str, parallels.core.connections.database_servers.base.DatabaseServer | None]
        """
        return self._database

    @property
    def dns(self):
        """
        :rtype: list[parallels.core.connections.target_servers.TargetServer]
        """
        return self._dns
