from parallels.core.runners.base import BaseRunner
from parallels.core.utils import unix_utils


class UnixRunner(BaseRunner):
    def _format_run_command(self, cmd, args=None):
        """Format command arguments passed for 'run' and 'run_unchecked' methods into command line string

        This command line will be added to log and error messages, so it is expected that you could
        simply copy-paste it from logs or migrator output, and execute.

        :type cmd: str | unicode
        :type args: list[str | unicode] | None
        :rtype: str | unicode
        """
        return unix_utils.format_command_list(cmd, args)

    def _format_sh_command(self, cmd, args=None):
        """Format command arguments passed for 'sh' and 'sh_unchecked' methods into command line string

        This command line will be added to log and error messages, so it is expected that you could
        simply copy-paste it from logs or migrator output, and execute.

        :type cmd: str | unicode
        :type args: dict[str | unicode, str | unicode] | None
        """
        if args is not None and len(args) > 0:
            return unix_utils.format_command(cmd, **args)
        else:
            return cmd
