from parallels.core.runners.exceptions.base import BaseRunnerException


class NonZeroExitCodeException(BaseRunnerException):
    """Exception thrown when executed command returned non-zero exit code (so, command failed to execute)"""

    def __init__(self, message, exit_code, stdout, stderr):
        """Class constructor

        :type message: str | unicode
        :type exit_code: int
        :type stdout: str | unicode
        :type stderr: str | unicode
        """
        super(BaseRunnerException, self).__init__(message)
        self._exit_code = exit_code
        self._stdout = stdout
        self._stderr = stderr

    @property
    def exit_code(self):
        """Exit code of the failed command

        :rtype: int
        """
        return self._exit_code

    @property
    def stdout(self):
        """Stdout of the failed command

        :rtype: str | unicode
        """
        return self._stdout

    @property
    def stderr(self):
        """Stderr of the failed command

        :rtype: str | unicode
        """
        return self._stderr
