from parallels.core.utils.entity import Entity


class AffectedObject(Entity):
    """Object affected by report issue"""

    TYPE_SUBSCRIPTION = "subscription"
    TYPE_MSSQL_SERVER = "mssql-server"

    def __init__(self, object_type, name):
        """Class constructor

        :param str|unicode object_type: type of the object (see TYPE_* constants)
        :param str|unicode name: name of the object
        """
        self._object_type = object_type
        self._name = name

    @property
    def object_type(self):
        """Type of the object (see TYPE_* constants)

        :rtype: str | unicode
        """
        return self._object_type

    @property
    def name(self):
        """Name of the object (e.g. subscription name)

        :rtype: str | unicode
        """
        return self._name