from parallels.core.migration_list.writer.base_writer import MigrationListWriterBase
from parallels.core.utils.json_utils import write_json


class MigrationListWriterJSON(MigrationListWriterBase):
    def write_initial(
        self, filename,
        target_subscriptions, target_service_plans, target_addon_service_plans,
        comment_existing_subscriptions=True
    ):
        subscriptions = self._source_data.extract_subscriptions(
            subscription_filter=None, subscriptions_mapping=None
        )
        reseller_plans = self._source_data.get_reseller_plans()
        reseller_contacts = self._source_data.get_reseller_contacts()
        customer_owners = self._source_data.get_customer_owners()
        customer_contacts = self._source_data.get_customer_contacts()
        plans = self._source_data.get_plans(target_service_plans, addon_plans=False)
        addon_plans = self._source_data.get_plans(target_addon_service_plans, addon_plans=True)

        data = {
            'subscriptions': {
                subscription.name: {
                    'plan': subscription.plan,
                    'addon_plans': list(subscription.addon_plans),
                    'owner': subscription.customer or subscription.reseller,
                    'exists_on_target': subscription.name in target_subscriptions
                }
                for subscription in subscriptions
            },
            'resellers': {
                reseller_login: {
                    'plan': reseller_plan,
                    'contact_name': reseller_contacts.get(reseller_login)
                }
                for reseller_login, reseller_plan in reseller_plans.iteritems()
            },
            'customers': {
                customer_login: {
                    'owner': owner_login,
                    'contact_name': customer_contacts.get(customer_login)
                } for customer_login, owner_login in customer_owners.iteritems()
            },
            'plans': [
                {
                    'name': plan_name,
                    'owner': plan_owner,
                    'exists_on_target': exists_on_target
                }
                for plan_owner, owner_plans in plans.iteritems()
                for plan_name, exists_on_target in owner_plans.iteritems()
            ],
            'addon_plans': [
                {
                    'name': plan_name,
                    'owner': plan_owner,
                    'exists_on_target': exists_on_target
                }
                for plan_owner, owner_plans, in addon_plans.iteritems()
                for plan_name, exists_on_target in owner_plans.iteritems()
            ]
        }

        write_json(filename, data, pretty_print=True)
