class MigrationListPlans(object):
    def __init__(self, plans=None, addon_plans=None):
        """
        :param dict[basestring | None, list[basestring]] plans: Dictionary of hosting plan names
        :param dict[basestring | None, list[basestring]] addon_plans: Dictionary of addon hosting plan names
        """
        if plans is not None:
            self._plans = plans
        else:
            self._plans = {}

        if addon_plans is not None:
            self._addon_plans = addon_plans
        else:
            self._addon_plans = {}

    @property
    def plans(self):
        """Hosting plans - dictionary with reseller name as key (None for admin), list of plan names as value

        :rtype: dict[str | unicode | None, list[str | unicode]]
        """
        return self._plans

    @property
    def addon_plans(self):
        """Addon hosting plans - dictionary with reseller name as key (None for admin), list of plan names as value

        :rtype: dict[str | unicode | None, list[str | unicode]]
        """
        return self._addon_plans

    def __eq__(self, other):
        return (
            isinstance(other, MigrationListPlans) and
            self.plans == other.plans and
            self.addon_plans == other.addon_plans
        )
