from parallels.core.utils.entity import Entity


class ResellerModel(object):
    def get_list(self, filter_username):
        """Retrieve list of resellers from target panel which username listed in given filter

        :type filter_username: list[str]
        :rtype: list[parallels.core.hosting_repository.reseller.ResellerEntity]
        """
        raise NotImplementedError()

    def get_by_username(self, username):
        """Retrieve reseller with given username from target panel

        :type username: str
        :rtype: parallels.core.hosting_repository.reseller.ResellerEntity
        """
        resellers = self.get_list(filter_username=[username])
        return resellers.pop() if len(resellers) > 0 else None

    def create(self, reseller):
        """Create given reseller in target panel; return id of created reseller and list detected errors

        :type reseller: parallels.core.target_data_model.Reseller
        :rtype: int, list[str]
        """
        raise NotImplementedError()

    def set_external_id(self, username, external_id):
        """Set External ID for given reseller in target panel

        :type username: str
        :type external_id: str
        """
        raise NotImplementedError()


class ResellerEntity(Entity):
    def __init__(self, reseller_id, username, first_name, last_name, email):
        self._id = reseller_id
        self._username = username
        self._first_name = first_name
        self._last_name = last_name
        self._email = email

    @property
    def reseller_id(self):
        return self._id

    @property
    def username(self):
        return self._username

    @property
    def first_name(self):
        return self._first_name

    @property
    def last_name(self):
        return self._last_name

    @property
    def email(self):
        return self._email
