class MailAccountModel(object):
    def create_from_dump(self, mail_account_dump):
        """Create mail account in target panel

        :type mail_account_dump: parallels.core.dump.entity.mail_account.MailAccount
        """
        raise NotImplementedError()

    def set_forwarding(self, mail_account_name, is_enable_forwarding, forwarding_addresses):
        """Set forwarding for given mail account in target panel

        :type mail_account_name: str
        :type is_enable_forwarding: bool
        :type forwarding_addresses: list[str]
        """
        raise NotImplementedError()

    def set_aliases(self, mail_account_name, aliases):
        """Set aliases for given mail account in target panel

        :type mail_account_name: str
        :type aliases: list[str]
        """
        raise NotImplementedError

    def is_exists(self, mail_user_name, domain_name):
        """Check if mail account with given name exists in target panel

        :type mail_user_name: str
        :type domain_name: str
        :rtype: bool
        """
        raise NotImplementedError()
